// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityHaNetworkGetReader is a Reader for the SecurityHaNetworkGet structure.
type SecurityHaNetworkGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityHaNetworkGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityHaNetworkGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityHaNetworkGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityHaNetworkGetOK creates a SecurityHaNetworkGetOK with default headers values
func NewSecurityHaNetworkGetOK() *SecurityHaNetworkGetOK {
	return &SecurityHaNetworkGetOK{}
}

/*
SecurityHaNetworkGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityHaNetworkGetOK struct {
	Payload *models.SecurityHaNetwork
}

// IsSuccess returns true when this security ha network get o k response has a 2xx status code
func (o *SecurityHaNetworkGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security ha network get o k response has a 3xx status code
func (o *SecurityHaNetworkGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security ha network get o k response has a 4xx status code
func (o *SecurityHaNetworkGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security ha network get o k response has a 5xx status code
func (o *SecurityHaNetworkGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security ha network get o k response a status code equal to that given
func (o *SecurityHaNetworkGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security ha network get o k response
func (o *SecurityHaNetworkGetOK) Code() int {
	return 200
}

func (o *SecurityHaNetworkGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ha-network][%d] securityHaNetworkGetOK %s", 200, payload)
}

func (o *SecurityHaNetworkGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ha-network][%d] securityHaNetworkGetOK %s", 200, payload)
}

func (o *SecurityHaNetworkGetOK) GetPayload() *models.SecurityHaNetwork {
	return o.Payload
}

func (o *SecurityHaNetworkGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityHaNetwork)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityHaNetworkGetDefault creates a SecurityHaNetworkGetDefault with default headers values
func NewSecurityHaNetworkGetDefault(code int) *SecurityHaNetworkGetDefault {
	return &SecurityHaNetworkGetDefault{
		_statusCode: code,
	}
}

/*
SecurityHaNetworkGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityHaNetworkGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security ha network get default response has a 2xx status code
func (o *SecurityHaNetworkGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security ha network get default response has a 3xx status code
func (o *SecurityHaNetworkGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security ha network get default response has a 4xx status code
func (o *SecurityHaNetworkGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security ha network get default response has a 5xx status code
func (o *SecurityHaNetworkGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security ha network get default response a status code equal to that given
func (o *SecurityHaNetworkGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security ha network get default response
func (o *SecurityHaNetworkGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityHaNetworkGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ha-network][%d] security_ha_network_get default %s", o._statusCode, payload)
}

func (o *SecurityHaNetworkGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ha-network][%d] security_ha_network_get default %s", o._statusCode, payload)
}

func (o *SecurityHaNetworkGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityHaNetworkGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
