// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityHaNetworkModifyParams creates a new SecurityHaNetworkModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityHaNetworkModifyParams() *SecurityHaNetworkModifyParams {
	return &SecurityHaNetworkModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityHaNetworkModifyParamsWithTimeout creates a new SecurityHaNetworkModifyParams object
// with the ability to set a timeout on a request.
func NewSecurityHaNetworkModifyParamsWithTimeout(timeout time.Duration) *SecurityHaNetworkModifyParams {
	return &SecurityHaNetworkModifyParams{
		timeout: timeout,
	}
}

// NewSecurityHaNetworkModifyParamsWithContext creates a new SecurityHaNetworkModifyParams object
// with the ability to set a context for a request.
func NewSecurityHaNetworkModifyParamsWithContext(ctx context.Context) *SecurityHaNetworkModifyParams {
	return &SecurityHaNetworkModifyParams{
		Context: ctx,
	}
}

// NewSecurityHaNetworkModifyParamsWithHTTPClient creates a new SecurityHaNetworkModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityHaNetworkModifyParamsWithHTTPClient(client *http.Client) *SecurityHaNetworkModifyParams {
	return &SecurityHaNetworkModifyParams{
		HTTPClient: client,
	}
}

/*
SecurityHaNetworkModifyParams contains all the parameters to send to the API endpoint

	for the security ha network modify operation.

	Typically these are written to a http.Request.
*/
type SecurityHaNetworkModifyParams struct {

	/* Enabled.

	   Specifies if HA network security is enabled.
	*/
	Enabled *bool

	/* Info.

	   Specifies for which HA pair HA network security is to be enabled or disabled.
	*/
	Info *models.SecurityHaNetwork

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security ha network modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityHaNetworkModifyParams) WithDefaults() *SecurityHaNetworkModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security ha network modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityHaNetworkModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) WithTimeout(timeout time.Duration) *SecurityHaNetworkModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) WithContext(ctx context.Context) *SecurityHaNetworkModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) WithHTTPClient(client *http.Client) *SecurityHaNetworkModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) WithEnabled(enabled *bool) *SecurityHaNetworkModifyParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) WithInfo(info *models.SecurityHaNetwork) *SecurityHaNetworkModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security ha network modify params
func (o *SecurityHaNetworkModifyParams) SetInfo(info *models.SecurityHaNetwork) {
	o.Info = info
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityHaNetworkModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
