// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityHaNetworkModifyReader is a Reader for the SecurityHaNetworkModify structure.
type SecurityHaNetworkModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityHaNetworkModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityHaNetworkModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityHaNetworkModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityHaNetworkModifyOK creates a SecurityHaNetworkModifyOK with default headers values
func NewSecurityHaNetworkModifyOK() *SecurityHaNetworkModifyOK {
	return &SecurityHaNetworkModifyOK{}
}

/*
SecurityHaNetworkModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecurityHaNetworkModifyOK struct {
}

// IsSuccess returns true when this security ha network modify o k response has a 2xx status code
func (o *SecurityHaNetworkModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security ha network modify o k response has a 3xx status code
func (o *SecurityHaNetworkModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security ha network modify o k response has a 4xx status code
func (o *SecurityHaNetworkModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security ha network modify o k response has a 5xx status code
func (o *SecurityHaNetworkModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security ha network modify o k response a status code equal to that given
func (o *SecurityHaNetworkModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security ha network modify o k response
func (o *SecurityHaNetworkModifyOK) Code() int {
	return 200
}

func (o *SecurityHaNetworkModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/ha-network][%d] securityHaNetworkModifyOK", 200)
}

func (o *SecurityHaNetworkModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/ha-network][%d] securityHaNetworkModifyOK", 200)
}

func (o *SecurityHaNetworkModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityHaNetworkModifyDefault creates a SecurityHaNetworkModifyDefault with default headers values
func NewSecurityHaNetworkModifyDefault(code int) *SecurityHaNetworkModifyDefault {
	return &SecurityHaNetworkModifyDefault{
		_statusCode: code,
	}
}

/*
	SecurityHaNetworkModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70385664 | Modifying the HA network security configuration requires an effective HA version of ONTAP 9.18.1 or later. |
| 70385666 | Failed to get node information for node \"<name>\". |
| 70385667 | Failed to enable encryption on node \"<name>\". |
| 70385671 | Failed to disable encryption on node \"<name>\". |
| 70385673 | HA network security does not support MetroCluster configurations. |
| 70385677 | Failed to modify HA network security because the \"enabled\" field was not specified. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityHaNetworkModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security ha network modify default response has a 2xx status code
func (o *SecurityHaNetworkModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security ha network modify default response has a 3xx status code
func (o *SecurityHaNetworkModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security ha network modify default response has a 4xx status code
func (o *SecurityHaNetworkModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security ha network modify default response has a 5xx status code
func (o *SecurityHaNetworkModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security ha network modify default response a status code equal to that given
func (o *SecurityHaNetworkModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security ha network modify default response
func (o *SecurityHaNetworkModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecurityHaNetworkModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ha-network][%d] security_ha_network_modify default %s", o._statusCode, payload)
}

func (o *SecurityHaNetworkModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ha-network][%d] security_ha_network_modify default %s", o._statusCode, payload)
}

func (o *SecurityHaNetworkModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityHaNetworkModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
