// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityJitPrivilegeCollectionGetParams creates a new SecurityJitPrivilegeCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityJitPrivilegeCollectionGetParams() *SecurityJitPrivilegeCollectionGetParams {
	return &SecurityJitPrivilegeCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityJitPrivilegeCollectionGetParamsWithTimeout creates a new SecurityJitPrivilegeCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityJitPrivilegeCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityJitPrivilegeCollectionGetParams {
	return &SecurityJitPrivilegeCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityJitPrivilegeCollectionGetParamsWithContext creates a new SecurityJitPrivilegeCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityJitPrivilegeCollectionGetParamsWithContext(ctx context.Context) *SecurityJitPrivilegeCollectionGetParams {
	return &SecurityJitPrivilegeCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityJitPrivilegeCollectionGetParamsWithHTTPClient creates a new SecurityJitPrivilegeCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityJitPrivilegeCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityJitPrivilegeCollectionGetParams {
	return &SecurityJitPrivilegeCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityJitPrivilegeCollectionGetParams contains all the parameters to send to the API endpoint

	for the security jit privilege collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityJitPrivilegeCollectionGetParams struct {

	/* Application.

	   Filter by application
	*/
	Application *string

	/* DefaultSessionValidityPeriod.

	   Filter by default_session_validity_period
	*/
	DefaultSessionValidityPeriod *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxJitValidityPeriod.

	   Filter by max_jit_validity_period
	*/
	MaxJitValidityPeriod *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security jit privilege collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeCollectionGetParams) WithDefaults() *SecurityJitPrivilegeCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security jit privilege collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityJitPrivilegeCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityJitPrivilegeCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithContext(ctx context.Context) *SecurityJitPrivilegeCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityJitPrivilegeCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplication adds the application to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithApplication(application *string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetApplication(application *string) {
	o.Application = application
}

// WithDefaultSessionValidityPeriod adds the defaultSessionValidityPeriod to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithDefaultSessionValidityPeriod(defaultSessionValidityPeriod *string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetDefaultSessionValidityPeriod(defaultSessionValidityPeriod)
	return o
}

// SetDefaultSessionValidityPeriod adds the defaultSessionValidityPeriod to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetDefaultSessionValidityPeriod(defaultSessionValidityPeriod *string) {
	o.DefaultSessionValidityPeriod = defaultSessionValidityPeriod
}

// WithFields adds the fields to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithFields(fields []string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxJitValidityPeriod adds the maxJitValidityPeriod to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithMaxJitValidityPeriod(maxJitValidityPeriod *string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetMaxJitValidityPeriod(maxJitValidityPeriod)
	return o
}

// SetMaxJitValidityPeriod adds the maxJitValidityPeriod to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetMaxJitValidityPeriod(maxJitValidityPeriod *string) {
	o.MaxJitValidityPeriod = maxJitValidityPeriod
}

// WithMaxRecords adds the maxRecords to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityJitPrivilegeCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithOrderBy(orderBy []string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithOwnerName(ownerName *string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithOwnerUUID(ownerUUID *string) *SecurityJitPrivilegeCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityJitPrivilegeCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityJitPrivilegeCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security jit privilege collection get params
func (o *SecurityJitPrivilegeCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityJitPrivilegeCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Application != nil {

		// query param application
		var qrApplication string

		if o.Application != nil {
			qrApplication = *o.Application
		}
		qApplication := qrApplication
		if qApplication != "" {

			if err := r.SetQueryParam("application", qApplication); err != nil {
				return err
			}
		}
	}

	if o.DefaultSessionValidityPeriod != nil {

		// query param default_session_validity_period
		var qrDefaultSessionValidityPeriod string

		if o.DefaultSessionValidityPeriod != nil {
			qrDefaultSessionValidityPeriod = *o.DefaultSessionValidityPeriod
		}
		qDefaultSessionValidityPeriod := qrDefaultSessionValidityPeriod
		if qDefaultSessionValidityPeriod != "" {

			if err := r.SetQueryParam("default_session_validity_period", qDefaultSessionValidityPeriod); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxJitValidityPeriod != nil {

		// query param max_jit_validity_period
		var qrMaxJitValidityPeriod string

		if o.MaxJitValidityPeriod != nil {
			qrMaxJitValidityPeriod = *o.MaxJitValidityPeriod
		}
		qMaxJitValidityPeriod := qrMaxJitValidityPeriod
		if qMaxJitValidityPeriod != "" {

			if err := r.SetQueryParam("max_jit_validity_period", qMaxJitValidityPeriod); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityJitPrivilegeCollectionGet binds the parameter fields
func (o *SecurityJitPrivilegeCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityJitPrivilegeCollectionGet binds the parameter order_by
func (o *SecurityJitPrivilegeCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
