// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityJitPrivilegeGetParams creates a new SecurityJitPrivilegeGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityJitPrivilegeGetParams() *SecurityJitPrivilegeGetParams {
	return &SecurityJitPrivilegeGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityJitPrivilegeGetParamsWithTimeout creates a new SecurityJitPrivilegeGetParams object
// with the ability to set a timeout on a request.
func NewSecurityJitPrivilegeGetParamsWithTimeout(timeout time.Duration) *SecurityJitPrivilegeGetParams {
	return &SecurityJitPrivilegeGetParams{
		timeout: timeout,
	}
}

// NewSecurityJitPrivilegeGetParamsWithContext creates a new SecurityJitPrivilegeGetParams object
// with the ability to set a context for a request.
func NewSecurityJitPrivilegeGetParamsWithContext(ctx context.Context) *SecurityJitPrivilegeGetParams {
	return &SecurityJitPrivilegeGetParams{
		Context: ctx,
	}
}

// NewSecurityJitPrivilegeGetParamsWithHTTPClient creates a new SecurityJitPrivilegeGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityJitPrivilegeGetParamsWithHTTPClient(client *http.Client) *SecurityJitPrivilegeGetParams {
	return &SecurityJitPrivilegeGetParams{
		HTTPClient: client,
	}
}

/*
SecurityJitPrivilegeGetParams contains all the parameters to send to the API endpoint

	for the security jit privilege get operation.

	Typically these are written to a http.Request.
*/
type SecurityJitPrivilegeGetParams struct {

	/* Application.

	   Application name.
	*/
	Application string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   Used to identify a cluster or an SVM.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security jit privilege get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeGetParams) WithDefaults() *SecurityJitPrivilegeGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security jit privilege get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) WithTimeout(timeout time.Duration) *SecurityJitPrivilegeGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) WithContext(ctx context.Context) *SecurityJitPrivilegeGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) WithHTTPClient(client *http.Client) *SecurityJitPrivilegeGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplication adds the application to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) WithApplication(application string) *SecurityJitPrivilegeGetParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) SetApplication(application string) {
	o.Application = application
}

// WithFields adds the fields to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) WithFields(fields []string) *SecurityJitPrivilegeGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) WithOwnerUUID(ownerUUID string) *SecurityJitPrivilegeGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security jit privilege get params
func (o *SecurityJitPrivilegeGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityJitPrivilegeGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application
	if err := r.SetPathParam("application", o.Application); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityJitPrivilegeGet binds the parameter fields
func (o *SecurityJitPrivilegeGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
