// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityJitPrivilegeGetReader is a Reader for the SecurityJitPrivilegeGet structure.
type SecurityJitPrivilegeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityJitPrivilegeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityJitPrivilegeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityJitPrivilegeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityJitPrivilegeGetOK creates a SecurityJitPrivilegeGetOK with default headers values
func NewSecurityJitPrivilegeGetOK() *SecurityJitPrivilegeGetOK {
	return &SecurityJitPrivilegeGetOK{}
}

/*
SecurityJitPrivilegeGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityJitPrivilegeGetOK struct {
	Payload *models.SecurityJitPrivilege
}

// IsSuccess returns true when this security jit privilege get o k response has a 2xx status code
func (o *SecurityJitPrivilegeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security jit privilege get o k response has a 3xx status code
func (o *SecurityJitPrivilegeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security jit privilege get o k response has a 4xx status code
func (o *SecurityJitPrivilegeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security jit privilege get o k response has a 5xx status code
func (o *SecurityJitPrivilegeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security jit privilege get o k response a status code equal to that given
func (o *SecurityJitPrivilegeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security jit privilege get o k response
func (o *SecurityJitPrivilegeGetOK) Code() int {
	return 200
}

func (o *SecurityJitPrivilegeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/jit-privileges/{owner.uuid}/{application}][%d] securityJitPrivilegeGetOK %s", 200, payload)
}

func (o *SecurityJitPrivilegeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/jit-privileges/{owner.uuid}/{application}][%d] securityJitPrivilegeGetOK %s", 200, payload)
}

func (o *SecurityJitPrivilegeGetOK) GetPayload() *models.SecurityJitPrivilege {
	return o.Payload
}

func (o *SecurityJitPrivilegeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityJitPrivilege)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityJitPrivilegeGetDefault creates a SecurityJitPrivilegeGetDefault with default headers values
func NewSecurityJitPrivilegeGetDefault(code int) *SecurityJitPrivilegeGetDefault {
	return &SecurityJitPrivilegeGetDefault{
		_statusCode: code,
	}
}

/*
SecurityJitPrivilegeGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityJitPrivilegeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security jit privilege get default response has a 2xx status code
func (o *SecurityJitPrivilegeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security jit privilege get default response has a 3xx status code
func (o *SecurityJitPrivilegeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security jit privilege get default response has a 4xx status code
func (o *SecurityJitPrivilegeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security jit privilege get default response has a 5xx status code
func (o *SecurityJitPrivilegeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security jit privilege get default response a status code equal to that given
func (o *SecurityJitPrivilegeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security jit privilege get default response
func (o *SecurityJitPrivilegeGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityJitPrivilegeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/jit-privileges/{owner.uuid}/{application}][%d] security_jit_privilege_get default %s", o._statusCode, payload)
}

func (o *SecurityJitPrivilegeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/jit-privileges/{owner.uuid}/{application}][%d] security_jit_privilege_get default %s", o._statusCode, payload)
}

func (o *SecurityJitPrivilegeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityJitPrivilegeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
