// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityJitPrivilegeModifyCollectionParams creates a new SecurityJitPrivilegeModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityJitPrivilegeModifyCollectionParams() *SecurityJitPrivilegeModifyCollectionParams {
	return &SecurityJitPrivilegeModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityJitPrivilegeModifyCollectionParamsWithTimeout creates a new SecurityJitPrivilegeModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityJitPrivilegeModifyCollectionParamsWithTimeout(timeout time.Duration) *SecurityJitPrivilegeModifyCollectionParams {
	return &SecurityJitPrivilegeModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityJitPrivilegeModifyCollectionParamsWithContext creates a new SecurityJitPrivilegeModifyCollectionParams object
// with the ability to set a context for a request.
func NewSecurityJitPrivilegeModifyCollectionParamsWithContext(ctx context.Context) *SecurityJitPrivilegeModifyCollectionParams {
	return &SecurityJitPrivilegeModifyCollectionParams{
		Context: ctx,
	}
}

// NewSecurityJitPrivilegeModifyCollectionParamsWithHTTPClient creates a new SecurityJitPrivilegeModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityJitPrivilegeModifyCollectionParamsWithHTTPClient(client *http.Client) *SecurityJitPrivilegeModifyCollectionParams {
	return &SecurityJitPrivilegeModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityJitPrivilegeModifyCollectionParams contains all the parameters to send to the API endpoint

	for the security jit privilege modify collection operation.

	Typically these are written to a http.Request.
*/
type SecurityJitPrivilegeModifyCollectionParams struct {

	/* Application.

	   Filter by application
	*/
	Application *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DefaultSessionValidityPeriod.

	   Filter by default_session_validity_period
	*/
	DefaultSessionValidityPeriod *string

	/* Info.

	   Info specification
	*/
	Info SecurityJitPrivilegeModifyCollectionBody

	/* MaxJitValidityPeriod.

	   Filter by max_jit_validity_period
	*/
	MaxJitValidityPeriod *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security jit privilege modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeModifyCollectionParams) WithDefaults() *SecurityJitPrivilegeModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security jit privilege modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityJitPrivilegeModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithTimeout(timeout time.Duration) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithContext(ctx context.Context) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithHTTPClient(client *http.Client) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplication adds the application to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithApplication(application *string) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetApplication(application *string) {
	o.Application = application
}

// WithContinueOnFailure adds the continueOnFailure to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDefaultSessionValidityPeriod adds the defaultSessionValidityPeriod to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithDefaultSessionValidityPeriod(defaultSessionValidityPeriod *string) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetDefaultSessionValidityPeriod(defaultSessionValidityPeriod)
	return o
}

// SetDefaultSessionValidityPeriod adds the defaultSessionValidityPeriod to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetDefaultSessionValidityPeriod(defaultSessionValidityPeriod *string) {
	o.DefaultSessionValidityPeriod = defaultSessionValidityPeriod
}

// WithInfo adds the info to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithInfo(info SecurityJitPrivilegeModifyCollectionBody) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetInfo(info SecurityJitPrivilegeModifyCollectionBody) {
	o.Info = info
}

// WithMaxJitValidityPeriod adds the maxJitValidityPeriod to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithMaxJitValidityPeriod(maxJitValidityPeriod *string) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetMaxJitValidityPeriod(maxJitValidityPeriod)
	return o
}

// SetMaxJitValidityPeriod adds the maxJitValidityPeriod to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetMaxJitValidityPeriod(maxJitValidityPeriod *string) {
	o.MaxJitValidityPeriod = maxJitValidityPeriod
}

// WithOwnerName adds the ownerName to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithOwnerName(ownerName *string) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithOwnerUUID(ownerUUID *string) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityJitPrivilegeModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security jit privilege modify collection params
func (o *SecurityJitPrivilegeModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityJitPrivilegeModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Application != nil {

		// query param application
		var qrApplication string

		if o.Application != nil {
			qrApplication = *o.Application
		}
		qApplication := qrApplication
		if qApplication != "" {

			if err := r.SetQueryParam("application", qApplication); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DefaultSessionValidityPeriod != nil {

		// query param default_session_validity_period
		var qrDefaultSessionValidityPeriod string

		if o.DefaultSessionValidityPeriod != nil {
			qrDefaultSessionValidityPeriod = *o.DefaultSessionValidityPeriod
		}
		qDefaultSessionValidityPeriod := qrDefaultSessionValidityPeriod
		if qDefaultSessionValidityPeriod != "" {

			if err := r.SetQueryParam("default_session_validity_period", qDefaultSessionValidityPeriod); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.MaxJitValidityPeriod != nil {

		// query param max_jit_validity_period
		var qrMaxJitValidityPeriod string

		if o.MaxJitValidityPeriod != nil {
			qrMaxJitValidityPeriod = *o.MaxJitValidityPeriod
		}
		qMaxJitValidityPeriod := qrMaxJitValidityPeriod
		if qMaxJitValidityPeriod != "" {

			if err := r.SetQueryParam("max_jit_validity_period", qMaxJitValidityPeriod); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
