// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityJitPrivilegeModifyCollectionReader is a Reader for the SecurityJitPrivilegeModifyCollection structure.
type SecurityJitPrivilegeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityJitPrivilegeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityJitPrivilegeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityJitPrivilegeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityJitPrivilegeModifyCollectionOK creates a SecurityJitPrivilegeModifyCollectionOK with default headers values
func NewSecurityJitPrivilegeModifyCollectionOK() *SecurityJitPrivilegeModifyCollectionOK {
	return &SecurityJitPrivilegeModifyCollectionOK{}
}

/*
SecurityJitPrivilegeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityJitPrivilegeModifyCollectionOK struct {
	Payload *models.SecurityJitPrivilege
}

// IsSuccess returns true when this security jit privilege modify collection o k response has a 2xx status code
func (o *SecurityJitPrivilegeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security jit privilege modify collection o k response has a 3xx status code
func (o *SecurityJitPrivilegeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security jit privilege modify collection o k response has a 4xx status code
func (o *SecurityJitPrivilegeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security jit privilege modify collection o k response has a 5xx status code
func (o *SecurityJitPrivilegeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security jit privilege modify collection o k response a status code equal to that given
func (o *SecurityJitPrivilegeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security jit privilege modify collection o k response
func (o *SecurityJitPrivilegeModifyCollectionOK) Code() int {
	return 200
}

func (o *SecurityJitPrivilegeModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/jit-privileges][%d] securityJitPrivilegeModifyCollectionOK %s", 200, payload)
}

func (o *SecurityJitPrivilegeModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/jit-privileges][%d] securityJitPrivilegeModifyCollectionOK %s", 200, payload)
}

func (o *SecurityJitPrivilegeModifyCollectionOK) GetPayload() *models.SecurityJitPrivilege {
	return o.Payload
}

func (o *SecurityJitPrivilegeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityJitPrivilege)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityJitPrivilegeModifyCollectionDefault creates a SecurityJitPrivilegeModifyCollectionDefault with default headers values
func NewSecurityJitPrivilegeModifyCollectionDefault(code int) *SecurityJitPrivilegeModifyCollectionDefault {
	return &SecurityJitPrivilegeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
SecurityJitPrivilegeModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityJitPrivilegeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security jit privilege modify collection default response has a 2xx status code
func (o *SecurityJitPrivilegeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security jit privilege modify collection default response has a 3xx status code
func (o *SecurityJitPrivilegeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security jit privilege modify collection default response has a 4xx status code
func (o *SecurityJitPrivilegeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security jit privilege modify collection default response has a 5xx status code
func (o *SecurityJitPrivilegeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security jit privilege modify collection default response a status code equal to that given
func (o *SecurityJitPrivilegeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security jit privilege modify collection default response
func (o *SecurityJitPrivilegeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityJitPrivilegeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/jit-privileges][%d] security_jit_privilege_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityJitPrivilegeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/jit-privileges][%d] security_jit_privilege_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityJitPrivilegeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityJitPrivilegeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityJitPrivilegeModifyCollectionBody security jit privilege modify collection body
swagger:model SecurityJitPrivilegeModifyCollectionBody
*/
type SecurityJitPrivilegeModifyCollectionBody struct {

	// links
	Links *models.SecurityJitPrivilegeInlineLinks `json:"_links,omitempty"`

	// The name of the application.
	//
	// Enum: ["ssh"]
	Application *string `json:"application,omitempty"`

	// The default session validity period on this SVM.
	//
	// Example: PT1H
	DefaultSessionValidityPeriod *string `json:"default_session_validity_period,omitempty"`

	// The maximum JIT validity period allowed on this SVM.
	//
	// Example: P90D
	MaxJitValidityPeriod *string `json:"max_jit_validity_period,omitempty"`

	// owner
	Owner *models.SecurityJitPrivilegeInlineOwner `json:"owner,omitempty"`

	// security jit privilege response inline records
	SecurityJitPrivilegeResponseInlineRecords []*models.SecurityJitPrivilege `json:"records,omitempty"`
}

// Validate validates this security jit privilege modify collection body
func (o *SecurityJitPrivilegeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityJitPrivilegeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var securityJitPrivilegeModifyCollectionBodyTypeApplicationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ssh"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityJitPrivilegeModifyCollectionBodyTypeApplicationPropEnum = append(securityJitPrivilegeModifyCollectionBodyTypeApplicationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityJitPrivilegeModifyCollectionBody
	// SecurityJitPrivilegeModifyCollectionBody
	// application
	// Application
	// ssh
	// END DEBUGGING
	// SecurityJitPrivilegeModifyCollectionBodyApplicationSSH captures enum value "ssh"
	SecurityJitPrivilegeModifyCollectionBodyApplicationSSH string = "ssh"
)

// prop value enum
func (o *SecurityJitPrivilegeModifyCollectionBody) validateApplicationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityJitPrivilegeModifyCollectionBodyTypeApplicationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Application) { // not required
		return nil
	}

	// value enum
	if err := o.validateApplicationEnum("info"+"."+"application", "body", *o.Application); err != nil {
		return err
	}

	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) validateSecurityJitPrivilegeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityJitPrivilegeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityJitPrivilegeResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityJitPrivilegeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityJitPrivilegeResponseInlineRecords[i] != nil {
			if err := o.SecurityJitPrivilegeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security jit privilege modify collection body based on the context it is used
func (o *SecurityJitPrivilegeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityJitPrivilegeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityJitPrivilegeModifyCollectionBody) contextValidateSecurityJitPrivilegeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityJitPrivilegeResponseInlineRecords); i++ {

		if o.SecurityJitPrivilegeResponseInlineRecords[i] != nil {
			if err := o.SecurityJitPrivilegeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityJitPrivilegeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityJitPrivilegeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityJitPrivilegeInlineLinks security jit privilege inline links
swagger:model security_jit_privilege_inline__links
*/
type SecurityJitPrivilegeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security jit privilege inline links
func (o *SecurityJitPrivilegeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege inline links based on the context it is used
func (o *SecurityJitPrivilegeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityJitPrivilegeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityJitPrivilegeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityJitPrivilegeInlineOwner Owner name and UUID that uniquely identifies the JIT privilege global settings.
swagger:model security_jit_privilege_inline_owner
*/
type SecurityJitPrivilegeInlineOwner struct {

	// links
	Links *models.SecurityJitPrivilegeInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security jit privilege inline owner
func (o *SecurityJitPrivilegeInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege inline owner based on the context it is used
func (o *SecurityJitPrivilegeInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityJitPrivilegeInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityJitPrivilegeInlineOwner) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityJitPrivilegeInlineOwnerInlineLinks security jit privilege inline owner inline links
swagger:model security_jit_privilege_inline_owner_inline__links
*/
type SecurityJitPrivilegeInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security jit privilege inline owner inline links
func (o *SecurityJitPrivilegeInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security jit privilege inline owner inline links based on the context it is used
func (o *SecurityJitPrivilegeInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityJitPrivilegeInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityJitPrivilegeInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
