// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityJitPrivilegeUserCollectionGetParams creates a new SecurityJitPrivilegeUserCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityJitPrivilegeUserCollectionGetParams() *SecurityJitPrivilegeUserCollectionGetParams {
	return &SecurityJitPrivilegeUserCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityJitPrivilegeUserCollectionGetParamsWithTimeout creates a new SecurityJitPrivilegeUserCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityJitPrivilegeUserCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityJitPrivilegeUserCollectionGetParams {
	return &SecurityJitPrivilegeUserCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityJitPrivilegeUserCollectionGetParamsWithContext creates a new SecurityJitPrivilegeUserCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityJitPrivilegeUserCollectionGetParamsWithContext(ctx context.Context) *SecurityJitPrivilegeUserCollectionGetParams {
	return &SecurityJitPrivilegeUserCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityJitPrivilegeUserCollectionGetParamsWithHTTPClient creates a new SecurityJitPrivilegeUserCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityJitPrivilegeUserCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityJitPrivilegeUserCollectionGetParams {
	return &SecurityJitPrivilegeUserCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityJitPrivilegeUserCollectionGetParams contains all the parameters to send to the API endpoint

	for the security jit privilege user collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityJitPrivilegeUserCollectionGetParams struct {

	/* AccountName.

	   Filter by account.name
	*/
	AccountName *string

	/* Application.

	   Filter by application
	*/
	Application *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* EndTime.

	   Filter by end_time
	*/
	EndTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* JitState.

	   Filter by jit_state
	*/
	JitState *string

	/* JitValidity.

	   Filter by jit_validity
	*/
	JitValidity *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* RoleName.

	   Filter by role.name
	*/
	RoleName *string

	/* SessionValidity.

	   Filter by session_validity
	*/
	SessionValidity *string

	/* StartTime.

	   Filter by start_time
	*/
	StartTime *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security jit privilege user collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithDefaults() *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security jit privilege user collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityJitPrivilegeUserCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithContext(ctx context.Context) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithAccountName(accountName *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetAccountName(accountName *string) {
	o.AccountName = accountName
}

// WithApplication adds the application to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithApplication(application *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetApplication(application *string) {
	o.Application = application
}

// WithComment adds the comment to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithComment(comment *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithEndTime adds the endTime to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithEndTime(endTime *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetEndTime(endTime)
	return o
}

// SetEndTime adds the endTime to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetEndTime(endTime *string) {
	o.EndTime = endTime
}

// WithFields adds the fields to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithFields(fields []string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithJitState adds the jitState to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithJitState(jitState *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetJitState(jitState)
	return o
}

// SetJitState adds the jitState to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetJitState(jitState *string) {
	o.JitState = jitState
}

// WithJitValidity adds the jitValidity to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithJitValidity(jitValidity *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetJitValidity(jitValidity)
	return o
}

// SetJitValidity adds the jitValidity to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetJitValidity(jitValidity *string) {
	o.JitValidity = jitValidity
}

// WithMaxRecords adds the maxRecords to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithOrderBy(orderBy []string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithOwnerName(ownerName *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithOwnerUUID(ownerUUID *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRoleName adds the roleName to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithRoleName(roleName *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetRoleName(roleName)
	return o
}

// SetRoleName adds the roleName to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetRoleName(roleName *string) {
	o.RoleName = roleName
}

// WithSessionValidity adds the sessionValidity to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithSessionValidity(sessionValidity *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetSessionValidity(sessionValidity)
	return o
}

// SetSessionValidity adds the sessionValidity to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetSessionValidity(sessionValidity *string) {
	o.SessionValidity = sessionValidity
}

// WithStartTime adds the startTime to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) WithStartTime(startTime *string) *SecurityJitPrivilegeUserCollectionGetParams {
	o.SetStartTime(startTime)
	return o
}

// SetStartTime adds the startTime to the security jit privilege user collection get params
func (o *SecurityJitPrivilegeUserCollectionGetParams) SetStartTime(startTime *string) {
	o.StartTime = startTime
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityJitPrivilegeUserCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountName != nil {

		// query param account.name
		var qrAccountName string

		if o.AccountName != nil {
			qrAccountName = *o.AccountName
		}
		qAccountName := qrAccountName
		if qAccountName != "" {

			if err := r.SetQueryParam("account.name", qAccountName); err != nil {
				return err
			}
		}
	}

	if o.Application != nil {

		// query param application
		var qrApplication string

		if o.Application != nil {
			qrApplication = *o.Application
		}
		qApplication := qrApplication
		if qApplication != "" {

			if err := r.SetQueryParam("application", qApplication); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.EndTime != nil {

		// query param end_time
		var qrEndTime string

		if o.EndTime != nil {
			qrEndTime = *o.EndTime
		}
		qEndTime := qrEndTime
		if qEndTime != "" {

			if err := r.SetQueryParam("end_time", qEndTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.JitState != nil {

		// query param jit_state
		var qrJitState string

		if o.JitState != nil {
			qrJitState = *o.JitState
		}
		qJitState := qrJitState
		if qJitState != "" {

			if err := r.SetQueryParam("jit_state", qJitState); err != nil {
				return err
			}
		}
	}

	if o.JitValidity != nil {

		// query param jit_validity
		var qrJitValidity string

		if o.JitValidity != nil {
			qrJitValidity = *o.JitValidity
		}
		qJitValidity := qrJitValidity
		if qJitValidity != "" {

			if err := r.SetQueryParam("jit_validity", qJitValidity); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.RoleName != nil {

		// query param role.name
		var qrRoleName string

		if o.RoleName != nil {
			qrRoleName = *o.RoleName
		}
		qRoleName := qrRoleName
		if qRoleName != "" {

			if err := r.SetQueryParam("role.name", qRoleName); err != nil {
				return err
			}
		}
	}

	if o.SessionValidity != nil {

		// query param session_validity
		var qrSessionValidity string

		if o.SessionValidity != nil {
			qrSessionValidity = *o.SessionValidity
		}
		qSessionValidity := qrSessionValidity
		if qSessionValidity != "" {

			if err := r.SetQueryParam("session_validity", qSessionValidity); err != nil {
				return err
			}
		}
	}

	if o.StartTime != nil {

		// query param start_time
		var qrStartTime string

		if o.StartTime != nil {
			qrStartTime = *o.StartTime
		}
		qStartTime := qrStartTime
		if qStartTime != "" {

			if err := r.SetQueryParam("start_time", qStartTime); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityJitPrivilegeUserCollectionGet binds the parameter fields
func (o *SecurityJitPrivilegeUserCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityJitPrivilegeUserCollectionGet binds the parameter order_by
func (o *SecurityJitPrivilegeUserCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
