// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityJitPrivilegeUserCreateParams creates a new SecurityJitPrivilegeUserCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityJitPrivilegeUserCreateParams() *SecurityJitPrivilegeUserCreateParams {
	return &SecurityJitPrivilegeUserCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityJitPrivilegeUserCreateParamsWithTimeout creates a new SecurityJitPrivilegeUserCreateParams object
// with the ability to set a timeout on a request.
func NewSecurityJitPrivilegeUserCreateParamsWithTimeout(timeout time.Duration) *SecurityJitPrivilegeUserCreateParams {
	return &SecurityJitPrivilegeUserCreateParams{
		timeout: timeout,
	}
}

// NewSecurityJitPrivilegeUserCreateParamsWithContext creates a new SecurityJitPrivilegeUserCreateParams object
// with the ability to set a context for a request.
func NewSecurityJitPrivilegeUserCreateParamsWithContext(ctx context.Context) *SecurityJitPrivilegeUserCreateParams {
	return &SecurityJitPrivilegeUserCreateParams{
		Context: ctx,
	}
}

// NewSecurityJitPrivilegeUserCreateParamsWithHTTPClient creates a new SecurityJitPrivilegeUserCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityJitPrivilegeUserCreateParamsWithHTTPClient(client *http.Client) *SecurityJitPrivilegeUserCreateParams {
	return &SecurityJitPrivilegeUserCreateParams{
		HTTPClient: client,
	}
}

/*
SecurityJitPrivilegeUserCreateParams contains all the parameters to send to the API endpoint

	for the security jit privilege user create operation.

	Typically these are written to a http.Request.
*/
type SecurityJitPrivilegeUserCreateParams struct {

	/* Info.

	   JIT privilege configurations of the user account.
	*/
	Info *models.SecurityJitPrivilegeUser

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security jit privilege user create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeUserCreateParams) WithDefaults() *SecurityJitPrivilegeUserCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security jit privilege user create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeUserCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SecurityJitPrivilegeUserCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) WithTimeout(timeout time.Duration) *SecurityJitPrivilegeUserCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) WithContext(ctx context.Context) *SecurityJitPrivilegeUserCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) WithHTTPClient(client *http.Client) *SecurityJitPrivilegeUserCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) WithInfo(info *models.SecurityJitPrivilegeUser) *SecurityJitPrivilegeUserCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) SetInfo(info *models.SecurityJitPrivilegeUser) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) WithReturnRecords(returnRecords *bool) *SecurityJitPrivilegeUserCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security jit privilege user create params
func (o *SecurityJitPrivilegeUserCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityJitPrivilegeUserCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
