// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityJitPrivilegeUserDeleteCollectionParams creates a new SecurityJitPrivilegeUserDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityJitPrivilegeUserDeleteCollectionParams() *SecurityJitPrivilegeUserDeleteCollectionParams {
	return &SecurityJitPrivilegeUserDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityJitPrivilegeUserDeleteCollectionParamsWithTimeout creates a new SecurityJitPrivilegeUserDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityJitPrivilegeUserDeleteCollectionParamsWithTimeout(timeout time.Duration) *SecurityJitPrivilegeUserDeleteCollectionParams {
	return &SecurityJitPrivilegeUserDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityJitPrivilegeUserDeleteCollectionParamsWithContext creates a new SecurityJitPrivilegeUserDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSecurityJitPrivilegeUserDeleteCollectionParamsWithContext(ctx context.Context) *SecurityJitPrivilegeUserDeleteCollectionParams {
	return &SecurityJitPrivilegeUserDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSecurityJitPrivilegeUserDeleteCollectionParamsWithHTTPClient creates a new SecurityJitPrivilegeUserDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityJitPrivilegeUserDeleteCollectionParamsWithHTTPClient(client *http.Client) *SecurityJitPrivilegeUserDeleteCollectionParams {
	return &SecurityJitPrivilegeUserDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityJitPrivilegeUserDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the security jit privilege user delete collection operation.

	Typically these are written to a http.Request.
*/
type SecurityJitPrivilegeUserDeleteCollectionParams struct {

	/* AccountName.

	   Filter by account.name
	*/
	AccountName *string

	/* Application.

	   Filter by application
	*/
	Application *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* EndTime.

	   Filter by end_time
	*/
	EndTime *string

	/* Info.

	   Info specification
	*/
	Info SecurityJitPrivilegeUserDeleteCollectionBody

	/* JitState.

	   Filter by jit_state
	*/
	JitState *string

	/* JitValidity.

	   Filter by jit_validity
	*/
	JitValidity *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* RoleName.

	   Filter by role.name
	*/
	RoleName *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SessionValidity.

	   Filter by session_validity
	*/
	SessionValidity *string

	/* StartTime.

	   Filter by start_time
	*/
	StartTime *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security jit privilege user delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithDefaults() *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security jit privilege user delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityJitPrivilegeUserDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithTimeout(timeout time.Duration) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithContext(ctx context.Context) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithHTTPClient(client *http.Client) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithAccountName(accountName *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetAccountName(accountName *string) {
	o.AccountName = accountName
}

// WithApplication adds the application to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithApplication(application *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetApplication(application *string) {
	o.Application = application
}

// WithComment adds the comment to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithComment(comment *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEndTime adds the endTime to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithEndTime(endTime *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetEndTime(endTime)
	return o
}

// SetEndTime adds the endTime to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetEndTime(endTime *string) {
	o.EndTime = endTime
}

// WithInfo adds the info to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithInfo(info SecurityJitPrivilegeUserDeleteCollectionBody) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetInfo(info SecurityJitPrivilegeUserDeleteCollectionBody) {
	o.Info = info
}

// WithJitState adds the jitState to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithJitState(jitState *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetJitState(jitState)
	return o
}

// SetJitState adds the jitState to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetJitState(jitState *string) {
	o.JitState = jitState
}

// WithJitValidity adds the jitValidity to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithJitValidity(jitValidity *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetJitValidity(jitValidity)
	return o
}

// SetJitValidity adds the jitValidity to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetJitValidity(jitValidity *string) {
	o.JitValidity = jitValidity
}

// WithOwnerName adds the ownerName to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithOwnerName(ownerName *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithOwnerUUID(ownerUUID *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRoleName adds the roleName to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithRoleName(roleName *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetRoleName(roleName)
	return o
}

// SetRoleName adds the roleName to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetRoleName(roleName *string) {
	o.RoleName = roleName
}

// WithSerialRecords adds the serialRecords to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSessionValidity adds the sessionValidity to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithSessionValidity(sessionValidity *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetSessionValidity(sessionValidity)
	return o
}

// SetSessionValidity adds the sessionValidity to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetSessionValidity(sessionValidity *string) {
	o.SessionValidity = sessionValidity
}

// WithStartTime adds the startTime to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WithStartTime(startTime *string) *SecurityJitPrivilegeUserDeleteCollectionParams {
	o.SetStartTime(startTime)
	return o
}

// SetStartTime adds the startTime to the security jit privilege user delete collection params
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) SetStartTime(startTime *string) {
	o.StartTime = startTime
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityJitPrivilegeUserDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountName != nil {

		// query param account.name
		var qrAccountName string

		if o.AccountName != nil {
			qrAccountName = *o.AccountName
		}
		qAccountName := qrAccountName
		if qAccountName != "" {

			if err := r.SetQueryParam("account.name", qAccountName); err != nil {
				return err
			}
		}
	}

	if o.Application != nil {

		// query param application
		var qrApplication string

		if o.Application != nil {
			qrApplication = *o.Application
		}
		qApplication := qrApplication
		if qApplication != "" {

			if err := r.SetQueryParam("application", qApplication); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.EndTime != nil {

		// query param end_time
		var qrEndTime string

		if o.EndTime != nil {
			qrEndTime = *o.EndTime
		}
		qEndTime := qrEndTime
		if qEndTime != "" {

			if err := r.SetQueryParam("end_time", qEndTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.JitState != nil {

		// query param jit_state
		var qrJitState string

		if o.JitState != nil {
			qrJitState = *o.JitState
		}
		qJitState := qrJitState
		if qJitState != "" {

			if err := r.SetQueryParam("jit_state", qJitState); err != nil {
				return err
			}
		}
	}

	if o.JitValidity != nil {

		// query param jit_validity
		var qrJitValidity string

		if o.JitValidity != nil {
			qrJitValidity = *o.JitValidity
		}
		qJitValidity := qrJitValidity
		if qJitValidity != "" {

			if err := r.SetQueryParam("jit_validity", qJitValidity); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.RoleName != nil {

		// query param role.name
		var qrRoleName string

		if o.RoleName != nil {
			qrRoleName = *o.RoleName
		}
		qRoleName := qrRoleName
		if qRoleName != "" {

			if err := r.SetQueryParam("role.name", qRoleName); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SessionValidity != nil {

		// query param session_validity
		var qrSessionValidity string

		if o.SessionValidity != nil {
			qrSessionValidity = *o.SessionValidity
		}
		qSessionValidity := qrSessionValidity
		if qSessionValidity != "" {

			if err := r.SetQueryParam("session_validity", qSessionValidity); err != nil {
				return err
			}
		}
	}

	if o.StartTime != nil {

		// query param start_time
		var qrStartTime string

		if o.StartTime != nil {
			qrStartTime = *o.StartTime
		}
		qStartTime := qrStartTime
		if qStartTime != "" {

			if err := r.SetQueryParam("start_time", qStartTime); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
