// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityJitPrivilegeUserDeleteCollectionReader is a Reader for the SecurityJitPrivilegeUserDeleteCollection structure.
type SecurityJitPrivilegeUserDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityJitPrivilegeUserDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityJitPrivilegeUserDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityJitPrivilegeUserDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityJitPrivilegeUserDeleteCollectionOK creates a SecurityJitPrivilegeUserDeleteCollectionOK with default headers values
func NewSecurityJitPrivilegeUserDeleteCollectionOK() *SecurityJitPrivilegeUserDeleteCollectionOK {
	return &SecurityJitPrivilegeUserDeleteCollectionOK{}
}

/*
SecurityJitPrivilegeUserDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityJitPrivilegeUserDeleteCollectionOK struct {
}

// IsSuccess returns true when this security jit privilege user delete collection o k response has a 2xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security jit privilege user delete collection o k response has a 3xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security jit privilege user delete collection o k response has a 4xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security jit privilege user delete collection o k response has a 5xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security jit privilege user delete collection o k response a status code equal to that given
func (o *SecurityJitPrivilegeUserDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security jit privilege user delete collection o k response
func (o *SecurityJitPrivilegeUserDeleteCollectionOK) Code() int {
	return 200
}

func (o *SecurityJitPrivilegeUserDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/jit-privilege-users][%d] securityJitPrivilegeUserDeleteCollectionOK", 200)
}

func (o *SecurityJitPrivilegeUserDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/jit-privilege-users][%d] securityJitPrivilegeUserDeleteCollectionOK", 200)
}

func (o *SecurityJitPrivilegeUserDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityJitPrivilegeUserDeleteCollectionDefault creates a SecurityJitPrivilegeUserDeleteCollectionDefault with default headers values
func NewSecurityJitPrivilegeUserDeleteCollectionDefault(code int) *SecurityJitPrivilegeUserDeleteCollectionDefault {
	return &SecurityJitPrivilegeUserDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
SecurityJitPrivilegeUserDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityJitPrivilegeUserDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security jit privilege user delete collection default response has a 2xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security jit privilege user delete collection default response has a 3xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security jit privilege user delete collection default response has a 4xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security jit privilege user delete collection default response has a 5xx status code
func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security jit privilege user delete collection default response a status code equal to that given
func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security jit privilege user delete collection default response
func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/jit-privilege-users][%d] security_jit_privilege_user_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/jit-privilege-users][%d] security_jit_privilege_user_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityJitPrivilegeUserDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityJitPrivilegeUserDeleteCollectionBody security jit privilege user delete collection body
swagger:model SecurityJitPrivilegeUserDeleteCollectionBody
*/
type SecurityJitPrivilegeUserDeleteCollectionBody struct {

	// security jit privilege user response inline records
	SecurityJitPrivilegeUserResponseInlineRecords []*models.SecurityJitPrivilegeUser `json:"records,omitempty"`
}

// Validate validates this security jit privilege user delete collection body
func (o *SecurityJitPrivilegeUserDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSecurityJitPrivilegeUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeUserDeleteCollectionBody) validateSecurityJitPrivilegeUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityJitPrivilegeUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityJitPrivilegeUserResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityJitPrivilegeUserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityJitPrivilegeUserResponseInlineRecords[i] != nil {
			if err := o.SecurityJitPrivilegeUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security jit privilege user delete collection body based on the context it is used
func (o *SecurityJitPrivilegeUserDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSecurityJitPrivilegeUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityJitPrivilegeUserDeleteCollectionBody) contextValidateSecurityJitPrivilegeUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityJitPrivilegeUserResponseInlineRecords); i++ {

		if o.SecurityJitPrivilegeUserResponseInlineRecords[i] != nil {
			if err := o.SecurityJitPrivilegeUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityJitPrivilegeUserDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityJitPrivilegeUserDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityJitPrivilegeUserDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
