// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityKeyManagerCreateParams creates a new SecurityKeyManagerCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityKeyManagerCreateParams() *SecurityKeyManagerCreateParams {
	return &SecurityKeyManagerCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityKeyManagerCreateParamsWithTimeout creates a new SecurityKeyManagerCreateParams object
// with the ability to set a timeout on a request.
func NewSecurityKeyManagerCreateParamsWithTimeout(timeout time.Duration) *SecurityKeyManagerCreateParams {
	return &SecurityKeyManagerCreateParams{
		timeout: timeout,
	}
}

// NewSecurityKeyManagerCreateParamsWithContext creates a new SecurityKeyManagerCreateParams object
// with the ability to set a context for a request.
func NewSecurityKeyManagerCreateParamsWithContext(ctx context.Context) *SecurityKeyManagerCreateParams {
	return &SecurityKeyManagerCreateParams{
		Context: ctx,
	}
}

// NewSecurityKeyManagerCreateParamsWithHTTPClient creates a new SecurityKeyManagerCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityKeyManagerCreateParamsWithHTTPClient(client *http.Client) *SecurityKeyManagerCreateParams {
	return &SecurityKeyManagerCreateParams{
		HTTPClient: client,
	}
}

/*
SecurityKeyManagerCreateParams contains all the parameters to send to the API endpoint

	for the security key manager create operation.

	Typically these are written to a http.Request.
*/
type SecurityKeyManagerCreateParams struct {

	/* CreateInactive.

	   Indicates whether to create an active or inactive configuration.
	*/
	CreateInactive *bool

	/* Info.

	   Info specification
	*/
	Info *models.SecurityKeyManager

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security key manager create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerCreateParams) WithDefaults() *SecurityKeyManagerCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security key manager create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := SecurityKeyManagerCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithTimeout(timeout time.Duration) *SecurityKeyManagerCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithContext(ctx context.Context) *SecurityKeyManagerCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithHTTPClient(client *http.Client) *SecurityKeyManagerCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateInactive adds the createInactive to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithCreateInactive(createInactive *bool) *SecurityKeyManagerCreateParams {
	o.SetCreateInactive(createInactive)
	return o
}

// SetCreateInactive adds the createInactive to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetCreateInactive(createInactive *bool) {
	o.CreateInactive = createInactive
}

// WithInfo adds the info to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithInfo(info *models.SecurityKeyManager) *SecurityKeyManagerCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetInfo(info *models.SecurityKeyManager) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithReturnRecords(returnRecords *bool) *SecurityKeyManagerCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security key manager create params
func (o *SecurityKeyManagerCreateParams) WithReturnTimeout(returnTimeout *int64) *SecurityKeyManagerCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security key manager create params
func (o *SecurityKeyManagerCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityKeyManagerCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateInactive != nil {

		// query param create_inactive
		var qrCreateInactive bool

		if o.CreateInactive != nil {
			qrCreateInactive = *o.CreateInactive
		}
		qCreateInactive := swag.FormatBool(qrCreateInactive)
		if qCreateInactive != "" {

			if err := r.SetQueryParam("create_inactive", qCreateInactive); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
