// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityKeyManagerDeleteCollectionParams creates a new SecurityKeyManagerDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityKeyManagerDeleteCollectionParams() *SecurityKeyManagerDeleteCollectionParams {
	return &SecurityKeyManagerDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityKeyManagerDeleteCollectionParamsWithTimeout creates a new SecurityKeyManagerDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityKeyManagerDeleteCollectionParamsWithTimeout(timeout time.Duration) *SecurityKeyManagerDeleteCollectionParams {
	return &SecurityKeyManagerDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityKeyManagerDeleteCollectionParamsWithContext creates a new SecurityKeyManagerDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSecurityKeyManagerDeleteCollectionParamsWithContext(ctx context.Context) *SecurityKeyManagerDeleteCollectionParams {
	return &SecurityKeyManagerDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSecurityKeyManagerDeleteCollectionParamsWithHTTPClient creates a new SecurityKeyManagerDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityKeyManagerDeleteCollectionParamsWithHTTPClient(client *http.Client) *SecurityKeyManagerDeleteCollectionParams {
	return &SecurityKeyManagerDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityKeyManagerDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the security key manager delete collection operation.

	Typically these are written to a http.Request.
*/
type SecurityKeyManagerDeleteCollectionParams struct {

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* ExternalClientCertificateName.

	   Filter by external.client_certificate.name
	*/
	ExternalClientCertificateName *string

	/* ExternalClientCertificateUUID.

	   Filter by external.client_certificate.uuid
	*/
	ExternalClientCertificateUUID *string

	/* ExternalServerCaCertificatesName.

	   Filter by external.server_ca_certificates.name
	*/
	ExternalServerCaCertificatesName *string

	/* ExternalServerCaCertificatesUUID.

	   Filter by external.server_ca_certificates.uuid
	*/
	ExternalServerCaCertificatesUUID *string

	/* ExternalServersConnectivityClusterAvailability.

	   Filter by external.servers.connectivity.cluster_availability
	*/
	ExternalServersConnectivityClusterAvailability *bool

	/* ExternalServersConnectivityNodeStatesNodeName.

	   Filter by external.servers.connectivity.node_states.node.name
	*/
	ExternalServersConnectivityNodeStatesNodeName *string

	/* ExternalServersConnectivityNodeStatesNodeUUID.

	   Filter by external.servers.connectivity.node_states.node.uuid
	*/
	ExternalServersConnectivityNodeStatesNodeUUID *string

	/* ExternalServersConnectivityNodeStatesState.

	   Filter by external.servers.connectivity.node_states.state
	*/
	ExternalServersConnectivityNodeStatesState *string

	/* ExternalServersSecondaryKeyServers.

	   Filter by external.servers.secondary_key_servers
	*/
	ExternalServersSecondaryKeyServers *string

	/* ExternalServersServer.

	   Filter by external.servers.server
	*/
	ExternalServersServer *string

	/* ExternalServersTimeout.

	   Filter by external.servers.timeout
	*/
	ExternalServersTimeout *int64

	/* ExternalServersUsername.

	   Filter by external.servers.username
	*/
	ExternalServersUsername *string

	/* Info.

	   Info specification
	*/
	Info SecurityKeyManagerDeleteCollectionBody

	/* IsDefaultDataAtRestEncryptionDisabled.

	   Filter by is_default_data_at_rest_encryption_disabled
	*/
	IsDefaultDataAtRestEncryptionDisabled *bool

	/* OnboardEnabled.

	   Filter by onboard.enabled
	*/
	OnboardEnabled *bool

	/* OnboardKeyBackup.

	   Filter by onboard.key_backup
	*/
	OnboardKeyBackup *string

	/* Policy.

	   Filter by policy
	*/
	Policy *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StatusCode.

	   Filter by status.code
	*/
	StatusCode *int64

	/* StatusMessage.

	   Filter by status.message
	*/
	StatusMessage *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VolumeEncryptionCode.

	   Filter by volume_encryption.code
	*/
	VolumeEncryptionCode *int64

	/* VolumeEncryptionMessage.

	   Filter by volume_encryption.message
	*/
	VolumeEncryptionMessage *string

	/* VolumeEncryptionSupported.

	   Filter by volume_encryption.supported
	*/
	VolumeEncryptionSupported *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security key manager delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerDeleteCollectionParams) WithDefaults() *SecurityKeyManagerDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security key manager delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityKeyManagerDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithTimeout(timeout time.Duration) *SecurityKeyManagerDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithContext(ctx context.Context) *SecurityKeyManagerDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithHTTPClient(client *http.Client) *SecurityKeyManagerDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConfigurationName adds the configurationName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithConfigurationName(configurationName *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithConfigurationUUID(configurationUUID *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithContinueOnFailure adds the continueOnFailure to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithEnabled(enabled *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithExternalClientCertificateName adds the externalClientCertificateName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalClientCertificateName(externalClientCertificateName *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalClientCertificateName(externalClientCertificateName)
	return o
}

// SetExternalClientCertificateName adds the externalClientCertificateName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalClientCertificateName(externalClientCertificateName *string) {
	o.ExternalClientCertificateName = externalClientCertificateName
}

// WithExternalClientCertificateUUID adds the externalClientCertificateUUID to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalClientCertificateUUID(externalClientCertificateUUID *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalClientCertificateUUID(externalClientCertificateUUID)
	return o
}

// SetExternalClientCertificateUUID adds the externalClientCertificateUuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalClientCertificateUUID(externalClientCertificateUUID *string) {
	o.ExternalClientCertificateUUID = externalClientCertificateUUID
}

// WithExternalServerCaCertificatesName adds the externalServerCaCertificatesName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServerCaCertificatesName(externalServerCaCertificatesName *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServerCaCertificatesName(externalServerCaCertificatesName)
	return o
}

// SetExternalServerCaCertificatesName adds the externalServerCaCertificatesName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServerCaCertificatesName(externalServerCaCertificatesName *string) {
	o.ExternalServerCaCertificatesName = externalServerCaCertificatesName
}

// WithExternalServerCaCertificatesUUID adds the externalServerCaCertificatesUUID to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServerCaCertificatesUUID(externalServerCaCertificatesUUID *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServerCaCertificatesUUID(externalServerCaCertificatesUUID)
	return o
}

// SetExternalServerCaCertificatesUUID adds the externalServerCaCertificatesUuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServerCaCertificatesUUID(externalServerCaCertificatesUUID *string) {
	o.ExternalServerCaCertificatesUUID = externalServerCaCertificatesUUID
}

// WithExternalServersConnectivityClusterAvailability adds the externalServersConnectivityClusterAvailability to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersConnectivityClusterAvailability(externalServersConnectivityClusterAvailability *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersConnectivityClusterAvailability(externalServersConnectivityClusterAvailability)
	return o
}

// SetExternalServersConnectivityClusterAvailability adds the externalServersConnectivityClusterAvailability to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersConnectivityClusterAvailability(externalServersConnectivityClusterAvailability *bool) {
	o.ExternalServersConnectivityClusterAvailability = externalServersConnectivityClusterAvailability
}

// WithExternalServersConnectivityNodeStatesNodeName adds the externalServersConnectivityNodeStatesNodeName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersConnectivityNodeStatesNodeName(externalServersConnectivityNodeStatesNodeName *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersConnectivityNodeStatesNodeName(externalServersConnectivityNodeStatesNodeName)
	return o
}

// SetExternalServersConnectivityNodeStatesNodeName adds the externalServersConnectivityNodeStatesNodeName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersConnectivityNodeStatesNodeName(externalServersConnectivityNodeStatesNodeName *string) {
	o.ExternalServersConnectivityNodeStatesNodeName = externalServersConnectivityNodeStatesNodeName
}

// WithExternalServersConnectivityNodeStatesNodeUUID adds the externalServersConnectivityNodeStatesNodeUUID to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersConnectivityNodeStatesNodeUUID(externalServersConnectivityNodeStatesNodeUUID *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersConnectivityNodeStatesNodeUUID(externalServersConnectivityNodeStatesNodeUUID)
	return o
}

// SetExternalServersConnectivityNodeStatesNodeUUID adds the externalServersConnectivityNodeStatesNodeUuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersConnectivityNodeStatesNodeUUID(externalServersConnectivityNodeStatesNodeUUID *string) {
	o.ExternalServersConnectivityNodeStatesNodeUUID = externalServersConnectivityNodeStatesNodeUUID
}

// WithExternalServersConnectivityNodeStatesState adds the externalServersConnectivityNodeStatesState to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersConnectivityNodeStatesState(externalServersConnectivityNodeStatesState *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersConnectivityNodeStatesState(externalServersConnectivityNodeStatesState)
	return o
}

// SetExternalServersConnectivityNodeStatesState adds the externalServersConnectivityNodeStatesState to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersConnectivityNodeStatesState(externalServersConnectivityNodeStatesState *string) {
	o.ExternalServersConnectivityNodeStatesState = externalServersConnectivityNodeStatesState
}

// WithExternalServersSecondaryKeyServers adds the externalServersSecondaryKeyServers to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersSecondaryKeyServers(externalServersSecondaryKeyServers *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersSecondaryKeyServers(externalServersSecondaryKeyServers)
	return o
}

// SetExternalServersSecondaryKeyServers adds the externalServersSecondaryKeyServers to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersSecondaryKeyServers(externalServersSecondaryKeyServers *string) {
	o.ExternalServersSecondaryKeyServers = externalServersSecondaryKeyServers
}

// WithExternalServersServer adds the externalServersServer to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersServer(externalServersServer *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersServer(externalServersServer)
	return o
}

// SetExternalServersServer adds the externalServersServer to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersServer(externalServersServer *string) {
	o.ExternalServersServer = externalServersServer
}

// WithExternalServersTimeout adds the externalServersTimeout to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersTimeout(externalServersTimeout *int64) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersTimeout(externalServersTimeout)
	return o
}

// SetExternalServersTimeout adds the externalServersTimeout to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersTimeout(externalServersTimeout *int64) {
	o.ExternalServersTimeout = externalServersTimeout
}

// WithExternalServersUsername adds the externalServersUsername to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithExternalServersUsername(externalServersUsername *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetExternalServersUsername(externalServersUsername)
	return o
}

// SetExternalServersUsername adds the externalServersUsername to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetExternalServersUsername(externalServersUsername *string) {
	o.ExternalServersUsername = externalServersUsername
}

// WithInfo adds the info to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithInfo(info SecurityKeyManagerDeleteCollectionBody) *SecurityKeyManagerDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetInfo(info SecurityKeyManagerDeleteCollectionBody) {
	o.Info = info
}

// WithIsDefaultDataAtRestEncryptionDisabled adds the isDefaultDataAtRestEncryptionDisabled to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithIsDefaultDataAtRestEncryptionDisabled(isDefaultDataAtRestEncryptionDisabled *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetIsDefaultDataAtRestEncryptionDisabled(isDefaultDataAtRestEncryptionDisabled)
	return o
}

// SetIsDefaultDataAtRestEncryptionDisabled adds the isDefaultDataAtRestEncryptionDisabled to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetIsDefaultDataAtRestEncryptionDisabled(isDefaultDataAtRestEncryptionDisabled *bool) {
	o.IsDefaultDataAtRestEncryptionDisabled = isDefaultDataAtRestEncryptionDisabled
}

// WithOnboardEnabled adds the onboardEnabled to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithOnboardEnabled(onboardEnabled *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetOnboardEnabled(onboardEnabled)
	return o
}

// SetOnboardEnabled adds the onboardEnabled to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetOnboardEnabled(onboardEnabled *bool) {
	o.OnboardEnabled = onboardEnabled
}

// WithOnboardKeyBackup adds the onboardKeyBackup to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithOnboardKeyBackup(onboardKeyBackup *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetOnboardKeyBackup(onboardKeyBackup)
	return o
}

// SetOnboardKeyBackup adds the onboardKeyBackup to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetOnboardKeyBackup(onboardKeyBackup *string) {
	o.OnboardKeyBackup = onboardKeyBackup
}

// WithPolicy adds the policy to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithPolicy(policy *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetPolicy(policy)
	return o
}

// SetPolicy adds the policy to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetPolicy(policy *string) {
	o.Policy = policy
}

// WithReturnRecords adds the returnRecords to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityKeyManagerDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithScope(scope *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStatusCode adds the statusCode to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithStatusCode(statusCode *int64) *SecurityKeyManagerDeleteCollectionParams {
	o.SetStatusCode(statusCode)
	return o
}

// SetStatusCode adds the statusCode to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetStatusCode(statusCode *int64) {
	o.StatusCode = statusCode
}

// WithStatusMessage adds the statusMessage to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithStatusMessage(statusMessage *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetStatusMessage(statusMessage)
	return o
}

// SetStatusMessage adds the statusMessage to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetStatusMessage(statusMessage *string) {
	o.StatusMessage = statusMessage
}

// WithSvmName adds the svmName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithSvmName(svmName *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithSvmUUID(svmUUID *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithUUID(uuid *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVolumeEncryptionCode adds the volumeEncryptionCode to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithVolumeEncryptionCode(volumeEncryptionCode *int64) *SecurityKeyManagerDeleteCollectionParams {
	o.SetVolumeEncryptionCode(volumeEncryptionCode)
	return o
}

// SetVolumeEncryptionCode adds the volumeEncryptionCode to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetVolumeEncryptionCode(volumeEncryptionCode *int64) {
	o.VolumeEncryptionCode = volumeEncryptionCode
}

// WithVolumeEncryptionMessage adds the volumeEncryptionMessage to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithVolumeEncryptionMessage(volumeEncryptionMessage *string) *SecurityKeyManagerDeleteCollectionParams {
	o.SetVolumeEncryptionMessage(volumeEncryptionMessage)
	return o
}

// SetVolumeEncryptionMessage adds the volumeEncryptionMessage to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetVolumeEncryptionMessage(volumeEncryptionMessage *string) {
	o.VolumeEncryptionMessage = volumeEncryptionMessage
}

// WithVolumeEncryptionSupported adds the volumeEncryptionSupported to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) WithVolumeEncryptionSupported(volumeEncryptionSupported *bool) *SecurityKeyManagerDeleteCollectionParams {
	o.SetVolumeEncryptionSupported(volumeEncryptionSupported)
	return o
}

// SetVolumeEncryptionSupported adds the volumeEncryptionSupported to the security key manager delete collection params
func (o *SecurityKeyManagerDeleteCollectionParams) SetVolumeEncryptionSupported(volumeEncryptionSupported *bool) {
	o.VolumeEncryptionSupported = volumeEncryptionSupported
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityKeyManagerDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExternalClientCertificateName != nil {

		// query param external.client_certificate.name
		var qrExternalClientCertificateName string

		if o.ExternalClientCertificateName != nil {
			qrExternalClientCertificateName = *o.ExternalClientCertificateName
		}
		qExternalClientCertificateName := qrExternalClientCertificateName
		if qExternalClientCertificateName != "" {

			if err := r.SetQueryParam("external.client_certificate.name", qExternalClientCertificateName); err != nil {
				return err
			}
		}
	}

	if o.ExternalClientCertificateUUID != nil {

		// query param external.client_certificate.uuid
		var qrExternalClientCertificateUUID string

		if o.ExternalClientCertificateUUID != nil {
			qrExternalClientCertificateUUID = *o.ExternalClientCertificateUUID
		}
		qExternalClientCertificateUUID := qrExternalClientCertificateUUID
		if qExternalClientCertificateUUID != "" {

			if err := r.SetQueryParam("external.client_certificate.uuid", qExternalClientCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.ExternalServerCaCertificatesName != nil {

		// query param external.server_ca_certificates.name
		var qrExternalServerCaCertificatesName string

		if o.ExternalServerCaCertificatesName != nil {
			qrExternalServerCaCertificatesName = *o.ExternalServerCaCertificatesName
		}
		qExternalServerCaCertificatesName := qrExternalServerCaCertificatesName
		if qExternalServerCaCertificatesName != "" {

			if err := r.SetQueryParam("external.server_ca_certificates.name", qExternalServerCaCertificatesName); err != nil {
				return err
			}
		}
	}

	if o.ExternalServerCaCertificatesUUID != nil {

		// query param external.server_ca_certificates.uuid
		var qrExternalServerCaCertificatesUUID string

		if o.ExternalServerCaCertificatesUUID != nil {
			qrExternalServerCaCertificatesUUID = *o.ExternalServerCaCertificatesUUID
		}
		qExternalServerCaCertificatesUUID := qrExternalServerCaCertificatesUUID
		if qExternalServerCaCertificatesUUID != "" {

			if err := r.SetQueryParam("external.server_ca_certificates.uuid", qExternalServerCaCertificatesUUID); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersConnectivityClusterAvailability != nil {

		// query param external.servers.connectivity.cluster_availability
		var qrExternalServersConnectivityClusterAvailability bool

		if o.ExternalServersConnectivityClusterAvailability != nil {
			qrExternalServersConnectivityClusterAvailability = *o.ExternalServersConnectivityClusterAvailability
		}
		qExternalServersConnectivityClusterAvailability := swag.FormatBool(qrExternalServersConnectivityClusterAvailability)
		if qExternalServersConnectivityClusterAvailability != "" {

			if err := r.SetQueryParam("external.servers.connectivity.cluster_availability", qExternalServersConnectivityClusterAvailability); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersConnectivityNodeStatesNodeName != nil {

		// query param external.servers.connectivity.node_states.node.name
		var qrExternalServersConnectivityNodeStatesNodeName string

		if o.ExternalServersConnectivityNodeStatesNodeName != nil {
			qrExternalServersConnectivityNodeStatesNodeName = *o.ExternalServersConnectivityNodeStatesNodeName
		}
		qExternalServersConnectivityNodeStatesNodeName := qrExternalServersConnectivityNodeStatesNodeName
		if qExternalServersConnectivityNodeStatesNodeName != "" {

			if err := r.SetQueryParam("external.servers.connectivity.node_states.node.name", qExternalServersConnectivityNodeStatesNodeName); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersConnectivityNodeStatesNodeUUID != nil {

		// query param external.servers.connectivity.node_states.node.uuid
		var qrExternalServersConnectivityNodeStatesNodeUUID string

		if o.ExternalServersConnectivityNodeStatesNodeUUID != nil {
			qrExternalServersConnectivityNodeStatesNodeUUID = *o.ExternalServersConnectivityNodeStatesNodeUUID
		}
		qExternalServersConnectivityNodeStatesNodeUUID := qrExternalServersConnectivityNodeStatesNodeUUID
		if qExternalServersConnectivityNodeStatesNodeUUID != "" {

			if err := r.SetQueryParam("external.servers.connectivity.node_states.node.uuid", qExternalServersConnectivityNodeStatesNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersConnectivityNodeStatesState != nil {

		// query param external.servers.connectivity.node_states.state
		var qrExternalServersConnectivityNodeStatesState string

		if o.ExternalServersConnectivityNodeStatesState != nil {
			qrExternalServersConnectivityNodeStatesState = *o.ExternalServersConnectivityNodeStatesState
		}
		qExternalServersConnectivityNodeStatesState := qrExternalServersConnectivityNodeStatesState
		if qExternalServersConnectivityNodeStatesState != "" {

			if err := r.SetQueryParam("external.servers.connectivity.node_states.state", qExternalServersConnectivityNodeStatesState); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersSecondaryKeyServers != nil {

		// query param external.servers.secondary_key_servers
		var qrExternalServersSecondaryKeyServers string

		if o.ExternalServersSecondaryKeyServers != nil {
			qrExternalServersSecondaryKeyServers = *o.ExternalServersSecondaryKeyServers
		}
		qExternalServersSecondaryKeyServers := qrExternalServersSecondaryKeyServers
		if qExternalServersSecondaryKeyServers != "" {

			if err := r.SetQueryParam("external.servers.secondary_key_servers", qExternalServersSecondaryKeyServers); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersServer != nil {

		// query param external.servers.server
		var qrExternalServersServer string

		if o.ExternalServersServer != nil {
			qrExternalServersServer = *o.ExternalServersServer
		}
		qExternalServersServer := qrExternalServersServer
		if qExternalServersServer != "" {

			if err := r.SetQueryParam("external.servers.server", qExternalServersServer); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersTimeout != nil {

		// query param external.servers.timeout
		var qrExternalServersTimeout int64

		if o.ExternalServersTimeout != nil {
			qrExternalServersTimeout = *o.ExternalServersTimeout
		}
		qExternalServersTimeout := swag.FormatInt64(qrExternalServersTimeout)
		if qExternalServersTimeout != "" {

			if err := r.SetQueryParam("external.servers.timeout", qExternalServersTimeout); err != nil {
				return err
			}
		}
	}

	if o.ExternalServersUsername != nil {

		// query param external.servers.username
		var qrExternalServersUsername string

		if o.ExternalServersUsername != nil {
			qrExternalServersUsername = *o.ExternalServersUsername
		}
		qExternalServersUsername := qrExternalServersUsername
		if qExternalServersUsername != "" {

			if err := r.SetQueryParam("external.servers.username", qExternalServersUsername); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsDefaultDataAtRestEncryptionDisabled != nil {

		// query param is_default_data_at_rest_encryption_disabled
		var qrIsDefaultDataAtRestEncryptionDisabled bool

		if o.IsDefaultDataAtRestEncryptionDisabled != nil {
			qrIsDefaultDataAtRestEncryptionDisabled = *o.IsDefaultDataAtRestEncryptionDisabled
		}
		qIsDefaultDataAtRestEncryptionDisabled := swag.FormatBool(qrIsDefaultDataAtRestEncryptionDisabled)
		if qIsDefaultDataAtRestEncryptionDisabled != "" {

			if err := r.SetQueryParam("is_default_data_at_rest_encryption_disabled", qIsDefaultDataAtRestEncryptionDisabled); err != nil {
				return err
			}
		}
	}

	if o.OnboardEnabled != nil {

		// query param onboard.enabled
		var qrOnboardEnabled bool

		if o.OnboardEnabled != nil {
			qrOnboardEnabled = *o.OnboardEnabled
		}
		qOnboardEnabled := swag.FormatBool(qrOnboardEnabled)
		if qOnboardEnabled != "" {

			if err := r.SetQueryParam("onboard.enabled", qOnboardEnabled); err != nil {
				return err
			}
		}
	}

	if o.OnboardKeyBackup != nil {

		// query param onboard.key_backup
		var qrOnboardKeyBackup string

		if o.OnboardKeyBackup != nil {
			qrOnboardKeyBackup = *o.OnboardKeyBackup
		}
		qOnboardKeyBackup := qrOnboardKeyBackup
		if qOnboardKeyBackup != "" {

			if err := r.SetQueryParam("onboard.key_backup", qOnboardKeyBackup); err != nil {
				return err
			}
		}
	}

	if o.Policy != nil {

		// query param policy
		var qrPolicy string

		if o.Policy != nil {
			qrPolicy = *o.Policy
		}
		qPolicy := qrPolicy
		if qPolicy != "" {

			if err := r.SetQueryParam("policy", qPolicy); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StatusCode != nil {

		// query param status.code
		var qrStatusCode int64

		if o.StatusCode != nil {
			qrStatusCode = *o.StatusCode
		}
		qStatusCode := swag.FormatInt64(qrStatusCode)
		if qStatusCode != "" {

			if err := r.SetQueryParam("status.code", qStatusCode); err != nil {
				return err
			}
		}
	}

	if o.StatusMessage != nil {

		// query param status.message
		var qrStatusMessage string

		if o.StatusMessage != nil {
			qrStatusMessage = *o.StatusMessage
		}
		qStatusMessage := qrStatusMessage
		if qStatusMessage != "" {

			if err := r.SetQueryParam("status.message", qStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VolumeEncryptionCode != nil {

		// query param volume_encryption.code
		var qrVolumeEncryptionCode int64

		if o.VolumeEncryptionCode != nil {
			qrVolumeEncryptionCode = *o.VolumeEncryptionCode
		}
		qVolumeEncryptionCode := swag.FormatInt64(qrVolumeEncryptionCode)
		if qVolumeEncryptionCode != "" {

			if err := r.SetQueryParam("volume_encryption.code", qVolumeEncryptionCode); err != nil {
				return err
			}
		}
	}

	if o.VolumeEncryptionMessage != nil {

		// query param volume_encryption.message
		var qrVolumeEncryptionMessage string

		if o.VolumeEncryptionMessage != nil {
			qrVolumeEncryptionMessage = *o.VolumeEncryptionMessage
		}
		qVolumeEncryptionMessage := qrVolumeEncryptionMessage
		if qVolumeEncryptionMessage != "" {

			if err := r.SetQueryParam("volume_encryption.message", qVolumeEncryptionMessage); err != nil {
				return err
			}
		}
	}

	if o.VolumeEncryptionSupported != nil {

		// query param volume_encryption.supported
		var qrVolumeEncryptionSupported bool

		if o.VolumeEncryptionSupported != nil {
			qrVolumeEncryptionSupported = *o.VolumeEncryptionSupported
		}
		qVolumeEncryptionSupported := swag.FormatBool(qrVolumeEncryptionSupported)
		if qVolumeEncryptionSupported != "" {

			if err := r.SetQueryParam("volume_encryption.supported", qVolumeEncryptionSupported); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
