// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityKeyManagerGetReader is a Reader for the SecurityKeyManagerGet structure.
type SecurityKeyManagerGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityKeyManagerGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityKeyManagerGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityKeyManagerGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityKeyManagerGetOK creates a SecurityKeyManagerGetOK with default headers values
func NewSecurityKeyManagerGetOK() *SecurityKeyManagerGetOK {
	return &SecurityKeyManagerGetOK{}
}

/*
SecurityKeyManagerGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityKeyManagerGetOK struct {
	Payload *models.SecurityKeyManager
}

// IsSuccess returns true when this security key manager get o k response has a 2xx status code
func (o *SecurityKeyManagerGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security key manager get o k response has a 3xx status code
func (o *SecurityKeyManagerGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security key manager get o k response has a 4xx status code
func (o *SecurityKeyManagerGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security key manager get o k response has a 5xx status code
func (o *SecurityKeyManagerGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security key manager get o k response a status code equal to that given
func (o *SecurityKeyManagerGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security key manager get o k response
func (o *SecurityKeyManagerGetOK) Code() int {
	return 200
}

func (o *SecurityKeyManagerGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/key-managers/{uuid}][%d] securityKeyManagerGetOK %s", 200, payload)
}

func (o *SecurityKeyManagerGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/key-managers/{uuid}][%d] securityKeyManagerGetOK %s", 200, payload)
}

func (o *SecurityKeyManagerGetOK) GetPayload() *models.SecurityKeyManager {
	return o.Payload
}

func (o *SecurityKeyManagerGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityKeyManager)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityKeyManagerGetDefault creates a SecurityKeyManagerGetDefault with default headers values
func NewSecurityKeyManagerGetDefault(code int) *SecurityKeyManagerGetDefault {
	return &SecurityKeyManagerGetDefault{
		_statusCode: code,
	}
}

/*
	SecurityKeyManagerGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65536894 | This cluster is part of a MetroCluster configuration. Configure an external key manager on the partner cluster providing the same key servers before proceeding with any key manager operations. |
| 65537201 | There are no key servers configured for this SVM in the local cluster. |
| 65537202 | There are no key servers configured for this SVM in the remote cluster. |
| 65537203 | Internal error. Failed to check for key servers on partner cluster. |
| 65537204 | This cluster is part of a MetroCluster configuration. Configure an external key manager on the partner cluster providing the same key servers before proceeding with any key manager operations. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityKeyManagerGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security key manager get default response has a 2xx status code
func (o *SecurityKeyManagerGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security key manager get default response has a 3xx status code
func (o *SecurityKeyManagerGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security key manager get default response has a 4xx status code
func (o *SecurityKeyManagerGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security key manager get default response has a 5xx status code
func (o *SecurityKeyManagerGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security key manager get default response a status code equal to that given
func (o *SecurityKeyManagerGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security key manager get default response
func (o *SecurityKeyManagerGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityKeyManagerGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/key-managers/{uuid}][%d] security_key_manager_get default %s", o._statusCode, payload)
}

func (o *SecurityKeyManagerGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/key-managers/{uuid}][%d] security_key_manager_get default %s", o._statusCode, payload)
}

func (o *SecurityKeyManagerGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityKeyManagerGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
