// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityKeyManagerKeyServersCollectionGetParams creates a new SecurityKeyManagerKeyServersCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityKeyManagerKeyServersCollectionGetParams() *SecurityKeyManagerKeyServersCollectionGetParams {
	return &SecurityKeyManagerKeyServersCollectionGetParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewSecurityKeyManagerKeyServersCollectionGetParamsWithTimeout creates a new SecurityKeyManagerKeyServersCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityKeyManagerKeyServersCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityKeyManagerKeyServersCollectionGetParams {
	return &SecurityKeyManagerKeyServersCollectionGetParams{
		requestTimeout: timeout,
	}
}

// NewSecurityKeyManagerKeyServersCollectionGetParamsWithContext creates a new SecurityKeyManagerKeyServersCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityKeyManagerKeyServersCollectionGetParamsWithContext(ctx context.Context) *SecurityKeyManagerKeyServersCollectionGetParams {
	return &SecurityKeyManagerKeyServersCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityKeyManagerKeyServersCollectionGetParamsWithHTTPClient creates a new SecurityKeyManagerKeyServersCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityKeyManagerKeyServersCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityKeyManagerKeyServersCollectionGetParams {
	return &SecurityKeyManagerKeyServersCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityKeyManagerKeyServersCollectionGetParams contains all the parameters to send to the API endpoint

	for the security key manager key servers collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityKeyManagerKeyServersCollectionGetParams struct {

	/* ConnectivityClusterAvailability.

	   Filter by connectivity.cluster_availability
	*/
	ConnectivityClusterAvailability *bool

	/* ConnectivityNodeStatesNodeName.

	   Filter by connectivity.node_states.node.name
	*/
	ConnectivityNodeStatesNodeName *string

	/* ConnectivityNodeStatesNodeUUID.

	   Filter by connectivity.node_states.node.uuid
	*/
	ConnectivityNodeStatesNodeUUID *string

	/* ConnectivityNodeStatesState.

	   Filter by connectivity.node_states.state
	*/
	ConnectivityNodeStatesState *string

	/* CreateRemoveTimeout.

	   Filter by create_remove_timeout
	*/
	CreateRemoveTimeout *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecondaryKeyServers.

	   Filter by secondary_key_servers
	*/
	SecondaryKeyServers *string

	/* Server.

	   Filter by server
	*/
	Server *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* Username.

	   Filter by username
	*/
	Username *string

	/* UUID.

	   External key manager UUID
	*/
	UUID string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the security key manager key servers collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithDefaults() *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security key manager key servers collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityKeyManagerKeyServersCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithRequestTimeout(timeout time.Duration) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithContext(ctx context.Context) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConnectivityClusterAvailability adds the connectivityClusterAvailability to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithConnectivityClusterAvailability(connectivityClusterAvailability *bool) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetConnectivityClusterAvailability(connectivityClusterAvailability)
	return o
}

// SetConnectivityClusterAvailability adds the connectivityClusterAvailability to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetConnectivityClusterAvailability(connectivityClusterAvailability *bool) {
	o.ConnectivityClusterAvailability = connectivityClusterAvailability
}

// WithConnectivityNodeStatesNodeName adds the connectivityNodeStatesNodeName to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithConnectivityNodeStatesNodeName(connectivityNodeStatesNodeName *string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetConnectivityNodeStatesNodeName(connectivityNodeStatesNodeName)
	return o
}

// SetConnectivityNodeStatesNodeName adds the connectivityNodeStatesNodeName to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetConnectivityNodeStatesNodeName(connectivityNodeStatesNodeName *string) {
	o.ConnectivityNodeStatesNodeName = connectivityNodeStatesNodeName
}

// WithConnectivityNodeStatesNodeUUID adds the connectivityNodeStatesNodeUUID to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithConnectivityNodeStatesNodeUUID(connectivityNodeStatesNodeUUID *string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetConnectivityNodeStatesNodeUUID(connectivityNodeStatesNodeUUID)
	return o
}

// SetConnectivityNodeStatesNodeUUID adds the connectivityNodeStatesNodeUuid to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetConnectivityNodeStatesNodeUUID(connectivityNodeStatesNodeUUID *string) {
	o.ConnectivityNodeStatesNodeUUID = connectivityNodeStatesNodeUUID
}

// WithConnectivityNodeStatesState adds the connectivityNodeStatesState to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithConnectivityNodeStatesState(connectivityNodeStatesState *string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetConnectivityNodeStatesState(connectivityNodeStatesState)
	return o
}

// SetConnectivityNodeStatesState adds the connectivityNodeStatesState to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetConnectivityNodeStatesState(connectivityNodeStatesState *string) {
	o.ConnectivityNodeStatesState = connectivityNodeStatesState
}

// WithCreateRemoveTimeout adds the createRemoveTimeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithCreateRemoveTimeout(createRemoveTimeout *int64) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetCreateRemoveTimeout(createRemoveTimeout)
	return o
}

// SetCreateRemoveTimeout adds the createRemoveTimeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetCreateRemoveTimeout(createRemoveTimeout *int64) {
	o.CreateRemoveTimeout = createRemoveTimeout
}

// WithFields adds the fields to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithFields(fields []string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithOrderBy(orderBy []string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecondaryKeyServers adds the secondaryKeyServers to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithSecondaryKeyServers(secondaryKeyServers *string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetSecondaryKeyServers(secondaryKeyServers)
	return o
}

// SetSecondaryKeyServers adds the secondaryKeyServers to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetSecondaryKeyServers(secondaryKeyServers *string) {
	o.SecondaryKeyServers = secondaryKeyServers
}

// WithServer adds the server to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithServer(server *string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetServer(server *string) {
	o.Server = server
}

// WithTimeout adds the timeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithTimeout(timeout *int64) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithUsername adds the username to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithUsername(username *string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetUsername(username)
	return o
}

// SetUsername adds the username to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetUsername(username *string) {
	o.Username = username
}

// WithUUID adds the uuid to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WithUUID(uuid string) *SecurityKeyManagerKeyServersCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security key manager key servers collection get params
func (o *SecurityKeyManagerKeyServersCollectionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityKeyManagerKeyServersCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.ConnectivityClusterAvailability != nil {

		// query param connectivity.cluster_availability
		var qrConnectivityClusterAvailability bool

		if o.ConnectivityClusterAvailability != nil {
			qrConnectivityClusterAvailability = *o.ConnectivityClusterAvailability
		}
		qConnectivityClusterAvailability := swag.FormatBool(qrConnectivityClusterAvailability)
		if qConnectivityClusterAvailability != "" {

			if err := r.SetQueryParam("connectivity.cluster_availability", qConnectivityClusterAvailability); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityNodeStatesNodeName != nil {

		// query param connectivity.node_states.node.name
		var qrConnectivityNodeStatesNodeName string

		if o.ConnectivityNodeStatesNodeName != nil {
			qrConnectivityNodeStatesNodeName = *o.ConnectivityNodeStatesNodeName
		}
		qConnectivityNodeStatesNodeName := qrConnectivityNodeStatesNodeName
		if qConnectivityNodeStatesNodeName != "" {

			if err := r.SetQueryParam("connectivity.node_states.node.name", qConnectivityNodeStatesNodeName); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityNodeStatesNodeUUID != nil {

		// query param connectivity.node_states.node.uuid
		var qrConnectivityNodeStatesNodeUUID string

		if o.ConnectivityNodeStatesNodeUUID != nil {
			qrConnectivityNodeStatesNodeUUID = *o.ConnectivityNodeStatesNodeUUID
		}
		qConnectivityNodeStatesNodeUUID := qrConnectivityNodeStatesNodeUUID
		if qConnectivityNodeStatesNodeUUID != "" {

			if err := r.SetQueryParam("connectivity.node_states.node.uuid", qConnectivityNodeStatesNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityNodeStatesState != nil {

		// query param connectivity.node_states.state
		var qrConnectivityNodeStatesState string

		if o.ConnectivityNodeStatesState != nil {
			qrConnectivityNodeStatesState = *o.ConnectivityNodeStatesState
		}
		qConnectivityNodeStatesState := qrConnectivityNodeStatesState
		if qConnectivityNodeStatesState != "" {

			if err := r.SetQueryParam("connectivity.node_states.state", qConnectivityNodeStatesState); err != nil {
				return err
			}
		}
	}

	if o.CreateRemoveTimeout != nil {

		// query param create_remove_timeout
		var qrCreateRemoveTimeout int64

		if o.CreateRemoveTimeout != nil {
			qrCreateRemoveTimeout = *o.CreateRemoveTimeout
		}
		qCreateRemoveTimeout := swag.FormatInt64(qrCreateRemoveTimeout)
		if qCreateRemoveTimeout != "" {

			if err := r.SetQueryParam("create_remove_timeout", qCreateRemoveTimeout); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecondaryKeyServers != nil {

		// query param secondary_key_servers
		var qrSecondaryKeyServers string

		if o.SecondaryKeyServers != nil {
			qrSecondaryKeyServers = *o.SecondaryKeyServers
		}
		qSecondaryKeyServers := qrSecondaryKeyServers
		if qSecondaryKeyServers != "" {

			if err := r.SetQueryParam("secondary_key_servers", qSecondaryKeyServers); err != nil {
				return err
			}
		}
	}

	if o.Server != nil {

		// query param server
		var qrServer string

		if o.Server != nil {
			qrServer = *o.Server
		}
		qServer := qrServer
		if qServer != "" {

			if err := r.SetQueryParam("server", qServer); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.Username != nil {

		// query param username
		var qrUsername string

		if o.Username != nil {
			qrUsername = *o.Username
		}
		qUsername := qrUsername
		if qUsername != "" {

			if err := r.SetQueryParam("username", qUsername); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityKeyManagerKeyServersCollectionGet binds the parameter fields
func (o *SecurityKeyManagerKeyServersCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityKeyManagerKeyServersCollectionGet binds the parameter order_by
func (o *SecurityKeyManagerKeyServersCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
