// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityKeyManagerKeyServersDeleteCollectionReader is a Reader for the SecurityKeyManagerKeyServersDeleteCollection structure.
type SecurityKeyManagerKeyServersDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityKeyManagerKeyServersDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityKeyManagerKeyServersDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityKeyManagerKeyServersDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityKeyManagerKeyServersDeleteCollectionOK creates a SecurityKeyManagerKeyServersDeleteCollectionOK with default headers values
func NewSecurityKeyManagerKeyServersDeleteCollectionOK() *SecurityKeyManagerKeyServersDeleteCollectionOK {
	return &SecurityKeyManagerKeyServersDeleteCollectionOK{}
}

/*
SecurityKeyManagerKeyServersDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityKeyManagerKeyServersDeleteCollectionOK struct {
}

// IsSuccess returns true when this security key manager key servers delete collection o k response has a 2xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security key manager key servers delete collection o k response has a 3xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security key manager key servers delete collection o k response has a 4xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security key manager key servers delete collection o k response has a 5xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security key manager key servers delete collection o k response a status code equal to that given
func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security key manager key servers delete collection o k response
func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) Code() int {
	return 200
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/key-managers/{uuid}/key-servers][%d] securityKeyManagerKeyServersDeleteCollectionOK", 200)
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/key-managers/{uuid}/key-servers][%d] securityKeyManagerKeyServersDeleteCollectionOK", 200)
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityKeyManagerKeyServersDeleteCollectionDefault creates a SecurityKeyManagerKeyServersDeleteCollectionDefault with default headers values
func NewSecurityKeyManagerKeyServersDeleteCollectionDefault(code int) *SecurityKeyManagerKeyServersDeleteCollectionDefault {
	return &SecurityKeyManagerKeyServersDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityKeyManagerKeyServersDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65536600 | Cannot remove a key server while a node is out of quorum. |
| 65536700 | The key server contains keys that are currently in use and not available from any other configured key server in the SVM. |
| 65536843 | The key management server is not configured for the SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityKeyManagerKeyServersDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security key manager key servers delete collection default response has a 2xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security key manager key servers delete collection default response has a 3xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security key manager key servers delete collection default response has a 4xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security key manager key servers delete collection default response has a 5xx status code
func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security key manager key servers delete collection default response a status code equal to that given
func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security key manager key servers delete collection default response
func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/key-managers/{uuid}/key-servers][%d] security_key_manager_key_servers_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/key-managers/{uuid}/key-servers][%d] security_key_manager_key_servers_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityKeyManagerKeyServersDeleteCollectionBody security key manager key servers delete collection body
swagger:model SecurityKeyManagerKeyServersDeleteCollectionBody
*/
type SecurityKeyManagerKeyServersDeleteCollectionBody struct {

	// key server response inline records
	KeyServerResponseInlineRecords []*models.KeyServer `json:"records,omitempty"`
}

// Validate validates this security key manager key servers delete collection body
func (o *SecurityKeyManagerKeyServersDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKeyServerResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionBody) validateKeyServerResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyServerResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.KeyServerResponseInlineRecords); i++ {
		if swag.IsZero(o.KeyServerResponseInlineRecords[i]) { // not required
			continue
		}

		if o.KeyServerResponseInlineRecords[i] != nil {
			if err := o.KeyServerResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security key manager key servers delete collection body based on the context it is used
func (o *SecurityKeyManagerKeyServersDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateKeyServerResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerKeyServersDeleteCollectionBody) contextValidateKeyServerResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.KeyServerResponseInlineRecords); i++ {

		if o.KeyServerResponseInlineRecords[i] != nil {
			if err := o.KeyServerResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerKeyServersDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerKeyServersDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerKeyServersDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
