// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityKeyManagerKeyServersModifyParams creates a new SecurityKeyManagerKeyServersModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityKeyManagerKeyServersModifyParams() *SecurityKeyManagerKeyServersModifyParams {
	return &SecurityKeyManagerKeyServersModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityKeyManagerKeyServersModifyParamsWithTimeout creates a new SecurityKeyManagerKeyServersModifyParams object
// with the ability to set a timeout on a request.
func NewSecurityKeyManagerKeyServersModifyParamsWithTimeout(timeout time.Duration) *SecurityKeyManagerKeyServersModifyParams {
	return &SecurityKeyManagerKeyServersModifyParams{
		timeout: timeout,
	}
}

// NewSecurityKeyManagerKeyServersModifyParamsWithContext creates a new SecurityKeyManagerKeyServersModifyParams object
// with the ability to set a context for a request.
func NewSecurityKeyManagerKeyServersModifyParamsWithContext(ctx context.Context) *SecurityKeyManagerKeyServersModifyParams {
	return &SecurityKeyManagerKeyServersModifyParams{
		Context: ctx,
	}
}

// NewSecurityKeyManagerKeyServersModifyParamsWithHTTPClient creates a new SecurityKeyManagerKeyServersModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityKeyManagerKeyServersModifyParamsWithHTTPClient(client *http.Client) *SecurityKeyManagerKeyServersModifyParams {
	return &SecurityKeyManagerKeyServersModifyParams{
		HTTPClient: client,
	}
}

/*
SecurityKeyManagerKeyServersModifyParams contains all the parameters to send to the API endpoint

	for the security key manager key servers modify operation.

	Typically these are written to a http.Request.
*/
type SecurityKeyManagerKeyServersModifyParams struct {

	/* Info.

	   Key server information
	*/
	Info *models.KeyServer

	/* Server.

	   Primary key server configured in the external key manager.
	*/
	Server string

	/* UUID.

	   External key manager UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security key manager key servers modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerKeyServersModifyParams) WithDefaults() *SecurityKeyManagerKeyServersModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security key manager key servers modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeyManagerKeyServersModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) WithTimeout(timeout time.Duration) *SecurityKeyManagerKeyServersModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) WithContext(ctx context.Context) *SecurityKeyManagerKeyServersModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) WithHTTPClient(client *http.Client) *SecurityKeyManagerKeyServersModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) WithInfo(info *models.KeyServer) *SecurityKeyManagerKeyServersModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) SetInfo(info *models.KeyServer) {
	o.Info = info
}

// WithServer adds the server to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) WithServer(server string) *SecurityKeyManagerKeyServersModifyParams {
	o.SetServer(server)
	return o
}

// SetServer adds the server to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) SetServer(server string) {
	o.Server = server
}

// WithUUID adds the uuid to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) WithUUID(uuid string) *SecurityKeyManagerKeyServersModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security key manager key servers modify params
func (o *SecurityKeyManagerKeyServersModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityKeyManagerKeyServersModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param server
	if err := r.SetPathParam("server", o.Server); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
