// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityKeyManagerModifyCollectionReader is a Reader for the SecurityKeyManagerModifyCollection structure.
type SecurityKeyManagerModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityKeyManagerModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityKeyManagerModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSecurityKeyManagerModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityKeyManagerModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityKeyManagerModifyCollectionOK creates a SecurityKeyManagerModifyCollectionOK with default headers values
func NewSecurityKeyManagerModifyCollectionOK() *SecurityKeyManagerModifyCollectionOK {
	return &SecurityKeyManagerModifyCollectionOK{}
}

/*
SecurityKeyManagerModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityKeyManagerModifyCollectionOK struct {
}

// IsSuccess returns true when this security key manager modify collection o k response has a 2xx status code
func (o *SecurityKeyManagerModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security key manager modify collection o k response has a 3xx status code
func (o *SecurityKeyManagerModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security key manager modify collection o k response has a 4xx status code
func (o *SecurityKeyManagerModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security key manager modify collection o k response has a 5xx status code
func (o *SecurityKeyManagerModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security key manager modify collection o k response a status code equal to that given
func (o *SecurityKeyManagerModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security key manager modify collection o k response
func (o *SecurityKeyManagerModifyCollectionOK) Code() int {
	return 200
}

func (o *SecurityKeyManagerModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/key-managers][%d] securityKeyManagerModifyCollectionOK", 200)
}

func (o *SecurityKeyManagerModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/key-managers][%d] securityKeyManagerModifyCollectionOK", 200)
}

func (o *SecurityKeyManagerModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityKeyManagerModifyCollectionAccepted creates a SecurityKeyManagerModifyCollectionAccepted with default headers values
func NewSecurityKeyManagerModifyCollectionAccepted() *SecurityKeyManagerModifyCollectionAccepted {
	return &SecurityKeyManagerModifyCollectionAccepted{}
}

/*
SecurityKeyManagerModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SecurityKeyManagerModifyCollectionAccepted struct {
	Payload *models.SecurityKeyManagerJobLinkResponse
}

// IsSuccess returns true when this security key manager modify collection accepted response has a 2xx status code
func (o *SecurityKeyManagerModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security key manager modify collection accepted response has a 3xx status code
func (o *SecurityKeyManagerModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security key manager modify collection accepted response has a 4xx status code
func (o *SecurityKeyManagerModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this security key manager modify collection accepted response has a 5xx status code
func (o *SecurityKeyManagerModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this security key manager modify collection accepted response a status code equal to that given
func (o *SecurityKeyManagerModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the security key manager modify collection accepted response
func (o *SecurityKeyManagerModifyCollectionAccepted) Code() int {
	return 202
}

func (o *SecurityKeyManagerModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/key-managers][%d] securityKeyManagerModifyCollectionAccepted %s", 202, payload)
}

func (o *SecurityKeyManagerModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/key-managers][%d] securityKeyManagerModifyCollectionAccepted %s", 202, payload)
}

func (o *SecurityKeyManagerModifyCollectionAccepted) GetPayload() *models.SecurityKeyManagerJobLinkResponse {
	return o.Payload
}

func (o *SecurityKeyManagerModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityKeyManagerJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityKeyManagerModifyCollectionDefault creates a SecurityKeyManagerModifyCollectionDefault with default headers values
func NewSecurityKeyManagerModifyCollectionDefault(code int) *SecurityKeyManagerModifyCollectionDefault {
	return &SecurityKeyManagerModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityKeyManagerModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65536139 | The existing passphrase value provided does not match the configured passphrase. |
| 65536150 | The new passphrase is same as old passphrase. |
| 65536404 | The passphrase does not match the accepted length. |
| 65536406 | The change of passphrase failed. |
| 65536407 | The passphrase update failed on some nodes. |
| 65536802 | The passphrase does not match the accepted length in common criteria mode. |
| 65536821 | The certificate is not installed. |
| 65536828 | External key management is not enabled for the SVM. |
| 65536850 | New client certificate public or private keys are different from the existing client certificate. |
| 65536852 | Failed to query supported KMIP protocol versions. |
| 65536917 | Updating an onboard passphrase requires both new and existing cluster passphrase. |
| 65537242 | The Onboard Key Manager existing_passphrase must be provided when performing a PATCH/synchronize operation. |
| 65537243 | The Onboard Key Manager passphrase must not be provided when performing a PATCH/synchronize operation. |
| 65538120 | The key manager policy is not supported on the admin SVM. |
| 65539586 | Cannot modify an inactive key manager configuration. |
| 66060338 | Failed to establish secure connection for a key management server due to incorrect server_ca certificates. |
| 66060339 | Failed to establish secure connection for a key management server due to incorrect client certificates. |
| 66060340 | Failed to establish secure connection for a key management server due to Cryptsoft error. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityKeyManagerModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security key manager modify collection default response has a 2xx status code
func (o *SecurityKeyManagerModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security key manager modify collection default response has a 3xx status code
func (o *SecurityKeyManagerModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security key manager modify collection default response has a 4xx status code
func (o *SecurityKeyManagerModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security key manager modify collection default response has a 5xx status code
func (o *SecurityKeyManagerModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security key manager modify collection default response a status code equal to that given
func (o *SecurityKeyManagerModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security key manager modify collection default response
func (o *SecurityKeyManagerModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityKeyManagerModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/key-managers][%d] security_key_manager_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityKeyManagerModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/key-managers][%d] security_key_manager_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityKeyManagerModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityKeyManagerModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityKeyManagerModifyCollectionBody security key manager modify collection body
swagger:model SecurityKeyManagerModifyCollectionBody
*/
type SecurityKeyManagerModifyCollectionBody struct {

	// links
	Links *models.SecurityKeyManagerInlineLinks `json:"_links,omitempty"`

	// configuration
	Configuration *models.SecurityKeyManagerInlineConfiguration `json:"configuration,omitempty"`

	// Indicates whether the configuration is enabled.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// external
	External *models.SecurityKeyManagerInlineExternal `json:"external,omitempty"`

	// Indicates whether default data-at-rest encryption is disabled in the cluster. This field is deprecated in ONTAP 9.8 and later. Use the "software_data_encryption.disabled_by_default" of /api/security endpoint.
	IsDefaultDataAtRestEncryptionDisabled *bool `json:"is_default_data_at_rest_encryption_disabled,omitempty"`

	// onboard
	Onboard *models.SecurityKeyManagerInlineOnboard `json:"onboard,omitempty"`

	// Security policy associated with the key manager. This value is currently ignored if specified for the onboard key manager.
	Policy *string `json:"policy,omitempty"`

	// scope
	Scope *models.NetworkScopeReadonly `json:"scope,omitempty"`

	// security key manager response inline records
	SecurityKeyManagerResponseInlineRecords []*models.SecurityKeyManager `json:"records,omitempty"`

	// status
	Status *models.SecurityKeyManagerInlineStatus `json:"status,omitempty"`

	// svm
	Svm *models.SecurityKeyManagerInlineSvm `json:"svm,omitempty"`

	// uuid
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// volume encryption
	VolumeEncryption *models.SecurityKeyManagerInlineVolumeEncryption `json:"volume_encryption,omitempty"`
}

// Validate validates this security key manager modify collection body
func (o *SecurityKeyManagerModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExternal(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOnboard(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityKeyManagerResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeEncryption(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(o.Configuration) { // not required
		return nil
	}

	if o.Configuration != nil {
		if err := o.Configuration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateExternal(formats strfmt.Registry) error {
	if swag.IsZero(o.External) { // not required
		return nil
	}

	if o.External != nil {
		if err := o.External.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateOnboard(formats strfmt.Registry) error {
	if swag.IsZero(o.Onboard) { // not required
		return nil
	}

	if o.Onboard != nil {
		if err := o.Onboard.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "onboard")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	if o.Scope != nil {
		if err := o.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateSecurityKeyManagerResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityKeyManagerResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityKeyManagerResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityKeyManagerResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityKeyManagerResponseInlineRecords[i] != nil {
			if err := o.SecurityKeyManagerResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) validateVolumeEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeEncryption) { // not required
		return nil
	}

	if o.VolumeEncryption != nil {
		if err := o.VolumeEncryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume_encryption")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager modify collection body based on the context it is used
func (o *SecurityKeyManagerModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExternal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOnboard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityKeyManagerResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if o.Configuration != nil {
		if err := o.Configuration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateExternal(ctx context.Context, formats strfmt.Registry) error {

	if o.External != nil {
		if err := o.External.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateOnboard(ctx context.Context, formats strfmt.Registry) error {

	if o.Onboard != nil {
		if err := o.Onboard.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "onboard")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if o.Scope != nil {
		if err := o.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateSecurityKeyManagerResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityKeyManagerResponseInlineRecords); i++ {

		if o.SecurityKeyManagerResponseInlineRecords[i] != nil {
			if err := o.SecurityKeyManagerResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *SecurityKeyManagerModifyCollectionBody) contextValidateVolumeEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.VolumeEncryption != nil {
		if err := o.VolumeEncryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume_encryption")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0 Security certificate object reference
swagger:model SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0
*/
type SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0 struct {

	// links
	Links *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager modify collection params body external server ca certificates items0
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager modify collection params body external server ca certificates items0 based on the context it is used
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links security key manager modify collection params body external server ca certificates items0 links
swagger:model SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links
*/
type SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security key manager modify collection params body external server ca certificates items0 links
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager modify collection params body external server ca certificates items0 links based on the context it is used
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineLinks security key manager inline links
swagger:model security_key_manager_inline__links
*/
type SecurityKeyManagerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline links
func (o *SecurityKeyManagerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline links based on the context it is used
func (o *SecurityKeyManagerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineConfiguration Security keystore object reference.
swagger:model security_key_manager_inline_configuration
*/
type SecurityKeyManagerInlineConfiguration struct {

	// links
	Links *models.SecurityKeyManagerInlineConfigurationInlineLinks `json:"_links,omitempty"`

	// Name of the configuration.
	// Example: default
	Name *string `json:"name,omitempty"`

	// Keystore UUID.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager inline configuration
func (o *SecurityKeyManagerInlineConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineConfiguration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline configuration based on the context it is used
func (o *SecurityKeyManagerInlineConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineConfiguration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineConfiguration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineConfiguration) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineConfigurationInlineLinks security key manager inline configuration inline links
swagger:model security_key_manager_inline_configuration_inline__links
*/
type SecurityKeyManagerInlineConfigurationInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline configuration inline links
func (o *SecurityKeyManagerInlineConfigurationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineConfigurationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline configuration inline links based on the context it is used
func (o *SecurityKeyManagerInlineConfigurationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineConfigurationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineConfigurationInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineConfigurationInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineConfigurationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineExternal Configures external key management
swagger:model security_key_manager_inline_external
*/
type SecurityKeyManagerInlineExternal struct {

	// client certificate
	ClientCertificate *models.SecurityKeyManagerInlineExternalInlineClientCertificate `json:"client_certificate,omitempty"`

	// The array of certificates that are common for all the keyservers per SVM.
	ServerCaCertificates []*SecurityKeyManagerModifyCollectionParamsBodyExternalServerCaCertificatesItems0 `json:"server_ca_certificates,omitempty"`

	// The set of external key servers.
	// Max Items: 4
	Servers []*models.KeyServerReadcreate `json:"servers,omitempty"`
}

// Validate validates this security key manager inline external
func (o *SecurityKeyManagerInlineExternal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServerCaCertificates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineExternal) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.ClientCertificate) { // not required
		return nil
	}

	if o.ClientCertificate != nil {
		if err := o.ClientCertificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external" + "." + "client_certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerInlineExternal) validateServerCaCertificates(formats strfmt.Registry) error {
	if swag.IsZero(o.ServerCaCertificates) { // not required
		return nil
	}

	for i := 0; i < len(o.ServerCaCertificates); i++ {
		if swag.IsZero(o.ServerCaCertificates[i]) { // not required
			continue
		}

		if o.ServerCaCertificates[i] != nil {
			if err := o.ServerCaCertificates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "external" + "." + "server_ca_certificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SecurityKeyManagerInlineExternal) validateServers(formats strfmt.Registry) error {
	if swag.IsZero(o.Servers) { // not required
		return nil
	}

	iServersSize := int64(len(o.Servers))

	if err := validate.MaxItems("info"+"."+"external"+"."+"servers", "body", iServersSize, 4); err != nil {
		return err
	}

	for i := 0; i < len(o.Servers); i++ {
		if swag.IsZero(o.Servers[i]) { // not required
			continue
		}

		if o.Servers[i] != nil {
			if err := o.Servers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "external" + "." + "servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security key manager inline external based on the context it is used
func (o *SecurityKeyManagerInlineExternal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateClientCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServerCaCertificates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineExternal) contextValidateClientCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.ClientCertificate != nil {
		if err := o.ClientCertificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external" + "." + "client_certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityKeyManagerInlineExternal) contextValidateServerCaCertificates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ServerCaCertificates); i++ {

		if o.ServerCaCertificates[i] != nil {
			if err := o.ServerCaCertificates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "external" + "." + "server_ca_certificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SecurityKeyManagerInlineExternal) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Servers); i++ {

		if o.Servers[i] != nil {
			if err := o.Servers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "external" + "." + "servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineExternal) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineExternal) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineExternal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineExternalInlineClientCertificate Client certificate (name and UUID)
swagger:model security_key_manager_inline_external_inline_client_certificate
*/
type SecurityKeyManagerInlineExternalInlineClientCertificate struct {

	// links
	Links *models.SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager inline external inline client certificate
func (o *SecurityKeyManagerInlineExternalInlineClientCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineExternalInlineClientCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external" + "." + "client_certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline external inline client certificate based on the context it is used
func (o *SecurityKeyManagerInlineExternalInlineClientCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineExternalInlineClientCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external" + "." + "client_certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineExternalInlineClientCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineExternalInlineClientCertificate) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineExternalInlineClientCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks security key manager inline external inline client certificate inline links
swagger:model security_key_manager_inline_external_inline_client_certificate_inline__links
*/
type SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline external inline client certificate inline links
func (o *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external" + "." + "client_certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline external inline client certificate inline links based on the context it is used
func (o *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "external" + "." + "client_certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineExternalInlineClientCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineOnboard Configures onboard key management. After configuring onboard key management, save the encrypted configuration data in a safe location so that you can use it if you need to perform a manual recovery operation.
swagger:model security_key_manager_inline_onboard
*/
type SecurityKeyManagerInlineOnboard struct {

	// Is the onboard key manager enabled?
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The cluster-wide passphrase. This is not audited.
	// Example: The cluster password of length 32-256 ASCII characters.
	// Format: password
	ExistingPassphrase *strfmt.Password `json:"existing_passphrase,omitempty"`

	// Backup of the onboard key manager's key hierarchy. It is required to save this backup after configuring the onboard key manager to help in the recovery of the cluster in case of catastrophic failures.
	// Example: '--------------------------BEGIN BACKUP-------------------------- TmV0QXBwIEtleSBCbG9iAAEAAAAEAAAAcAEAAAAAAAAxBFWWAAAAACEAAAAAAAAA QAAAAAAAAABzDyyVAAAAALI5Jsjvy6gUxnT78KoDKXHYb6sSeraM00quOULY6BeV n6dMFxuErCD1lbERaOQZSuaYy1p8oQHtTEfGMLZM4TYiAAAAAAAAACgAAAAAAAAA 3WTh7gAAAAAAAAAAAAAAAAIAAAAAAAgAZJEIWvdeHr5RCAvHGclo+wAAAAAAAAAA IgAAAAAAAAAoAAAAAAAAAEOTcR0AAAAAAAAAAAAAAAACAAAAAAAJAGr3tJA/LRzU QRHwv+1aWvAAAAAAAAAAACQAAAAAAAAAgAAAAAAAAADV1Vd/AAAAAMFM9Q229Bhp mDaTSdqku5DCd8wG+fOZSr4bx4JT5WHvV/r5gJnXDQQAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABOZXRBcHAgS2V5IEJsb2IA AQAAAAMAAAAYAQAAAAAAALgePkcAAAAAIgAAAAAAAAAoAAAAAAAAAEOTcR0AAAAA AAAAAAAAAAACAAAAAAAJAGr3tJA/LRzUQRHwv+1aWvAAAAAAAAAAACIAAAAAAAAA KAAAAAAAAACIlCHZAAAAAAAAAAAAAAAAAgAAAAAAAQCafcabsxRXMM7gxhLRrzxh AAAAAAAAAAAkAAAAAAAAAIAAAAAAAAAA2JjQBQAAAACt4IqXcNpVggahl0axLsN4 yQjnNVKWY7mANB29O42hI7b70DTGCTaVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAE5ldEFwcCBLZXkgQmxvYgABAAAAAwAAABgBAAAAAAAA 7sbaoQAAAAAiAAAAAAAAACgAAAAAAAAAQ5NxHQAAAAAAAAAAAAAAAAIAAAAAAAkA ave0kD8tHNRBEfC/7Vpa8AAAAAAAAAAAIgAAAAAAAAAoAAAAAAAAALOHfWkAAAAA AAAAAAAAAAACAAAAAAABAMoI9UxrHOGthQm/CB+EHdAAAAAAAAAAACQAAAAAAAAA gAAAAAAAAACnMmUtAAAAAGVk8AtPzENFgsGdsFvnmucmYrlQCsFew0HDSFKaZqK6 W8IEVzBAhPoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA ---------------------------END BACKUP---------------------------'
	// Read Only: true
	KeyBackup *string `json:"key_backup,omitempty"`

	// The cluster-wide passphrase. This is not audited.
	// Example: The cluster password of length 32-256 ASCII characters.
	// Format: password
	Passphrase *strfmt.Password `json:"passphrase,omitempty"`

	// Synchronizes missing onboard keys on any node in the cluster. If a node is added to a cluster that has onboard key management configured, the synchronize operation needs to be performed in a PATCH operation. In a MetroCluster configuration, if onboard key management is enabled on one site, then the synchronize operation needs to be run as a POST operation on the remote site providing the same passphrase.
	Synchronize *bool `json:"synchronize,omitempty"`
}

// Validate validates this security key manager inline onboard
func (o *SecurityKeyManagerInlineOnboard) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExistingPassphrase(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePassphrase(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineOnboard) validateExistingPassphrase(formats strfmt.Registry) error {
	if swag.IsZero(o.ExistingPassphrase) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"onboard"+"."+"existing_passphrase", "body", "password", o.ExistingPassphrase.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SecurityKeyManagerInlineOnboard) validatePassphrase(formats strfmt.Registry) error {
	if swag.IsZero(o.Passphrase) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"onboard"+"."+"passphrase", "body", "password", o.Passphrase.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security key manager inline onboard based on the context it is used
func (o *SecurityKeyManagerInlineOnboard) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateKeyBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineOnboard) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"onboard"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *SecurityKeyManagerInlineOnboard) contextValidateKeyBackup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"onboard"+"."+"key_backup", "body", o.KeyBackup); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineOnboard) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineOnboard) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineOnboard
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineStatus Optional status information on the current state of the key manager indicating if it is fully setup or requires more action.
//
swagger:model security_key_manager_inline_status
*/
type SecurityKeyManagerInlineStatus struct {

	// Code corresponding to the status message. Returns 0 if the setup is complete. This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
	// Example: 346758
	Code *int64 `json:"code,omitempty"`

	// Current state of the key manager indicating any additional steps to perform to finish the setup. This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
	// Example: This cluster is part of a MetroCluster configuration. Use the REST API POST method security/key_managers/ with the synchronize option and the same passphrase on the partner cluster before proceeding with any key manager operations.  Failure to do so could lead to switchover or switchback failure.
	Message *string `json:"message,omitempty"`
}

// Validate validates this security key manager inline status
func (o *SecurityKeyManagerInlineStatus) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security key manager inline status based on context it is used
func (o *SecurityKeyManagerInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineStatus) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model security_key_manager_inline_svm
*/
type SecurityKeyManagerInlineSvm struct {

	// links
	Links *models.SecurityKeyManagerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security key manager inline svm
func (o *SecurityKeyManagerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline svm based on the context it is used
func (o *SecurityKeyManagerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineSvm) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineSvmInlineLinks security key manager inline svm inline links
swagger:model security_key_manager_inline_svm_inline__links
*/
type SecurityKeyManagerInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security key manager inline svm inline links
func (o *SecurityKeyManagerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security key manager inline svm inline links based on the context it is used
func (o *SecurityKeyManagerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityKeyManagerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityKeyManagerInlineVolumeEncryption Indicates whether volume encryption is supported in the cluster.
//
swagger:model security_key_manager_inline_volume_encryption
*/
type SecurityKeyManagerInlineVolumeEncryption struct {

	// Code corresponding to the status message. Returns a 0 if volume encryption is supported in all nodes of the cluster.
	// Example: 346758
	Code *int64 `json:"code,omitempty"`

	// Reason for not supporting volume encryption.
	// Example: No platform support for volume encryption in following nodes - node1, node2.
	Message *string `json:"message,omitempty"`

	// Set to true when volume encryption support is available on all nodes of the cluster.
	Supported *bool `json:"supported,omitempty"`
}

// Validate validates this security key manager inline volume encryption
func (o *SecurityKeyManagerInlineVolumeEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this security key manager inline volume encryption based on context it is used
func (o *SecurityKeyManagerInlineVolumeEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecurityKeyManagerInlineVolumeEncryption) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityKeyManagerInlineVolumeEncryption) UnmarshalBinary(b []byte) error {
	var res SecurityKeyManagerInlineVolumeEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
