// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityKeystoreCollectionGetParams creates a new SecurityKeystoreCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityKeystoreCollectionGetParams() *SecurityKeystoreCollectionGetParams {
	return &SecurityKeystoreCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityKeystoreCollectionGetParamsWithTimeout creates a new SecurityKeystoreCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityKeystoreCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityKeystoreCollectionGetParams {
	return &SecurityKeystoreCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityKeystoreCollectionGetParamsWithContext creates a new SecurityKeystoreCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityKeystoreCollectionGetParamsWithContext(ctx context.Context) *SecurityKeystoreCollectionGetParams {
	return &SecurityKeystoreCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityKeystoreCollectionGetParamsWithHTTPClient creates a new SecurityKeystoreCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityKeystoreCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityKeystoreCollectionGetParams {
	return &SecurityKeystoreCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityKeystoreCollectionGetParams contains all the parameters to send to the API endpoint

	for the security keystore collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityKeystoreCollectionGetParams struct {

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Location.

	   Filter by location
	*/
	Location *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* State.

	   Filter by state
	*/
	State *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security keystore collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeystoreCollectionGetParams) WithDefaults() *SecurityKeystoreCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security keystore collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeystoreCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityKeystoreCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityKeystoreCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithContext(ctx context.Context) *SecurityKeystoreCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityKeystoreCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConfigurationName adds the configurationName to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithConfigurationName(configurationName *string) *SecurityKeystoreCollectionGetParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithConfigurationUUID(configurationUUID *string) *SecurityKeystoreCollectionGetParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithEnabled adds the enabled to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithEnabled(enabled *bool) *SecurityKeystoreCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithFields(fields []string) *SecurityKeystoreCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLocation adds the location to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithLocation(location *string) *SecurityKeystoreCollectionGetParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetLocation(location *string) {
	o.Location = location
}

// WithMaxRecords adds the maxRecords to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityKeystoreCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithOrderBy(orderBy []string) *SecurityKeystoreCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityKeystoreCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityKeystoreCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithScope(scope *string) *SecurityKeystoreCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithState adds the state to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithState(state *string) *SecurityKeystoreCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSvmName adds the svmName to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithSvmName(svmName *string) *SecurityKeystoreCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithSvmUUID(svmUUID *string) *SecurityKeystoreCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithType(typeVar *string) *SecurityKeystoreCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) WithUUID(uuid *string) *SecurityKeystoreCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security keystore collection get params
func (o *SecurityKeystoreCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityKeystoreCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityKeystoreCollectionGet binds the parameter fields
func (o *SecurityKeystoreCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityKeystoreCollectionGet binds the parameter order_by
func (o *SecurityKeystoreCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
