// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityKeystoreDeleteCollectionParams creates a new SecurityKeystoreDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityKeystoreDeleteCollectionParams() *SecurityKeystoreDeleteCollectionParams {
	return &SecurityKeystoreDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityKeystoreDeleteCollectionParamsWithTimeout creates a new SecurityKeystoreDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityKeystoreDeleteCollectionParamsWithTimeout(timeout time.Duration) *SecurityKeystoreDeleteCollectionParams {
	return &SecurityKeystoreDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityKeystoreDeleteCollectionParamsWithContext creates a new SecurityKeystoreDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSecurityKeystoreDeleteCollectionParamsWithContext(ctx context.Context) *SecurityKeystoreDeleteCollectionParams {
	return &SecurityKeystoreDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSecurityKeystoreDeleteCollectionParamsWithHTTPClient creates a new SecurityKeystoreDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityKeystoreDeleteCollectionParamsWithHTTPClient(client *http.Client) *SecurityKeystoreDeleteCollectionParams {
	return &SecurityKeystoreDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityKeystoreDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the security keystore delete collection operation.

	Typically these are written to a http.Request.
*/
type SecurityKeystoreDeleteCollectionParams struct {

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info SecurityKeystoreDeleteCollectionBody

	/* Location.

	   Filter by location
	*/
	Location *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* State.

	   Filter by state
	*/
	State *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security keystore delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeystoreDeleteCollectionParams) WithDefaults() *SecurityKeystoreDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security keystore delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityKeystoreDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityKeystoreDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithTimeout(timeout time.Duration) *SecurityKeystoreDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithContext(ctx context.Context) *SecurityKeystoreDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithHTTPClient(client *http.Client) *SecurityKeystoreDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConfigurationName adds the configurationName to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithConfigurationName(configurationName *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithConfigurationUUID(configurationUUID *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithContinueOnFailure adds the continueOnFailure to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityKeystoreDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithEnabled(enabled *bool) *SecurityKeystoreDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithInfo(info SecurityKeystoreDeleteCollectionBody) *SecurityKeystoreDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetInfo(info SecurityKeystoreDeleteCollectionBody) {
	o.Info = info
}

// WithLocation adds the location to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithLocation(location *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetLocation(location *string) {
	o.Location = location
}

// WithReturnRecords adds the returnRecords to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityKeystoreDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityKeystoreDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithScope(scope *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityKeystoreDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithState adds the state to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithState(state *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetState(state *string) {
	o.State = state
}

// WithSvmName adds the svmName to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithSvmName(svmName *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithSvmUUID(svmUUID *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithType(typeVar *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) WithUUID(uuid *string) *SecurityKeystoreDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security keystore delete collection params
func (o *SecurityKeystoreDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityKeystoreDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
