// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityLogForwardingDeleteCollectionParams creates a new SecurityLogForwardingDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityLogForwardingDeleteCollectionParams() *SecurityLogForwardingDeleteCollectionParams {
	return &SecurityLogForwardingDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityLogForwardingDeleteCollectionParamsWithTimeout creates a new SecurityLogForwardingDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityLogForwardingDeleteCollectionParamsWithTimeout(timeout time.Duration) *SecurityLogForwardingDeleteCollectionParams {
	return &SecurityLogForwardingDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityLogForwardingDeleteCollectionParamsWithContext creates a new SecurityLogForwardingDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSecurityLogForwardingDeleteCollectionParamsWithContext(ctx context.Context) *SecurityLogForwardingDeleteCollectionParams {
	return &SecurityLogForwardingDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSecurityLogForwardingDeleteCollectionParamsWithHTTPClient creates a new SecurityLogForwardingDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityLogForwardingDeleteCollectionParamsWithHTTPClient(client *http.Client) *SecurityLogForwardingDeleteCollectionParams {
	return &SecurityLogForwardingDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityLogForwardingDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the security log forwarding delete collection operation.

	Typically these are written to a http.Request.
*/
type SecurityLogForwardingDeleteCollectionParams struct {

	/* Address.

	   Filter by address
	*/
	Address *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Facility.

	   Filter by facility
	*/
	Facility *string

	/* HostnameFormatOverride.

	   Filter by hostname_format_override
	*/
	HostnameFormatOverride *string

	/* Info.

	   Info specification
	*/
	Info SecurityLogForwardingDeleteCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* MessageFormat.

	   Filter by message_format
	*/
	MessageFormat *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* TimestampFormatOverride.

	   Filter by timestamp_format_override
	*/
	TimestampFormatOverride *string

	/* VerifyServer.

	   Filter by verify_server
	*/
	VerifyServer *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security log forwarding delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityLogForwardingDeleteCollectionParams) WithDefaults() *SecurityLogForwardingDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security log forwarding delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityLogForwardingDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityLogForwardingDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithTimeout(timeout time.Duration) *SecurityLogForwardingDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithContext(ctx context.Context) *SecurityLogForwardingDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithHTTPClient(client *http.Client) *SecurityLogForwardingDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithAddress(address *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetAddress(address *string) {
	o.Address = address
}

// WithContinueOnFailure adds the continueOnFailure to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityLogForwardingDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFacility adds the facility to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithFacility(facility *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetFacility(facility)
	return o
}

// SetFacility adds the facility to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetFacility(facility *string) {
	o.Facility = facility
}

// WithHostnameFormatOverride adds the hostnameFormatOverride to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithHostnameFormatOverride(hostnameFormatOverride *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetHostnameFormatOverride(hostnameFormatOverride)
	return o
}

// SetHostnameFormatOverride adds the hostnameFormatOverride to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetHostnameFormatOverride(hostnameFormatOverride *string) {
	o.HostnameFormatOverride = hostnameFormatOverride
}

// WithInfo adds the info to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithInfo(info SecurityLogForwardingDeleteCollectionBody) *SecurityLogForwardingDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetInfo(info SecurityLogForwardingDeleteCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithIpspaceName(ipspaceName *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMessageFormat adds the messageFormat to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithMessageFormat(messageFormat *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetMessageFormat(messageFormat)
	return o
}

// SetMessageFormat adds the messageFormat to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetMessageFormat(messageFormat *string) {
	o.MessageFormat = messageFormat
}

// WithPort adds the port to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithPort(port *int64) *SecurityLogForwardingDeleteCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithProtocol adds the protocol to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithProtocol(protocol *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityLogForwardingDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityLogForwardingDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityLogForwardingDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithTimestampFormatOverride adds the timestampFormatOverride to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithTimestampFormatOverride(timestampFormatOverride *string) *SecurityLogForwardingDeleteCollectionParams {
	o.SetTimestampFormatOverride(timestampFormatOverride)
	return o
}

// SetTimestampFormatOverride adds the timestampFormatOverride to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetTimestampFormatOverride(timestampFormatOverride *string) {
	o.TimestampFormatOverride = timestampFormatOverride
}

// WithVerifyServer adds the verifyServer to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) WithVerifyServer(verifyServer *bool) *SecurityLogForwardingDeleteCollectionParams {
	o.SetVerifyServer(verifyServer)
	return o
}

// SetVerifyServer adds the verifyServer to the security log forwarding delete collection params
func (o *SecurityLogForwardingDeleteCollectionParams) SetVerifyServer(verifyServer *bool) {
	o.VerifyServer = verifyServer
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityLogForwardingDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// query param address
		var qrAddress string

		if o.Address != nil {
			qrAddress = *o.Address
		}
		qAddress := qrAddress
		if qAddress != "" {

			if err := r.SetQueryParam("address", qAddress); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Facility != nil {

		// query param facility
		var qrFacility string

		if o.Facility != nil {
			qrFacility = *o.Facility
		}
		qFacility := qrFacility
		if qFacility != "" {

			if err := r.SetQueryParam("facility", qFacility); err != nil {
				return err
			}
		}
	}

	if o.HostnameFormatOverride != nil {

		// query param hostname_format_override
		var qrHostnameFormatOverride string

		if o.HostnameFormatOverride != nil {
			qrHostnameFormatOverride = *o.HostnameFormatOverride
		}
		qHostnameFormatOverride := qrHostnameFormatOverride
		if qHostnameFormatOverride != "" {

			if err := r.SetQueryParam("hostname_format_override", qHostnameFormatOverride); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MessageFormat != nil {

		// query param message_format
		var qrMessageFormat string

		if o.MessageFormat != nil {
			qrMessageFormat = *o.MessageFormat
		}
		qMessageFormat := qrMessageFormat
		if qMessageFormat != "" {

			if err := r.SetQueryParam("message_format", qMessageFormat); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.TimestampFormatOverride != nil {

		// query param timestamp_format_override
		var qrTimestampFormatOverride string

		if o.TimestampFormatOverride != nil {
			qrTimestampFormatOverride = *o.TimestampFormatOverride
		}
		qTimestampFormatOverride := qrTimestampFormatOverride
		if qTimestampFormatOverride != "" {

			if err := r.SetQueryParam("timestamp_format_override", qTimestampFormatOverride); err != nil {
				return err
			}
		}
	}

	if o.VerifyServer != nil {

		// query param verify_server
		var qrVerifyServer bool

		if o.VerifyServer != nil {
			qrVerifyServer = *o.VerifyServer
		}
		qVerifyServer := swag.FormatBool(qrVerifyServer)
		if qVerifyServer != "" {

			if err := r.SetQueryParam("verify_server", qVerifyServer); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
