// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityLogForwardingDeleteCollectionReader is a Reader for the SecurityLogForwardingDeleteCollection structure.
type SecurityLogForwardingDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityLogForwardingDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityLogForwardingDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityLogForwardingDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityLogForwardingDeleteCollectionOK creates a SecurityLogForwardingDeleteCollectionOK with default headers values
func NewSecurityLogForwardingDeleteCollectionOK() *SecurityLogForwardingDeleteCollectionOK {
	return &SecurityLogForwardingDeleteCollectionOK{}
}

/*
SecurityLogForwardingDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityLogForwardingDeleteCollectionOK struct {
}

// IsSuccess returns true when this security log forwarding delete collection o k response has a 2xx status code
func (o *SecurityLogForwardingDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security log forwarding delete collection o k response has a 3xx status code
func (o *SecurityLogForwardingDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security log forwarding delete collection o k response has a 4xx status code
func (o *SecurityLogForwardingDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security log forwarding delete collection o k response has a 5xx status code
func (o *SecurityLogForwardingDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security log forwarding delete collection o k response a status code equal to that given
func (o *SecurityLogForwardingDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security log forwarding delete collection o k response
func (o *SecurityLogForwardingDeleteCollectionOK) Code() int {
	return 200
}

func (o *SecurityLogForwardingDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/audit/destinations][%d] securityLogForwardingDeleteCollectionOK", 200)
}

func (o *SecurityLogForwardingDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/audit/destinations][%d] securityLogForwardingDeleteCollectionOK", 200)
}

func (o *SecurityLogForwardingDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityLogForwardingDeleteCollectionDefault creates a SecurityLogForwardingDeleteCollectionDefault with default headers values
func NewSecurityLogForwardingDeleteCollectionDefault(code int) *SecurityLogForwardingDeleteCollectionDefault {
	return &SecurityLogForwardingDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
SecurityLogForwardingDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityLogForwardingDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security log forwarding delete collection default response has a 2xx status code
func (o *SecurityLogForwardingDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security log forwarding delete collection default response has a 3xx status code
func (o *SecurityLogForwardingDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security log forwarding delete collection default response has a 4xx status code
func (o *SecurityLogForwardingDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security log forwarding delete collection default response has a 5xx status code
func (o *SecurityLogForwardingDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security log forwarding delete collection default response a status code equal to that given
func (o *SecurityLogForwardingDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security log forwarding delete collection default response
func (o *SecurityLogForwardingDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityLogForwardingDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/audit/destinations][%d] security_log_forwarding_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityLogForwardingDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/audit/destinations][%d] security_log_forwarding_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityLogForwardingDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityLogForwardingDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityLogForwardingDeleteCollectionBody security log forwarding delete collection body
swagger:model SecurityLogForwardingDeleteCollectionBody
*/
type SecurityLogForwardingDeleteCollectionBody struct {

	// security audit log forward response inline records
	SecurityAuditLogForwardResponseInlineRecords []*models.SecurityAuditLogForward `json:"records,omitempty"`
}

// Validate validates this security log forwarding delete collection body
func (o *SecurityLogForwardingDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSecurityAuditLogForwardResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityLogForwardingDeleteCollectionBody) validateSecurityAuditLogForwardResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityAuditLogForwardResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityAuditLogForwardResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityAuditLogForwardResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityAuditLogForwardResponseInlineRecords[i] != nil {
			if err := o.SecurityAuditLogForwardResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security log forwarding delete collection body based on the context it is used
func (o *SecurityLogForwardingDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSecurityAuditLogForwardResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityLogForwardingDeleteCollectionBody) contextValidateSecurityAuditLogForwardResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityAuditLogForwardResponseInlineRecords); i++ {

		if o.SecurityAuditLogForwardResponseInlineRecords[i] != nil {
			if err := o.SecurityAuditLogForwardResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityLogForwardingDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityLogForwardingDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityLogForwardingDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
