// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityLogForwardingModifyCollectionParams creates a new SecurityLogForwardingModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityLogForwardingModifyCollectionParams() *SecurityLogForwardingModifyCollectionParams {
	return &SecurityLogForwardingModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityLogForwardingModifyCollectionParamsWithTimeout creates a new SecurityLogForwardingModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityLogForwardingModifyCollectionParamsWithTimeout(timeout time.Duration) *SecurityLogForwardingModifyCollectionParams {
	return &SecurityLogForwardingModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityLogForwardingModifyCollectionParamsWithContext creates a new SecurityLogForwardingModifyCollectionParams object
// with the ability to set a context for a request.
func NewSecurityLogForwardingModifyCollectionParamsWithContext(ctx context.Context) *SecurityLogForwardingModifyCollectionParams {
	return &SecurityLogForwardingModifyCollectionParams{
		Context: ctx,
	}
}

// NewSecurityLogForwardingModifyCollectionParamsWithHTTPClient creates a new SecurityLogForwardingModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityLogForwardingModifyCollectionParamsWithHTTPClient(client *http.Client) *SecurityLogForwardingModifyCollectionParams {
	return &SecurityLogForwardingModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityLogForwardingModifyCollectionParams contains all the parameters to send to the API endpoint

	for the security log forwarding modify collection operation.

	Typically these are written to a http.Request.
*/
type SecurityLogForwardingModifyCollectionParams struct {

	/* Address.

	   Filter by address
	*/
	Address *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Facility.

	   Filter by facility
	*/
	Facility *string

	/* HostnameFormatOverride.

	   Filter by hostname_format_override
	*/
	HostnameFormatOverride *string

	/* Info.

	   Info specification
	*/
	Info SecurityLogForwardingModifyCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* MessageFormat.

	   Filter by message_format
	*/
	MessageFormat *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* TimestampFormatOverride.

	   Filter by timestamp_format_override
	*/
	TimestampFormatOverride *string

	/* VerifyServer.

	   Filter by verify_server
	*/
	VerifyServer *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security log forwarding modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityLogForwardingModifyCollectionParams) WithDefaults() *SecurityLogForwardingModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security log forwarding modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityLogForwardingModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityLogForwardingModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithTimeout(timeout time.Duration) *SecurityLogForwardingModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithContext(ctx context.Context) *SecurityLogForwardingModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithHTTPClient(client *http.Client) *SecurityLogForwardingModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithAddress(address *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetAddress(address *string) {
	o.Address = address
}

// WithContinueOnFailure adds the continueOnFailure to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityLogForwardingModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFacility adds the facility to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithFacility(facility *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetFacility(facility)
	return o
}

// SetFacility adds the facility to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetFacility(facility *string) {
	o.Facility = facility
}

// WithHostnameFormatOverride adds the hostnameFormatOverride to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithHostnameFormatOverride(hostnameFormatOverride *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetHostnameFormatOverride(hostnameFormatOverride)
	return o
}

// SetHostnameFormatOverride adds the hostnameFormatOverride to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetHostnameFormatOverride(hostnameFormatOverride *string) {
	o.HostnameFormatOverride = hostnameFormatOverride
}

// WithInfo adds the info to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithInfo(info SecurityLogForwardingModifyCollectionBody) *SecurityLogForwardingModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetInfo(info SecurityLogForwardingModifyCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithIpspaceName(ipspaceName *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMessageFormat adds the messageFormat to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithMessageFormat(messageFormat *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetMessageFormat(messageFormat)
	return o
}

// SetMessageFormat adds the messageFormat to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetMessageFormat(messageFormat *string) {
	o.MessageFormat = messageFormat
}

// WithPort adds the port to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithPort(port *int64) *SecurityLogForwardingModifyCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithProtocol adds the protocol to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithProtocol(protocol *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityLogForwardingModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityLogForwardingModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityLogForwardingModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithTimestampFormatOverride adds the timestampFormatOverride to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithTimestampFormatOverride(timestampFormatOverride *string) *SecurityLogForwardingModifyCollectionParams {
	o.SetTimestampFormatOverride(timestampFormatOverride)
	return o
}

// SetTimestampFormatOverride adds the timestampFormatOverride to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetTimestampFormatOverride(timestampFormatOverride *string) {
	o.TimestampFormatOverride = timestampFormatOverride
}

// WithVerifyServer adds the verifyServer to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) WithVerifyServer(verifyServer *bool) *SecurityLogForwardingModifyCollectionParams {
	o.SetVerifyServer(verifyServer)
	return o
}

// SetVerifyServer adds the verifyServer to the security log forwarding modify collection params
func (o *SecurityLogForwardingModifyCollectionParams) SetVerifyServer(verifyServer *bool) {
	o.VerifyServer = verifyServer
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityLogForwardingModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// query param address
		var qrAddress string

		if o.Address != nil {
			qrAddress = *o.Address
		}
		qAddress := qrAddress
		if qAddress != "" {

			if err := r.SetQueryParam("address", qAddress); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Facility != nil {

		// query param facility
		var qrFacility string

		if o.Facility != nil {
			qrFacility = *o.Facility
		}
		qFacility := qrFacility
		if qFacility != "" {

			if err := r.SetQueryParam("facility", qFacility); err != nil {
				return err
			}
		}
	}

	if o.HostnameFormatOverride != nil {

		// query param hostname_format_override
		var qrHostnameFormatOverride string

		if o.HostnameFormatOverride != nil {
			qrHostnameFormatOverride = *o.HostnameFormatOverride
		}
		qHostnameFormatOverride := qrHostnameFormatOverride
		if qHostnameFormatOverride != "" {

			if err := r.SetQueryParam("hostname_format_override", qHostnameFormatOverride); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MessageFormat != nil {

		// query param message_format
		var qrMessageFormat string

		if o.MessageFormat != nil {
			qrMessageFormat = *o.MessageFormat
		}
		qMessageFormat := qrMessageFormat
		if qMessageFormat != "" {

			if err := r.SetQueryParam("message_format", qMessageFormat); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.TimestampFormatOverride != nil {

		// query param timestamp_format_override
		var qrTimestampFormatOverride string

		if o.TimestampFormatOverride != nil {
			qrTimestampFormatOverride = *o.TimestampFormatOverride
		}
		qTimestampFormatOverride := qrTimestampFormatOverride
		if qTimestampFormatOverride != "" {

			if err := r.SetQueryParam("timestamp_format_override", qTimestampFormatOverride); err != nil {
				return err
			}
		}
	}

	if o.VerifyServer != nil {

		// query param verify_server
		var qrVerifyServer bool

		if o.VerifyServer != nil {
			qrVerifyServer = *o.VerifyServer
		}
		qVerifyServer := swag.FormatBool(qrVerifyServer)
		if qVerifyServer != "" {

			if err := r.SetQueryParam("verify_server", qVerifyServer); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
