// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityLogForwardingModifyCollectionReader is a Reader for the SecurityLogForwardingModifyCollection structure.
type SecurityLogForwardingModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityLogForwardingModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityLogForwardingModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityLogForwardingModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityLogForwardingModifyCollectionOK creates a SecurityLogForwardingModifyCollectionOK with default headers values
func NewSecurityLogForwardingModifyCollectionOK() *SecurityLogForwardingModifyCollectionOK {
	return &SecurityLogForwardingModifyCollectionOK{}
}

/*
SecurityLogForwardingModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityLogForwardingModifyCollectionOK struct {
	Payload *models.SecurityAuditLogForward
}

// IsSuccess returns true when this security log forwarding modify collection o k response has a 2xx status code
func (o *SecurityLogForwardingModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security log forwarding modify collection o k response has a 3xx status code
func (o *SecurityLogForwardingModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security log forwarding modify collection o k response has a 4xx status code
func (o *SecurityLogForwardingModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security log forwarding modify collection o k response has a 5xx status code
func (o *SecurityLogForwardingModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security log forwarding modify collection o k response a status code equal to that given
func (o *SecurityLogForwardingModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security log forwarding modify collection o k response
func (o *SecurityLogForwardingModifyCollectionOK) Code() int {
	return 200
}

func (o *SecurityLogForwardingModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations][%d] securityLogForwardingModifyCollectionOK %s", 200, payload)
}

func (o *SecurityLogForwardingModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations][%d] securityLogForwardingModifyCollectionOK %s", 200, payload)
}

func (o *SecurityLogForwardingModifyCollectionOK) GetPayload() *models.SecurityAuditLogForward {
	return o.Payload
}

func (o *SecurityLogForwardingModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityAuditLogForward)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityLogForwardingModifyCollectionDefault creates a SecurityLogForwardingModifyCollectionDefault with default headers values
func NewSecurityLogForwardingModifyCollectionDefault(code int) *SecurityLogForwardingModifyCollectionDefault {
	return &SecurityLogForwardingModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
SecurityLogForwardingModifyCollectionDefault describes a response with status code -1, with default header values.

Default
*/
type SecurityLogForwardingModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security log forwarding modify collection default response has a 2xx status code
func (o *SecurityLogForwardingModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security log forwarding modify collection default response has a 3xx status code
func (o *SecurityLogForwardingModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security log forwarding modify collection default response has a 4xx status code
func (o *SecurityLogForwardingModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security log forwarding modify collection default response has a 5xx status code
func (o *SecurityLogForwardingModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security log forwarding modify collection default response a status code equal to that given
func (o *SecurityLogForwardingModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security log forwarding modify collection default response
func (o *SecurityLogForwardingModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityLogForwardingModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations][%d] security_log_forwarding_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityLogForwardingModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations][%d] security_log_forwarding_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityLogForwardingModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityLogForwardingModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityLogForwardingModifyCollectionBody security log forwarding modify collection body
swagger:model SecurityLogForwardingModifyCollectionBody
*/
type SecurityLogForwardingModifyCollectionBody struct {

	// Destination syslog|splunk host to forward audit records to. This can be an IP address (IPv4|IPv6) or a hostname.
	// Example: 1.1.1.1
	Address *string `json:"address,omitempty"`

	// This is the standard Syslog Facility value that is used when sending audit records to a remote server.
	// Enum: ["kern","user","local0","local1","local2","local3","local4","local5","local6","local7"]
	Facility *string `json:"facility,omitempty"`

	// Syslog Hostname Format Override
	// Enum: ["no_override","fqdn","hostname_only"]
	HostnameFormatOverride *string `json:"hostname_format_override,omitempty"`

	// ipspace
	Ipspace *models.SecurityAuditLogForwardInlineIpspace `json:"ipspace,omitempty"`

	// Syslog message format to be used. legacy_netapp format (variation of RFC-3164) is default message format.
	// Enum: ["legacy_netapp","rfc_5424"]
	MessageFormat *string `json:"message_format,omitempty"`

	// Destination Port. The default port depends on the protocol chosen:
	// For un-encrypted destinations the default port is 514.
	// For encrypted destinations the default port is 6514.
	//
	// Example: 514
	Port *int64 `json:"port,omitempty"`

	// Log forwarding protocol
	// Enum: ["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]
	Protocol *string `json:"protocol,omitempty"`

	// security audit log forward response inline records
	SecurityAuditLogForwardResponseInlineRecords []*models.SecurityAuditLogForward `json:"records,omitempty"`

	// Syslog Timestamp Format Override.
	// Enum: ["no_override","rfc_3164","iso_8601_utc","iso_8601_local_time"]
	TimestampFormatOverride *string `json:"timestamp_format_override,omitempty"`

	// This is only applicable when the protocol is tcp_encrypted. This controls whether the remote server's certificate is validated. Setting "verify_server" to "true" will enforce validation of remote server's certificate. Setting "verify_server" to "false" will not enforce validation of remote server's certificate.
	VerifyServer *bool `json:"verify_server,omitempty"`
}

// Validate validates this security log forwarding modify collection body
func (o *SecurityLogForwardingModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFacility(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHostnameFormatOverride(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessageFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityAuditLogForwardResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestampFormatOverride(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var securityLogForwardingModifyCollectionBodyTypeFacilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["kern","user","local0","local1","local2","local3","local4","local5","local6","local7"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityLogForwardingModifyCollectionBodyTypeFacilityPropEnum = append(securityLogForwardingModifyCollectionBodyTypeFacilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// kern
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityKern captures enum value "kern"
	SecurityLogForwardingModifyCollectionBodyFacilityKern string = "kern"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// user
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityUser captures enum value "user"
	SecurityLogForwardingModifyCollectionBodyFacilityUser string = "user"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local0
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal0 captures enum value "local0"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal0 string = "local0"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local1
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal1 captures enum value "local1"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal1 string = "local1"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local2
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal2 captures enum value "local2"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal2 string = "local2"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local3
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal3 captures enum value "local3"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal3 string = "local3"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local4
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal4 captures enum value "local4"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal4 string = "local4"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local5
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal5 captures enum value "local5"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal5 string = "local5"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local6
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal6 captures enum value "local6"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal6 string = "local6"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// facility
	// Facility
	// local7
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyFacilityLocal7 captures enum value "local7"
	SecurityLogForwardingModifyCollectionBodyFacilityLocal7 string = "local7"
)

// prop value enum
func (o *SecurityLogForwardingModifyCollectionBody) validateFacilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityLogForwardingModifyCollectionBodyTypeFacilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateFacility(formats strfmt.Registry) error {
	if swag.IsZero(o.Facility) { // not required
		return nil
	}

	// value enum
	if err := o.validateFacilityEnum("info"+"."+"facility", "body", *o.Facility); err != nil {
		return err
	}

	return nil
}

var securityLogForwardingModifyCollectionBodyTypeHostnameFormatOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","fqdn","hostname_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityLogForwardingModifyCollectionBodyTypeHostnameFormatOverridePropEnum = append(securityLogForwardingModifyCollectionBodyTypeHostnameFormatOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// hostname_format_override
	// HostnameFormatOverride
	// no_override
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyHostnameFormatOverrideNoOverride captures enum value "no_override"
	SecurityLogForwardingModifyCollectionBodyHostnameFormatOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// hostname_format_override
	// HostnameFormatOverride
	// fqdn
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyHostnameFormatOverrideFqdn captures enum value "fqdn"
	SecurityLogForwardingModifyCollectionBodyHostnameFormatOverrideFqdn string = "fqdn"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// hostname_format_override
	// HostnameFormatOverride
	// hostname_only
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyHostnameFormatOverrideHostnameOnly captures enum value "hostname_only"
	SecurityLogForwardingModifyCollectionBodyHostnameFormatOverrideHostnameOnly string = "hostname_only"
)

// prop value enum
func (o *SecurityLogForwardingModifyCollectionBody) validateHostnameFormatOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityLogForwardingModifyCollectionBodyTypeHostnameFormatOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateHostnameFormatOverride(formats strfmt.Registry) error {
	if swag.IsZero(o.HostnameFormatOverride) { // not required
		return nil
	}

	// value enum
	if err := o.validateHostnameFormatOverrideEnum("info"+"."+"hostname_format_override", "body", *o.HostnameFormatOverride); err != nil {
		return err
	}

	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

var securityLogForwardingModifyCollectionBodyTypeMessageFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy_netapp","rfc_5424"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityLogForwardingModifyCollectionBodyTypeMessageFormatPropEnum = append(securityLogForwardingModifyCollectionBodyTypeMessageFormatPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// message_format
	// MessageFormat
	// legacy_netapp
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyMessageFormatLegacyNetapp captures enum value "legacy_netapp"
	SecurityLogForwardingModifyCollectionBodyMessageFormatLegacyNetapp string = "legacy_netapp"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// message_format
	// MessageFormat
	// rfc_5424
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyMessageFormatRfc5424 captures enum value "rfc_5424"
	SecurityLogForwardingModifyCollectionBodyMessageFormatRfc5424 string = "rfc_5424"
)

// prop value enum
func (o *SecurityLogForwardingModifyCollectionBody) validateMessageFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityLogForwardingModifyCollectionBodyTypeMessageFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateMessageFormat(formats strfmt.Registry) error {
	if swag.IsZero(o.MessageFormat) { // not required
		return nil
	}

	// value enum
	if err := o.validateMessageFormatEnum("info"+"."+"message_format", "body", *o.MessageFormat); err != nil {
		return err
	}

	return nil
}

var securityLogForwardingModifyCollectionBodyTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityLogForwardingModifyCollectionBodyTypeProtocolPropEnum = append(securityLogForwardingModifyCollectionBodyTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// protocol
	// Protocol
	// udp_unencrypted
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyProtocolUDPUnencrypted captures enum value "udp_unencrypted"
	SecurityLogForwardingModifyCollectionBodyProtocolUDPUnencrypted string = "udp_unencrypted"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// protocol
	// Protocol
	// tcp_unencrypted
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyProtocolTCPUnencrypted captures enum value "tcp_unencrypted"
	SecurityLogForwardingModifyCollectionBodyProtocolTCPUnencrypted string = "tcp_unencrypted"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// protocol
	// Protocol
	// tcp_encrypted
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyProtocolTCPEncrypted captures enum value "tcp_encrypted"
	SecurityLogForwardingModifyCollectionBodyProtocolTCPEncrypted string = "tcp_encrypted"
)

// prop value enum
func (o *SecurityLogForwardingModifyCollectionBody) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityLogForwardingModifyCollectionBodyTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("info"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateSecurityAuditLogForwardResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityAuditLogForwardResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityAuditLogForwardResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityAuditLogForwardResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityAuditLogForwardResponseInlineRecords[i] != nil {
			if err := o.SecurityAuditLogForwardResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var securityLogForwardingModifyCollectionBodyTypeTimestampFormatOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","rfc_3164","iso_8601_utc","iso_8601_local_time"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityLogForwardingModifyCollectionBodyTypeTimestampFormatOverridePropEnum = append(securityLogForwardingModifyCollectionBodyTypeTimestampFormatOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// timestamp_format_override
	// TimestampFormatOverride
	// no_override
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideNoOverride captures enum value "no_override"
	SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// timestamp_format_override
	// TimestampFormatOverride
	// rfc_3164
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideRfc3164 captures enum value "rfc_3164"
	SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideRfc3164 string = "rfc_3164"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// timestamp_format_override
	// TimestampFormatOverride
	// iso_8601_utc
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideIso8601Utc captures enum value "iso_8601_utc"
	SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideIso8601Utc string = "iso_8601_utc"

	// BEGIN DEBUGGING
	// SecurityLogForwardingModifyCollectionBody
	// SecurityLogForwardingModifyCollectionBody
	// timestamp_format_override
	// TimestampFormatOverride
	// iso_8601_local_time
	// END DEBUGGING
	// SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideIso8601LocalTime captures enum value "iso_8601_local_time"
	SecurityLogForwardingModifyCollectionBodyTimestampFormatOverrideIso8601LocalTime string = "iso_8601_local_time"
)

// prop value enum
func (o *SecurityLogForwardingModifyCollectionBody) validateTimestampFormatOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityLogForwardingModifyCollectionBodyTypeTimestampFormatOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) validateTimestampFormatOverride(formats strfmt.Registry) error {
	if swag.IsZero(o.TimestampFormatOverride) { // not required
		return nil
	}

	// value enum
	if err := o.validateTimestampFormatOverrideEnum("info"+"."+"timestamp_format_override", "body", *o.TimestampFormatOverride); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security log forwarding modify collection body based on the context it is used
func (o *SecurityLogForwardingModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityAuditLogForwardResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityLogForwardingModifyCollectionBody) contextValidateSecurityAuditLogForwardResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityAuditLogForwardResponseInlineRecords); i++ {

		if o.SecurityAuditLogForwardResponseInlineRecords[i] != nil {
			if err := o.SecurityAuditLogForwardResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityLogForwardingModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityLogForwardingModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityLogForwardingModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityAuditLogForwardInlineIpspace security audit log forward inline ipspace
swagger:model security_audit_log_forward_inline_ipspace
*/
type SecurityAuditLogForwardInlineIpspace struct {

	// links
	Links *models.SecurityAuditLogForwardInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security audit log forward inline ipspace
func (o *SecurityAuditLogForwardInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityAuditLogForwardInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security audit log forward inline ipspace based on the context it is used
func (o *SecurityAuditLogForwardInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityAuditLogForwardInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityAuditLogForwardInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityAuditLogForwardInlineIpspace) UnmarshalBinary(b []byte) error {
	var res SecurityAuditLogForwardInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityAuditLogForwardInlineIpspaceInlineLinks security audit log forward inline ipspace inline links
swagger:model security_audit_log_forward_inline_ipspace_inline__links
*/
type SecurityAuditLogForwardInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security audit log forward inline ipspace inline links
func (o *SecurityAuditLogForwardInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityAuditLogForwardInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security audit log forward inline ipspace inline links based on the context it is used
func (o *SecurityAuditLogForwardInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityAuditLogForwardInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityAuditLogForwardInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityAuditLogForwardInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityAuditLogForwardInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
