// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityLogForwardingModifyReader is a Reader for the SecurityLogForwardingModify structure.
type SecurityLogForwardingModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityLogForwardingModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityLogForwardingModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityLogForwardingModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityLogForwardingModifyOK creates a SecurityLogForwardingModifyOK with default headers values
func NewSecurityLogForwardingModifyOK() *SecurityLogForwardingModifyOK {
	return &SecurityLogForwardingModifyOK{}
}

/*
SecurityLogForwardingModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecurityLogForwardingModifyOK struct {
	Payload *models.SecurityAuditLogForward
}

// IsSuccess returns true when this security log forwarding modify o k response has a 2xx status code
func (o *SecurityLogForwardingModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security log forwarding modify o k response has a 3xx status code
func (o *SecurityLogForwardingModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security log forwarding modify o k response has a 4xx status code
func (o *SecurityLogForwardingModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security log forwarding modify o k response has a 5xx status code
func (o *SecurityLogForwardingModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security log forwarding modify o k response a status code equal to that given
func (o *SecurityLogForwardingModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security log forwarding modify o k response
func (o *SecurityLogForwardingModifyOK) Code() int {
	return 200
}

func (o *SecurityLogForwardingModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations/{address}/{port}][%d] securityLogForwardingModifyOK %s", 200, payload)
}

func (o *SecurityLogForwardingModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations/{address}/{port}][%d] securityLogForwardingModifyOK %s", 200, payload)
}

func (o *SecurityLogForwardingModifyOK) GetPayload() *models.SecurityAuditLogForward {
	return o.Payload
}

func (o *SecurityLogForwardingModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityAuditLogForward)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityLogForwardingModifyDefault creates a SecurityLogForwardingModifyDefault with default headers values
func NewSecurityLogForwardingModifyDefault(code int) *SecurityLogForwardingModifyDefault {
	return &SecurityLogForwardingModifyDefault{
		_statusCode: code,
	}
}

/*
SecurityLogForwardingModifyDefault describes a response with status code -1, with default header values.

Default
*/
type SecurityLogForwardingModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security log forwarding modify default response has a 2xx status code
func (o *SecurityLogForwardingModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security log forwarding modify default response has a 3xx status code
func (o *SecurityLogForwardingModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security log forwarding modify default response has a 4xx status code
func (o *SecurityLogForwardingModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security log forwarding modify default response has a 5xx status code
func (o *SecurityLogForwardingModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security log forwarding modify default response a status code equal to that given
func (o *SecurityLogForwardingModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security log forwarding modify default response
func (o *SecurityLogForwardingModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecurityLogForwardingModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations/{address}/{port}][%d] security_log_forwarding_modify default %s", o._statusCode, payload)
}

func (o *SecurityLogForwardingModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit/destinations/{address}/{port}][%d] security_log_forwarding_modify default %s", o._statusCode, payload)
}

func (o *SecurityLogForwardingModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityLogForwardingModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
