// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityOauth2CollectionGetReader is a Reader for the SecurityOauth2CollectionGet structure.
type SecurityOauth2CollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityOauth2CollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityOauth2CollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityOauth2CollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityOauth2CollectionGetOK creates a SecurityOauth2CollectionGetOK with default headers values
func NewSecurityOauth2CollectionGetOK() *SecurityOauth2CollectionGetOK {
	return &SecurityOauth2CollectionGetOK{}
}

/*
SecurityOauth2CollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityOauth2CollectionGetOK struct {
	Payload *models.SecurityOauth2Response
}

// IsSuccess returns true when this security oauth2 collection get o k response has a 2xx status code
func (o *SecurityOauth2CollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oauth2 collection get o k response has a 3xx status code
func (o *SecurityOauth2CollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oauth2 collection get o k response has a 4xx status code
func (o *SecurityOauth2CollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oauth2 collection get o k response has a 5xx status code
func (o *SecurityOauth2CollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security oauth2 collection get o k response a status code equal to that given
func (o *SecurityOauth2CollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security oauth2 collection get o k response
func (o *SecurityOauth2CollectionGetOK) Code() int {
	return 200
}

func (o *SecurityOauth2CollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/cluster/oauth2/clients][%d] securityOauth2CollectionGetOK %s", 200, payload)
}

func (o *SecurityOauth2CollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/cluster/oauth2/clients][%d] securityOauth2CollectionGetOK %s", 200, payload)
}

func (o *SecurityOauth2CollectionGetOK) GetPayload() *models.SecurityOauth2Response {
	return o.Payload
}

func (o *SecurityOauth2CollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityOauth2Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityOauth2CollectionGetDefault creates a SecurityOauth2CollectionGetDefault with default headers values
func NewSecurityOauth2CollectionGetDefault(code int) *SecurityOauth2CollectionGetDefault {
	return &SecurityOauth2CollectionGetDefault{
		_statusCode: code,
	}
}

/*
SecurityOauth2CollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityOauth2CollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security oauth2 collection get default response has a 2xx status code
func (o *SecurityOauth2CollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security oauth2 collection get default response has a 3xx status code
func (o *SecurityOauth2CollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security oauth2 collection get default response has a 4xx status code
func (o *SecurityOauth2CollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security oauth2 collection get default response has a 5xx status code
func (o *SecurityOauth2CollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security oauth2 collection get default response a status code equal to that given
func (o *SecurityOauth2CollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security oauth2 collection get default response
func (o *SecurityOauth2CollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityOauth2CollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/cluster/oauth2/clients][%d] security_oauth2_collection_get default %s", o._statusCode, payload)
}

func (o *SecurityOauth2CollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/cluster/oauth2/clients][%d] security_oauth2_collection_get default %s", o._statusCode, payload)
}

func (o *SecurityOauth2CollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityOauth2CollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
