// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityOauth2CreateReader is a Reader for the SecurityOauth2Create structure.
type SecurityOauth2CreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityOauth2CreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecurityOauth2CreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSecurityOauth2CreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityOauth2CreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityOauth2CreateCreated creates a SecurityOauth2CreateCreated with default headers values
func NewSecurityOauth2CreateCreated() *SecurityOauth2CreateCreated {
	return &SecurityOauth2CreateCreated{}
}

/*
SecurityOauth2CreateCreated describes a response with status code 201, with default header values.

Created
*/
type SecurityOauth2CreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecurityOauth2JobLinkResponse
}

// IsSuccess returns true when this security oauth2 create created response has a 2xx status code
func (o *SecurityOauth2CreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oauth2 create created response has a 3xx status code
func (o *SecurityOauth2CreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oauth2 create created response has a 4xx status code
func (o *SecurityOauth2CreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oauth2 create created response has a 5xx status code
func (o *SecurityOauth2CreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this security oauth2 create created response a status code equal to that given
func (o *SecurityOauth2CreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the security oauth2 create created response
func (o *SecurityOauth2CreateCreated) Code() int {
	return 201
}

func (o *SecurityOauth2CreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oauth2/clients][%d] securityOauth2CreateCreated %s", 201, payload)
}

func (o *SecurityOauth2CreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oauth2/clients][%d] securityOauth2CreateCreated %s", 201, payload)
}

func (o *SecurityOauth2CreateCreated) GetPayload() *models.SecurityOauth2JobLinkResponse {
	return o.Payload
}

func (o *SecurityOauth2CreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecurityOauth2JobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityOauth2CreateAccepted creates a SecurityOauth2CreateAccepted with default headers values
func NewSecurityOauth2CreateAccepted() *SecurityOauth2CreateAccepted {
	return &SecurityOauth2CreateAccepted{}
}

/*
SecurityOauth2CreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SecurityOauth2CreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecurityOauth2JobLinkResponse
}

// IsSuccess returns true when this security oauth2 create accepted response has a 2xx status code
func (o *SecurityOauth2CreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oauth2 create accepted response has a 3xx status code
func (o *SecurityOauth2CreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oauth2 create accepted response has a 4xx status code
func (o *SecurityOauth2CreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oauth2 create accepted response has a 5xx status code
func (o *SecurityOauth2CreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this security oauth2 create accepted response a status code equal to that given
func (o *SecurityOauth2CreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the security oauth2 create accepted response
func (o *SecurityOauth2CreateAccepted) Code() int {
	return 202
}

func (o *SecurityOauth2CreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oauth2/clients][%d] securityOauth2CreateAccepted %s", 202, payload)
}

func (o *SecurityOauth2CreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oauth2/clients][%d] securityOauth2CreateAccepted %s", 202, payload)
}

func (o *SecurityOauth2CreateAccepted) GetPayload() *models.SecurityOauth2JobLinkResponse {
	return o.Payload
}

func (o *SecurityOauth2CreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecurityOauth2JobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityOauth2CreateDefault creates a SecurityOauth2CreateDefault with default headers values
func NewSecurityOauth2CreateDefault(code int) *SecurityOauth2CreateDefault {
	return &SecurityOauth2CreateDefault{
		_statusCode: code,
	}
}

/*
	SecurityOauth2CreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203817010 | Client ID is required for remote introspection. |
| 203817011 | Client secret is required for remote introspection. |
| 203817012 | Client ID and client secret required for remote introspection. |
| 203817013 | JWKS URI should not be configured for remote introspection. |
| 203817014 | JWKS refresh interval should not be specified for remote introspection. |
| 203817015 | The token introspection endpoint is required for remote introspection. |
| 203817016 | JWKS refresh interval provided without providing JWKS URI. |
| 203817017 | Minimum supported value of JWKS refresh interval is 300 seconds. |
| 203817018 | Required parameters for either local validation or remote introspection are missing. Provide either the JWKS URI for local validation, or metadata configuration URI or token introspection endpoint with client ID and secret for remote introspection. |
| 203817019 | Failed to add new IDP client because number of maximum supported IDP clients is already reached. |
| 203817020 | Internal error. Failed to validate provider URI. |
| 203817021 | OAuth 2.0 Provider URI validation failed with error. |
| 203817022 | OAuth 2.0 Provider JWKS URI validation failed. Received empty response message from the JWKS URI. |
| 203817023 | OAuth 2.0 Provider JWKS URI validation failed. No keys were found in response message received from the JWKS URI. |
| 203817024 | Internal error. Unable to allocate memory for CURL response. |
| 203817025 | Maximum value of JWKS refresh interval is 2147483647 seconds. |
| 203817033 | OAuth 2.0 Provider Introspection endpoint validation failed. Received empty response message from the Introspection endpoint. |
| 203817034 | OAuth 2.0 Provider Introspection endpoint validation failed. Received invalid response message for Introspection request. |
| 203817037 | An entry cannot be created as another entry with the same configuration name has the same issuer and audience. |
| 203817042 | Maximum value of introspection interval is 2147483647 seconds. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityOauth2CreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security oauth2 create default response has a 2xx status code
func (o *SecurityOauth2CreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security oauth2 create default response has a 3xx status code
func (o *SecurityOauth2CreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security oauth2 create default response has a 4xx status code
func (o *SecurityOauth2CreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security oauth2 create default response has a 5xx status code
func (o *SecurityOauth2CreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security oauth2 create default response a status code equal to that given
func (o *SecurityOauth2CreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security oauth2 create default response
func (o *SecurityOauth2CreateDefault) Code() int {
	return o._statusCode
}

func (o *SecurityOauth2CreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oauth2/clients][%d] security_oauth2_create default %s", o._statusCode, payload)
}

func (o *SecurityOauth2CreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oauth2/clients][%d] security_oauth2_create default %s", o._statusCode, payload)
}

func (o *SecurityOauth2CreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityOauth2CreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
