// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityOauth2DeleteCollectionParams creates a new SecurityOauth2DeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityOauth2DeleteCollectionParams() *SecurityOauth2DeleteCollectionParams {
	return &SecurityOauth2DeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityOauth2DeleteCollectionParamsWithTimeout creates a new SecurityOauth2DeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityOauth2DeleteCollectionParamsWithTimeout(timeout time.Duration) *SecurityOauth2DeleteCollectionParams {
	return &SecurityOauth2DeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityOauth2DeleteCollectionParamsWithContext creates a new SecurityOauth2DeleteCollectionParams object
// with the ability to set a context for a request.
func NewSecurityOauth2DeleteCollectionParamsWithContext(ctx context.Context) *SecurityOauth2DeleteCollectionParams {
	return &SecurityOauth2DeleteCollectionParams{
		Context: ctx,
	}
}

// NewSecurityOauth2DeleteCollectionParamsWithHTTPClient creates a new SecurityOauth2DeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityOauth2DeleteCollectionParamsWithHTTPClient(client *http.Client) *SecurityOauth2DeleteCollectionParams {
	return &SecurityOauth2DeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityOauth2DeleteCollectionParams contains all the parameters to send to the API endpoint

	for the security oauth2 delete collection operation.

	Typically these are written to a http.Request.
*/
type SecurityOauth2DeleteCollectionParams struct {

	/* Application.

	   Filter by application
	*/
	Application *string

	/* Audience.

	   Filter by audience
	*/
	Audience *string

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* HashedClientSecret.

	   Filter by hashed_client_secret
	*/
	HashedClientSecret *string

	/* Info.

	   Info specification
	*/
	Info SecurityOauth2DeleteCollectionBody

	/* IntrospectionEndpointURI.

	   Filter by introspection.endpoint_uri
	*/
	IntrospectionEndpointURI *string

	/* IntrospectionInterval.

	   Filter by introspection.interval
	*/
	IntrospectionInterval *string

	/* Issuer.

	   Filter by issuer
	*/
	Issuer *string

	/* JwksProviderURI.

	   Filter by jwks.provider_uri
	*/
	JwksProviderURI *string

	/* JwksRefreshInterval.

	   Filter by jwks.refresh_interval
	*/
	JwksRefreshInterval *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OutgoingProxy.

	   Filter by outgoing_proxy
	*/
	OutgoingProxy *string

	/* Provider.

	   Filter by provider
	*/
	Provider *string

	/* RemoteUserClaim.

	   Filter by remote_user_claim
	*/
	RemoteUserClaim *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UseLocalRolesIfPresent.

	   Filter by use_local_roles_if_present
	*/
	UseLocalRolesIfPresent *bool

	/* UseMutualTLS.

	   Filter by use_mutual_tls
	*/
	UseMutualTLS *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security oauth2 delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOauth2DeleteCollectionParams) WithDefaults() *SecurityOauth2DeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security oauth2 delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOauth2DeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityOauth2DeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithTimeout(timeout time.Duration) *SecurityOauth2DeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithContext(ctx context.Context) *SecurityOauth2DeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithHTTPClient(client *http.Client) *SecurityOauth2DeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplication adds the application to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithApplication(application *string) *SecurityOauth2DeleteCollectionParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetApplication(application *string) {
	o.Application = application
}

// WithAudience adds the audience to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithAudience(audience *string) *SecurityOauth2DeleteCollectionParams {
	o.SetAudience(audience)
	return o
}

// SetAudience adds the audience to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetAudience(audience *string) {
	o.Audience = audience
}

// WithClientID adds the clientID to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithClientID(clientID *string) *SecurityOauth2DeleteCollectionParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithContinueOnFailure adds the continueOnFailure to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityOauth2DeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithHashedClientSecret adds the hashedClientSecret to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithHashedClientSecret(hashedClientSecret *string) *SecurityOauth2DeleteCollectionParams {
	o.SetHashedClientSecret(hashedClientSecret)
	return o
}

// SetHashedClientSecret adds the hashedClientSecret to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetHashedClientSecret(hashedClientSecret *string) {
	o.HashedClientSecret = hashedClientSecret
}

// WithInfo adds the info to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithInfo(info SecurityOauth2DeleteCollectionBody) *SecurityOauth2DeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetInfo(info SecurityOauth2DeleteCollectionBody) {
	o.Info = info
}

// WithIntrospectionEndpointURI adds the introspectionEndpointURI to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithIntrospectionEndpointURI(introspectionEndpointURI *string) *SecurityOauth2DeleteCollectionParams {
	o.SetIntrospectionEndpointURI(introspectionEndpointURI)
	return o
}

// SetIntrospectionEndpointURI adds the introspectionEndpointUri to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetIntrospectionEndpointURI(introspectionEndpointURI *string) {
	o.IntrospectionEndpointURI = introspectionEndpointURI
}

// WithIntrospectionInterval adds the introspectionInterval to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithIntrospectionInterval(introspectionInterval *string) *SecurityOauth2DeleteCollectionParams {
	o.SetIntrospectionInterval(introspectionInterval)
	return o
}

// SetIntrospectionInterval adds the introspectionInterval to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetIntrospectionInterval(introspectionInterval *string) {
	o.IntrospectionInterval = introspectionInterval
}

// WithIssuer adds the issuer to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithIssuer(issuer *string) *SecurityOauth2DeleteCollectionParams {
	o.SetIssuer(issuer)
	return o
}

// SetIssuer adds the issuer to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetIssuer(issuer *string) {
	o.Issuer = issuer
}

// WithJwksProviderURI adds the jwksProviderURI to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithJwksProviderURI(jwksProviderURI *string) *SecurityOauth2DeleteCollectionParams {
	o.SetJwksProviderURI(jwksProviderURI)
	return o
}

// SetJwksProviderURI adds the jwksProviderUri to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetJwksProviderURI(jwksProviderURI *string) {
	o.JwksProviderURI = jwksProviderURI
}

// WithJwksRefreshInterval adds the jwksRefreshInterval to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithJwksRefreshInterval(jwksRefreshInterval *string) *SecurityOauth2DeleteCollectionParams {
	o.SetJwksRefreshInterval(jwksRefreshInterval)
	return o
}

// SetJwksRefreshInterval adds the jwksRefreshInterval to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetJwksRefreshInterval(jwksRefreshInterval *string) {
	o.JwksRefreshInterval = jwksRefreshInterval
}

// WithName adds the name to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithName(name *string) *SecurityOauth2DeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOutgoingProxy adds the outgoingProxy to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithOutgoingProxy(outgoingProxy *string) *SecurityOauth2DeleteCollectionParams {
	o.SetOutgoingProxy(outgoingProxy)
	return o
}

// SetOutgoingProxy adds the outgoingProxy to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetOutgoingProxy(outgoingProxy *string) {
	o.OutgoingProxy = outgoingProxy
}

// WithProvider adds the provider to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithProvider(provider *string) *SecurityOauth2DeleteCollectionParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetProvider(provider *string) {
	o.Provider = provider
}

// WithRemoteUserClaim adds the remoteUserClaim to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithRemoteUserClaim(remoteUserClaim *string) *SecurityOauth2DeleteCollectionParams {
	o.SetRemoteUserClaim(remoteUserClaim)
	return o
}

// SetRemoteUserClaim adds the remoteUserClaim to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetRemoteUserClaim(remoteUserClaim *string) {
	o.RemoteUserClaim = remoteUserClaim
}

// WithReturnRecords adds the returnRecords to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityOauth2DeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityOauth2DeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityOauth2DeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUseLocalRolesIfPresent adds the useLocalRolesIfPresent to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithUseLocalRolesIfPresent(useLocalRolesIfPresent *bool) *SecurityOauth2DeleteCollectionParams {
	o.SetUseLocalRolesIfPresent(useLocalRolesIfPresent)
	return o
}

// SetUseLocalRolesIfPresent adds the useLocalRolesIfPresent to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetUseLocalRolesIfPresent(useLocalRolesIfPresent *bool) {
	o.UseLocalRolesIfPresent = useLocalRolesIfPresent
}

// WithUseMutualTLS adds the useMutualTLS to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) WithUseMutualTLS(useMutualTLS *string) *SecurityOauth2DeleteCollectionParams {
	o.SetUseMutualTLS(useMutualTLS)
	return o
}

// SetUseMutualTLS adds the useMutualTls to the security oauth2 delete collection params
func (o *SecurityOauth2DeleteCollectionParams) SetUseMutualTLS(useMutualTLS *string) {
	o.UseMutualTLS = useMutualTLS
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityOauth2DeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Application != nil {

		// query param application
		var qrApplication string

		if o.Application != nil {
			qrApplication = *o.Application
		}
		qApplication := qrApplication
		if qApplication != "" {

			if err := r.SetQueryParam("application", qApplication); err != nil {
				return err
			}
		}
	}

	if o.Audience != nil {

		// query param audience
		var qrAudience string

		if o.Audience != nil {
			qrAudience = *o.Audience
		}
		qAudience := qrAudience
		if qAudience != "" {

			if err := r.SetQueryParam("audience", qAudience); err != nil {
				return err
			}
		}
	}

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.HashedClientSecret != nil {

		// query param hashed_client_secret
		var qrHashedClientSecret string

		if o.HashedClientSecret != nil {
			qrHashedClientSecret = *o.HashedClientSecret
		}
		qHashedClientSecret := qrHashedClientSecret
		if qHashedClientSecret != "" {

			if err := r.SetQueryParam("hashed_client_secret", qHashedClientSecret); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IntrospectionEndpointURI != nil {

		// query param introspection.endpoint_uri
		var qrIntrospectionEndpointURI string

		if o.IntrospectionEndpointURI != nil {
			qrIntrospectionEndpointURI = *o.IntrospectionEndpointURI
		}
		qIntrospectionEndpointURI := qrIntrospectionEndpointURI
		if qIntrospectionEndpointURI != "" {

			if err := r.SetQueryParam("introspection.endpoint_uri", qIntrospectionEndpointURI); err != nil {
				return err
			}
		}
	}

	if o.IntrospectionInterval != nil {

		// query param introspection.interval
		var qrIntrospectionInterval string

		if o.IntrospectionInterval != nil {
			qrIntrospectionInterval = *o.IntrospectionInterval
		}
		qIntrospectionInterval := qrIntrospectionInterval
		if qIntrospectionInterval != "" {

			if err := r.SetQueryParam("introspection.interval", qIntrospectionInterval); err != nil {
				return err
			}
		}
	}

	if o.Issuer != nil {

		// query param issuer
		var qrIssuer string

		if o.Issuer != nil {
			qrIssuer = *o.Issuer
		}
		qIssuer := qrIssuer
		if qIssuer != "" {

			if err := r.SetQueryParam("issuer", qIssuer); err != nil {
				return err
			}
		}
	}

	if o.JwksProviderURI != nil {

		// query param jwks.provider_uri
		var qrJwksProviderURI string

		if o.JwksProviderURI != nil {
			qrJwksProviderURI = *o.JwksProviderURI
		}
		qJwksProviderURI := qrJwksProviderURI
		if qJwksProviderURI != "" {

			if err := r.SetQueryParam("jwks.provider_uri", qJwksProviderURI); err != nil {
				return err
			}
		}
	}

	if o.JwksRefreshInterval != nil {

		// query param jwks.refresh_interval
		var qrJwksRefreshInterval string

		if o.JwksRefreshInterval != nil {
			qrJwksRefreshInterval = *o.JwksRefreshInterval
		}
		qJwksRefreshInterval := qrJwksRefreshInterval
		if qJwksRefreshInterval != "" {

			if err := r.SetQueryParam("jwks.refresh_interval", qJwksRefreshInterval); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OutgoingProxy != nil {

		// query param outgoing_proxy
		var qrOutgoingProxy string

		if o.OutgoingProxy != nil {
			qrOutgoingProxy = *o.OutgoingProxy
		}
		qOutgoingProxy := qrOutgoingProxy
		if qOutgoingProxy != "" {

			if err := r.SetQueryParam("outgoing_proxy", qOutgoingProxy); err != nil {
				return err
			}
		}
	}

	if o.Provider != nil {

		// query param provider
		var qrProvider string

		if o.Provider != nil {
			qrProvider = *o.Provider
		}
		qProvider := qrProvider
		if qProvider != "" {

			if err := r.SetQueryParam("provider", qProvider); err != nil {
				return err
			}
		}
	}

	if o.RemoteUserClaim != nil {

		// query param remote_user_claim
		var qrRemoteUserClaim string

		if o.RemoteUserClaim != nil {
			qrRemoteUserClaim = *o.RemoteUserClaim
		}
		qRemoteUserClaim := qrRemoteUserClaim
		if qRemoteUserClaim != "" {

			if err := r.SetQueryParam("remote_user_claim", qRemoteUserClaim); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UseLocalRolesIfPresent != nil {

		// query param use_local_roles_if_present
		var qrUseLocalRolesIfPresent bool

		if o.UseLocalRolesIfPresent != nil {
			qrUseLocalRolesIfPresent = *o.UseLocalRolesIfPresent
		}
		qUseLocalRolesIfPresent := swag.FormatBool(qrUseLocalRolesIfPresent)
		if qUseLocalRolesIfPresent != "" {

			if err := r.SetQueryParam("use_local_roles_if_present", qUseLocalRolesIfPresent); err != nil {
				return err
			}
		}
	}

	if o.UseMutualTLS != nil {

		// query param use_mutual_tls
		var qrUseMutualTLS string

		if o.UseMutualTLS != nil {
			qrUseMutualTLS = *o.UseMutualTLS
		}
		qUseMutualTLS := qrUseMutualTLS
		if qUseMutualTLS != "" {

			if err := r.SetQueryParam("use_mutual_tls", qUseMutualTLS); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
