// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityOauth2DeleteCollectionReader is a Reader for the SecurityOauth2DeleteCollection structure.
type SecurityOauth2DeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityOauth2DeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityOauth2DeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityOauth2DeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityOauth2DeleteCollectionOK creates a SecurityOauth2DeleteCollectionOK with default headers values
func NewSecurityOauth2DeleteCollectionOK() *SecurityOauth2DeleteCollectionOK {
	return &SecurityOauth2DeleteCollectionOK{}
}

/*
SecurityOauth2DeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityOauth2DeleteCollectionOK struct {
}

// IsSuccess returns true when this security oauth2 delete collection o k response has a 2xx status code
func (o *SecurityOauth2DeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oauth2 delete collection o k response has a 3xx status code
func (o *SecurityOauth2DeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oauth2 delete collection o k response has a 4xx status code
func (o *SecurityOauth2DeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oauth2 delete collection o k response has a 5xx status code
func (o *SecurityOauth2DeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security oauth2 delete collection o k response a status code equal to that given
func (o *SecurityOauth2DeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security oauth2 delete collection o k response
func (o *SecurityOauth2DeleteCollectionOK) Code() int {
	return 200
}

func (o *SecurityOauth2DeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients][%d] securityOauth2DeleteCollectionOK", 200)
}

func (o *SecurityOauth2DeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients][%d] securityOauth2DeleteCollectionOK", 200)
}

func (o *SecurityOauth2DeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityOauth2DeleteCollectionDefault creates a SecurityOauth2DeleteCollectionDefault with default headers values
func NewSecurityOauth2DeleteCollectionDefault(code int) *SecurityOauth2DeleteCollectionDefault {
	return &SecurityOauth2DeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityOauth2DeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203816995 | OAuth 2.0 must be disabled before the configuration can be removed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityOauth2DeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security oauth2 delete collection default response has a 2xx status code
func (o *SecurityOauth2DeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security oauth2 delete collection default response has a 3xx status code
func (o *SecurityOauth2DeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security oauth2 delete collection default response has a 4xx status code
func (o *SecurityOauth2DeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security oauth2 delete collection default response has a 5xx status code
func (o *SecurityOauth2DeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security oauth2 delete collection default response a status code equal to that given
func (o *SecurityOauth2DeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security oauth2 delete collection default response
func (o *SecurityOauth2DeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityOauth2DeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients][%d] security_oauth2_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityOauth2DeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients][%d] security_oauth2_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityOauth2DeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityOauth2DeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityOauth2DeleteCollectionBody security oauth2 delete collection body
swagger:model SecurityOauth2DeleteCollectionBody
*/
type SecurityOauth2DeleteCollectionBody struct {

	// security oauth2 response inline records
	SecurityOauth2ResponseInlineRecords []*models.SecurityOauth2 `json:"records,omitempty"`
}

// Validate validates this security oauth2 delete collection body
func (o *SecurityOauth2DeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSecurityOauth2ResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityOauth2DeleteCollectionBody) validateSecurityOauth2ResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityOauth2ResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityOauth2ResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityOauth2ResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityOauth2ResponseInlineRecords[i] != nil {
			if err := o.SecurityOauth2ResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security oauth2 delete collection body based on the context it is used
func (o *SecurityOauth2DeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSecurityOauth2ResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityOauth2DeleteCollectionBody) contextValidateSecurityOauth2ResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityOauth2ResponseInlineRecords); i++ {

		if o.SecurityOauth2ResponseInlineRecords[i] != nil {
			if err := o.SecurityOauth2ResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityOauth2DeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityOauth2DeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityOauth2DeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
