// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewSecurityOauth2DeleteParams creates a new SecurityOauth2DeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityOauth2DeleteParams() *SecurityOauth2DeleteParams {
	return &SecurityOauth2DeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityOauth2DeleteParamsWithTimeout creates a new SecurityOauth2DeleteParams object
// with the ability to set a timeout on a request.
func NewSecurityOauth2DeleteParamsWithTimeout(timeout time.Duration) *SecurityOauth2DeleteParams {
	return &SecurityOauth2DeleteParams{
		timeout: timeout,
	}
}

// NewSecurityOauth2DeleteParamsWithContext creates a new SecurityOauth2DeleteParams object
// with the ability to set a context for a request.
func NewSecurityOauth2DeleteParamsWithContext(ctx context.Context) *SecurityOauth2DeleteParams {
	return &SecurityOauth2DeleteParams{
		Context: ctx,
	}
}

// NewSecurityOauth2DeleteParamsWithHTTPClient creates a new SecurityOauth2DeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityOauth2DeleteParamsWithHTTPClient(client *http.Client) *SecurityOauth2DeleteParams {
	return &SecurityOauth2DeleteParams{
		HTTPClient: client,
	}
}

/*
SecurityOauth2DeleteParams contains all the parameters to send to the API endpoint

	for the security oauth2 delete operation.

	Typically these are written to a http.Request.
*/
type SecurityOauth2DeleteParams struct {

	/* Name.

	   OAuth 2.0 configuration name.
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security oauth2 delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOauth2DeleteParams) WithDefaults() *SecurityOauth2DeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security oauth2 delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOauth2DeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) WithTimeout(timeout time.Duration) *SecurityOauth2DeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) WithContext(ctx context.Context) *SecurityOauth2DeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) WithHTTPClient(client *http.Client) *SecurityOauth2DeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) WithName(name string) *SecurityOauth2DeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the security oauth2 delete params
func (o *SecurityOauth2DeleteParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityOauth2DeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
