// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityOauth2DeleteReader is a Reader for the SecurityOauth2Delete structure.
type SecurityOauth2DeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityOauth2DeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityOauth2DeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityOauth2DeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityOauth2DeleteOK creates a SecurityOauth2DeleteOK with default headers values
func NewSecurityOauth2DeleteOK() *SecurityOauth2DeleteOK {
	return &SecurityOauth2DeleteOK{}
}

/*
SecurityOauth2DeleteOK describes a response with status code 200, with default header values.

OK
*/
type SecurityOauth2DeleteOK struct {
}

// IsSuccess returns true when this security oauth2 delete o k response has a 2xx status code
func (o *SecurityOauth2DeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oauth2 delete o k response has a 3xx status code
func (o *SecurityOauth2DeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oauth2 delete o k response has a 4xx status code
func (o *SecurityOauth2DeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oauth2 delete o k response has a 5xx status code
func (o *SecurityOauth2DeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security oauth2 delete o k response a status code equal to that given
func (o *SecurityOauth2DeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security oauth2 delete o k response
func (o *SecurityOauth2DeleteOK) Code() int {
	return 200
}

func (o *SecurityOauth2DeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients/{name}][%d] securityOauth2DeleteOK", 200)
}

func (o *SecurityOauth2DeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients/{name}][%d] securityOauth2DeleteOK", 200)
}

func (o *SecurityOauth2DeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityOauth2DeleteDefault creates a SecurityOauth2DeleteDefault with default headers values
func NewSecurityOauth2DeleteDefault(code int) *SecurityOauth2DeleteDefault {
	return &SecurityOauth2DeleteDefault{
		_statusCode: code,
	}
}

/*
	SecurityOauth2DeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203816995 | OAuth 2.0 must be disabled before the configuration can be removed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityOauth2DeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security oauth2 delete default response has a 2xx status code
func (o *SecurityOauth2DeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security oauth2 delete default response has a 3xx status code
func (o *SecurityOauth2DeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security oauth2 delete default response has a 4xx status code
func (o *SecurityOauth2DeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security oauth2 delete default response has a 5xx status code
func (o *SecurityOauth2DeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security oauth2 delete default response a status code equal to that given
func (o *SecurityOauth2DeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security oauth2 delete default response
func (o *SecurityOauth2DeleteDefault) Code() int {
	return o._statusCode
}

func (o *SecurityOauth2DeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients/{name}][%d] security_oauth2_delete default %s", o._statusCode, payload)
}

func (o *SecurityOauth2DeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/oauth2/clients/{name}][%d] security_oauth2_delete default %s", o._statusCode, payload)
}

func (o *SecurityOauth2DeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityOauth2DeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
