// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityOauth2GlobalGetParams creates a new SecurityOauth2GlobalGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityOauth2GlobalGetParams() *SecurityOauth2GlobalGetParams {
	return &SecurityOauth2GlobalGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityOauth2GlobalGetParamsWithTimeout creates a new SecurityOauth2GlobalGetParams object
// with the ability to set a timeout on a request.
func NewSecurityOauth2GlobalGetParamsWithTimeout(timeout time.Duration) *SecurityOauth2GlobalGetParams {
	return &SecurityOauth2GlobalGetParams{
		timeout: timeout,
	}
}

// NewSecurityOauth2GlobalGetParamsWithContext creates a new SecurityOauth2GlobalGetParams object
// with the ability to set a context for a request.
func NewSecurityOauth2GlobalGetParamsWithContext(ctx context.Context) *SecurityOauth2GlobalGetParams {
	return &SecurityOauth2GlobalGetParams{
		Context: ctx,
	}
}

// NewSecurityOauth2GlobalGetParamsWithHTTPClient creates a new SecurityOauth2GlobalGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityOauth2GlobalGetParamsWithHTTPClient(client *http.Client) *SecurityOauth2GlobalGetParams {
	return &SecurityOauth2GlobalGetParams{
		HTTPClient: client,
	}
}

/*
SecurityOauth2GlobalGetParams contains all the parameters to send to the API endpoint

	for the security oauth2 global get operation.

	Typically these are written to a http.Request.
*/
type SecurityOauth2GlobalGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security oauth2 global get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOauth2GlobalGetParams) WithDefaults() *SecurityOauth2GlobalGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security oauth2 global get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOauth2GlobalGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) WithTimeout(timeout time.Duration) *SecurityOauth2GlobalGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) WithContext(ctx context.Context) *SecurityOauth2GlobalGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) WithHTTPClient(client *http.Client) *SecurityOauth2GlobalGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) WithEnabled(enabled *bool) *SecurityOauth2GlobalGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) WithFields(fields []string) *SecurityOauth2GlobalGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security oauth2 global get params
func (o *SecurityOauth2GlobalGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityOauth2GlobalGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityOauth2GlobalGet binds the parameter fields
func (o *SecurityOauth2GlobalGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
