// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityOidcCreateReader is a Reader for the SecurityOidcCreate structure.
type SecurityOidcCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityOidcCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecurityOidcCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSecurityOidcCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityOidcCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityOidcCreateCreated creates a SecurityOidcCreateCreated with default headers values
func NewSecurityOidcCreateCreated() *SecurityOidcCreateCreated {
	return &SecurityOidcCreateCreated{}
}

/*
SecurityOidcCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SecurityOidcCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecurityOidcJobLinkResponse
}

// IsSuccess returns true when this security oidc create created response has a 2xx status code
func (o *SecurityOidcCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oidc create created response has a 3xx status code
func (o *SecurityOidcCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oidc create created response has a 4xx status code
func (o *SecurityOidcCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oidc create created response has a 5xx status code
func (o *SecurityOidcCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this security oidc create created response a status code equal to that given
func (o *SecurityOidcCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the security oidc create created response
func (o *SecurityOidcCreateCreated) Code() int {
	return 201
}

func (o *SecurityOidcCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oidc][%d] securityOidcCreateCreated %s", 201, payload)
}

func (o *SecurityOidcCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oidc][%d] securityOidcCreateCreated %s", 201, payload)
}

func (o *SecurityOidcCreateCreated) GetPayload() *models.SecurityOidcJobLinkResponse {
	return o.Payload
}

func (o *SecurityOidcCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecurityOidcJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityOidcCreateAccepted creates a SecurityOidcCreateAccepted with default headers values
func NewSecurityOidcCreateAccepted() *SecurityOidcCreateAccepted {
	return &SecurityOidcCreateAccepted{}
}

/*
SecurityOidcCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SecurityOidcCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecurityOidcJobLinkResponse
}

// IsSuccess returns true when this security oidc create accepted response has a 2xx status code
func (o *SecurityOidcCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oidc create accepted response has a 3xx status code
func (o *SecurityOidcCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oidc create accepted response has a 4xx status code
func (o *SecurityOidcCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oidc create accepted response has a 5xx status code
func (o *SecurityOidcCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this security oidc create accepted response a status code equal to that given
func (o *SecurityOidcCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the security oidc create accepted response
func (o *SecurityOidcCreateAccepted) Code() int {
	return 202
}

func (o *SecurityOidcCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oidc][%d] securityOidcCreateAccepted %s", 202, payload)
}

func (o *SecurityOidcCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oidc][%d] securityOidcCreateAccepted %s", 202, payload)
}

func (o *SecurityOidcCreateAccepted) GetPayload() *models.SecurityOidcJobLinkResponse {
	return o.Payload
}

func (o *SecurityOidcCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecurityOidcJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityOidcCreateDefault creates a SecurityOidcCreateDefault with default headers values
func NewSecurityOidcCreateDefault(code int) *SecurityOidcCreateDefault {
	return &SecurityOidcCreateDefault{
		_statusCode: code,
	}
}

/*
	SecurityOidcCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 301465601 | Provided client secret is invalid. |
| 301465603 | The value specified for client secret is too long. The text must be between 1 and 256 characters. |
| 301465606 | Failed to hash the client secret. |
| 301465613 | OIDC provider JWKS URI validation failed. Unable to reach the JWKS URI. |
| 301465614 | OIDC provider JWKS URI validation failed. Received incorrect response from the JWKS URI. |
| 301465617 | Invalid IP address specified for the "redirect_ipaddress". The IP address must be associated with a cluster management or node management LIF. |
| 301465619 | Cannot delete the OIDC configuration because OIDC authentication is enabled. |
| 301465620 | OAuth 2.0 configuration already exists for this OIDC configuration. |
| 301465621 | An error occurred while while creating OAuth 2.0 configuration for this OIDC configuration. |
| 301465623 | Cannot configure OIDC because SAML default metadata is configured. |
| 301465624 | Cannot configure OIDC because SAML is configured. |
| 301465625 | Specified value for the JWKS refresh interval is invalid. The value must be between 300 seconds to 2147483647 seconds. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityOidcCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security oidc create default response has a 2xx status code
func (o *SecurityOidcCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security oidc create default response has a 3xx status code
func (o *SecurityOidcCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security oidc create default response has a 4xx status code
func (o *SecurityOidcCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security oidc create default response has a 5xx status code
func (o *SecurityOidcCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security oidc create default response a status code equal to that given
func (o *SecurityOidcCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security oidc create default response
func (o *SecurityOidcCreateDefault) Code() int {
	return o._statusCode
}

func (o *SecurityOidcCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oidc][%d] security_oidc_create default %s", o._statusCode, payload)
}

func (o *SecurityOidcCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/oidc][%d] security_oidc_create default %s", o._statusCode, payload)
}

func (o *SecurityOidcCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityOidcCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
