// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityOidcGetParams creates a new SecurityOidcGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityOidcGetParams() *SecurityOidcGetParams {
	return &SecurityOidcGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityOidcGetParamsWithTimeout creates a new SecurityOidcGetParams object
// with the ability to set a timeout on a request.
func NewSecurityOidcGetParamsWithTimeout(timeout time.Duration) *SecurityOidcGetParams {
	return &SecurityOidcGetParams{
		timeout: timeout,
	}
}

// NewSecurityOidcGetParamsWithContext creates a new SecurityOidcGetParams object
// with the ability to set a context for a request.
func NewSecurityOidcGetParamsWithContext(ctx context.Context) *SecurityOidcGetParams {
	return &SecurityOidcGetParams{
		Context: ctx,
	}
}

// NewSecurityOidcGetParamsWithHTTPClient creates a new SecurityOidcGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityOidcGetParamsWithHTTPClient(client *http.Client) *SecurityOidcGetParams {
	return &SecurityOidcGetParams{
		HTTPClient: client,
	}
}

/*
SecurityOidcGetParams contains all the parameters to send to the API endpoint

	for the security oidc get operation.

	Typically these are written to a http.Request.
*/
type SecurityOidcGetParams struct {

	/* AccessTokenIssuer.

	   Filter by access_token_issuer
	*/
	AccessTokenIssuer *string

	/* AuthorizationEndpoint.

	   Filter by authorization_endpoint
	*/
	AuthorizationEndpoint *string

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* ClientSecret.

	   Filter by client_secret
	*/
	ClientSecret *string

	/* ClientSecretHash.

	   Filter by client_secret_hash
	*/
	ClientSecretHash *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* EndSessionEndpoint.

	   Filter by end_session_endpoint
	*/
	EndSessionEndpoint *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Issuer.

	   Filter by issuer
	*/
	Issuer *string

	/* JwksRefreshInterval.

	   Filter by jwks_refresh_interval
	*/
	JwksRefreshInterval *string

	/* OutgoingProxy.

	   Filter by outgoing_proxy
	*/
	OutgoingProxy *string

	/* Provider.

	   Filter by provider
	*/
	Provider *string

	/* ProviderJwksURI.

	   Filter by provider_jwks_uri
	*/
	ProviderJwksURI *string

	/* RedirectIpaddress.

	   Filter by redirect_ipaddress
	*/
	RedirectIpaddress *string

	/* RemoteUserClaim.

	   Filter by remote_user_claim
	*/
	RemoteUserClaim *string

	/* SkipURIValidation.

	   Filter by skip_uri_validation
	*/
	SkipURIValidation *bool

	/* TokenEndpoint.

	   Filter by token_endpoint
	*/
	TokenEndpoint *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security oidc get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOidcGetParams) WithDefaults() *SecurityOidcGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security oidc get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityOidcGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security oidc get params
func (o *SecurityOidcGetParams) WithTimeout(timeout time.Duration) *SecurityOidcGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security oidc get params
func (o *SecurityOidcGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security oidc get params
func (o *SecurityOidcGetParams) WithContext(ctx context.Context) *SecurityOidcGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security oidc get params
func (o *SecurityOidcGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security oidc get params
func (o *SecurityOidcGetParams) WithHTTPClient(client *http.Client) *SecurityOidcGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security oidc get params
func (o *SecurityOidcGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessTokenIssuer adds the accessTokenIssuer to the security oidc get params
func (o *SecurityOidcGetParams) WithAccessTokenIssuer(accessTokenIssuer *string) *SecurityOidcGetParams {
	o.SetAccessTokenIssuer(accessTokenIssuer)
	return o
}

// SetAccessTokenIssuer adds the accessTokenIssuer to the security oidc get params
func (o *SecurityOidcGetParams) SetAccessTokenIssuer(accessTokenIssuer *string) {
	o.AccessTokenIssuer = accessTokenIssuer
}

// WithAuthorizationEndpoint adds the authorizationEndpoint to the security oidc get params
func (o *SecurityOidcGetParams) WithAuthorizationEndpoint(authorizationEndpoint *string) *SecurityOidcGetParams {
	o.SetAuthorizationEndpoint(authorizationEndpoint)
	return o
}

// SetAuthorizationEndpoint adds the authorizationEndpoint to the security oidc get params
func (o *SecurityOidcGetParams) SetAuthorizationEndpoint(authorizationEndpoint *string) {
	o.AuthorizationEndpoint = authorizationEndpoint
}

// WithClientID adds the clientID to the security oidc get params
func (o *SecurityOidcGetParams) WithClientID(clientID *string) *SecurityOidcGetParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the security oidc get params
func (o *SecurityOidcGetParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithClientSecret adds the clientSecret to the security oidc get params
func (o *SecurityOidcGetParams) WithClientSecret(clientSecret *string) *SecurityOidcGetParams {
	o.SetClientSecret(clientSecret)
	return o
}

// SetClientSecret adds the clientSecret to the security oidc get params
func (o *SecurityOidcGetParams) SetClientSecret(clientSecret *string) {
	o.ClientSecret = clientSecret
}

// WithClientSecretHash adds the clientSecretHash to the security oidc get params
func (o *SecurityOidcGetParams) WithClientSecretHash(clientSecretHash *string) *SecurityOidcGetParams {
	o.SetClientSecretHash(clientSecretHash)
	return o
}

// SetClientSecretHash adds the clientSecretHash to the security oidc get params
func (o *SecurityOidcGetParams) SetClientSecretHash(clientSecretHash *string) {
	o.ClientSecretHash = clientSecretHash
}

// WithEnabled adds the enabled to the security oidc get params
func (o *SecurityOidcGetParams) WithEnabled(enabled *bool) *SecurityOidcGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security oidc get params
func (o *SecurityOidcGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithEndSessionEndpoint adds the endSessionEndpoint to the security oidc get params
func (o *SecurityOidcGetParams) WithEndSessionEndpoint(endSessionEndpoint *string) *SecurityOidcGetParams {
	o.SetEndSessionEndpoint(endSessionEndpoint)
	return o
}

// SetEndSessionEndpoint adds the endSessionEndpoint to the security oidc get params
func (o *SecurityOidcGetParams) SetEndSessionEndpoint(endSessionEndpoint *string) {
	o.EndSessionEndpoint = endSessionEndpoint
}

// WithFields adds the fields to the security oidc get params
func (o *SecurityOidcGetParams) WithFields(fields []string) *SecurityOidcGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security oidc get params
func (o *SecurityOidcGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIssuer adds the issuer to the security oidc get params
func (o *SecurityOidcGetParams) WithIssuer(issuer *string) *SecurityOidcGetParams {
	o.SetIssuer(issuer)
	return o
}

// SetIssuer adds the issuer to the security oidc get params
func (o *SecurityOidcGetParams) SetIssuer(issuer *string) {
	o.Issuer = issuer
}

// WithJwksRefreshInterval adds the jwksRefreshInterval to the security oidc get params
func (o *SecurityOidcGetParams) WithJwksRefreshInterval(jwksRefreshInterval *string) *SecurityOidcGetParams {
	o.SetJwksRefreshInterval(jwksRefreshInterval)
	return o
}

// SetJwksRefreshInterval adds the jwksRefreshInterval to the security oidc get params
func (o *SecurityOidcGetParams) SetJwksRefreshInterval(jwksRefreshInterval *string) {
	o.JwksRefreshInterval = jwksRefreshInterval
}

// WithOutgoingProxy adds the outgoingProxy to the security oidc get params
func (o *SecurityOidcGetParams) WithOutgoingProxy(outgoingProxy *string) *SecurityOidcGetParams {
	o.SetOutgoingProxy(outgoingProxy)
	return o
}

// SetOutgoingProxy adds the outgoingProxy to the security oidc get params
func (o *SecurityOidcGetParams) SetOutgoingProxy(outgoingProxy *string) {
	o.OutgoingProxy = outgoingProxy
}

// WithProvider adds the provider to the security oidc get params
func (o *SecurityOidcGetParams) WithProvider(provider *string) *SecurityOidcGetParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the security oidc get params
func (o *SecurityOidcGetParams) SetProvider(provider *string) {
	o.Provider = provider
}

// WithProviderJwksURI adds the providerJwksURI to the security oidc get params
func (o *SecurityOidcGetParams) WithProviderJwksURI(providerJwksURI *string) *SecurityOidcGetParams {
	o.SetProviderJwksURI(providerJwksURI)
	return o
}

// SetProviderJwksURI adds the providerJwksUri to the security oidc get params
func (o *SecurityOidcGetParams) SetProviderJwksURI(providerJwksURI *string) {
	o.ProviderJwksURI = providerJwksURI
}

// WithRedirectIpaddress adds the redirectIpaddress to the security oidc get params
func (o *SecurityOidcGetParams) WithRedirectIpaddress(redirectIpaddress *string) *SecurityOidcGetParams {
	o.SetRedirectIpaddress(redirectIpaddress)
	return o
}

// SetRedirectIpaddress adds the redirectIpaddress to the security oidc get params
func (o *SecurityOidcGetParams) SetRedirectIpaddress(redirectIpaddress *string) {
	o.RedirectIpaddress = redirectIpaddress
}

// WithRemoteUserClaim adds the remoteUserClaim to the security oidc get params
func (o *SecurityOidcGetParams) WithRemoteUserClaim(remoteUserClaim *string) *SecurityOidcGetParams {
	o.SetRemoteUserClaim(remoteUserClaim)
	return o
}

// SetRemoteUserClaim adds the remoteUserClaim to the security oidc get params
func (o *SecurityOidcGetParams) SetRemoteUserClaim(remoteUserClaim *string) {
	o.RemoteUserClaim = remoteUserClaim
}

// WithSkipURIValidation adds the skipURIValidation to the security oidc get params
func (o *SecurityOidcGetParams) WithSkipURIValidation(skipURIValidation *bool) *SecurityOidcGetParams {
	o.SetSkipURIValidation(skipURIValidation)
	return o
}

// SetSkipURIValidation adds the skipUriValidation to the security oidc get params
func (o *SecurityOidcGetParams) SetSkipURIValidation(skipURIValidation *bool) {
	o.SkipURIValidation = skipURIValidation
}

// WithTokenEndpoint adds the tokenEndpoint to the security oidc get params
func (o *SecurityOidcGetParams) WithTokenEndpoint(tokenEndpoint *string) *SecurityOidcGetParams {
	o.SetTokenEndpoint(tokenEndpoint)
	return o
}

// SetTokenEndpoint adds the tokenEndpoint to the security oidc get params
func (o *SecurityOidcGetParams) SetTokenEndpoint(tokenEndpoint *string) {
	o.TokenEndpoint = tokenEndpoint
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityOidcGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessTokenIssuer != nil {

		// query param access_token_issuer
		var qrAccessTokenIssuer string

		if o.AccessTokenIssuer != nil {
			qrAccessTokenIssuer = *o.AccessTokenIssuer
		}
		qAccessTokenIssuer := qrAccessTokenIssuer
		if qAccessTokenIssuer != "" {

			if err := r.SetQueryParam("access_token_issuer", qAccessTokenIssuer); err != nil {
				return err
			}
		}
	}

	if o.AuthorizationEndpoint != nil {

		// query param authorization_endpoint
		var qrAuthorizationEndpoint string

		if o.AuthorizationEndpoint != nil {
			qrAuthorizationEndpoint = *o.AuthorizationEndpoint
		}
		qAuthorizationEndpoint := qrAuthorizationEndpoint
		if qAuthorizationEndpoint != "" {

			if err := r.SetQueryParam("authorization_endpoint", qAuthorizationEndpoint); err != nil {
				return err
			}
		}
	}

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.ClientSecret != nil {

		// query param client_secret
		var qrClientSecret string

		if o.ClientSecret != nil {
			qrClientSecret = *o.ClientSecret
		}
		qClientSecret := qrClientSecret
		if qClientSecret != "" {

			if err := r.SetQueryParam("client_secret", qClientSecret); err != nil {
				return err
			}
		}
	}

	if o.ClientSecretHash != nil {

		// query param client_secret_hash
		var qrClientSecretHash string

		if o.ClientSecretHash != nil {
			qrClientSecretHash = *o.ClientSecretHash
		}
		qClientSecretHash := qrClientSecretHash
		if qClientSecretHash != "" {

			if err := r.SetQueryParam("client_secret_hash", qClientSecretHash); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.EndSessionEndpoint != nil {

		// query param end_session_endpoint
		var qrEndSessionEndpoint string

		if o.EndSessionEndpoint != nil {
			qrEndSessionEndpoint = *o.EndSessionEndpoint
		}
		qEndSessionEndpoint := qrEndSessionEndpoint
		if qEndSessionEndpoint != "" {

			if err := r.SetQueryParam("end_session_endpoint", qEndSessionEndpoint); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Issuer != nil {

		// query param issuer
		var qrIssuer string

		if o.Issuer != nil {
			qrIssuer = *o.Issuer
		}
		qIssuer := qrIssuer
		if qIssuer != "" {

			if err := r.SetQueryParam("issuer", qIssuer); err != nil {
				return err
			}
		}
	}

	if o.JwksRefreshInterval != nil {

		// query param jwks_refresh_interval
		var qrJwksRefreshInterval string

		if o.JwksRefreshInterval != nil {
			qrJwksRefreshInterval = *o.JwksRefreshInterval
		}
		qJwksRefreshInterval := qrJwksRefreshInterval
		if qJwksRefreshInterval != "" {

			if err := r.SetQueryParam("jwks_refresh_interval", qJwksRefreshInterval); err != nil {
				return err
			}
		}
	}

	if o.OutgoingProxy != nil {

		// query param outgoing_proxy
		var qrOutgoingProxy string

		if o.OutgoingProxy != nil {
			qrOutgoingProxy = *o.OutgoingProxy
		}
		qOutgoingProxy := qrOutgoingProxy
		if qOutgoingProxy != "" {

			if err := r.SetQueryParam("outgoing_proxy", qOutgoingProxy); err != nil {
				return err
			}
		}
	}

	if o.Provider != nil {

		// query param provider
		var qrProvider string

		if o.Provider != nil {
			qrProvider = *o.Provider
		}
		qProvider := qrProvider
		if qProvider != "" {

			if err := r.SetQueryParam("provider", qProvider); err != nil {
				return err
			}
		}
	}

	if o.ProviderJwksURI != nil {

		// query param provider_jwks_uri
		var qrProviderJwksURI string

		if o.ProviderJwksURI != nil {
			qrProviderJwksURI = *o.ProviderJwksURI
		}
		qProviderJwksURI := qrProviderJwksURI
		if qProviderJwksURI != "" {

			if err := r.SetQueryParam("provider_jwks_uri", qProviderJwksURI); err != nil {
				return err
			}
		}
	}

	if o.RedirectIpaddress != nil {

		// query param redirect_ipaddress
		var qrRedirectIpaddress string

		if o.RedirectIpaddress != nil {
			qrRedirectIpaddress = *o.RedirectIpaddress
		}
		qRedirectIpaddress := qrRedirectIpaddress
		if qRedirectIpaddress != "" {

			if err := r.SetQueryParam("redirect_ipaddress", qRedirectIpaddress); err != nil {
				return err
			}
		}
	}

	if o.RemoteUserClaim != nil {

		// query param remote_user_claim
		var qrRemoteUserClaim string

		if o.RemoteUserClaim != nil {
			qrRemoteUserClaim = *o.RemoteUserClaim
		}
		qRemoteUserClaim := qrRemoteUserClaim
		if qRemoteUserClaim != "" {

			if err := r.SetQueryParam("remote_user_claim", qRemoteUserClaim); err != nil {
				return err
			}
		}
	}

	if o.SkipURIValidation != nil {

		// query param skip_uri_validation
		var qrSkipURIValidation bool

		if o.SkipURIValidation != nil {
			qrSkipURIValidation = *o.SkipURIValidation
		}
		qSkipURIValidation := swag.FormatBool(qrSkipURIValidation)
		if qSkipURIValidation != "" {

			if err := r.SetQueryParam("skip_uri_validation", qSkipURIValidation); err != nil {
				return err
			}
		}
	}

	if o.TokenEndpoint != nil {

		// query param token_endpoint
		var qrTokenEndpoint string

		if o.TokenEndpoint != nil {
			qrTokenEndpoint = *o.TokenEndpoint
		}
		qTokenEndpoint := qrTokenEndpoint
		if qTokenEndpoint != "" {

			if err := r.SetQueryParam("token_endpoint", qTokenEndpoint); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityOidcGet binds the parameter fields
func (o *SecurityOidcGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
