// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityOidcModifyReader is a Reader for the SecurityOidcModify structure.
type SecurityOidcModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityOidcModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityOidcModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityOidcModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityOidcModifyOK creates a SecurityOidcModifyOK with default headers values
func NewSecurityOidcModifyOK() *SecurityOidcModifyOK {
	return &SecurityOidcModifyOK{}
}

/*
SecurityOidcModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecurityOidcModifyOK struct {
	Payload *models.JobLinkResponse
}

// IsSuccess returns true when this security oidc modify o k response has a 2xx status code
func (o *SecurityOidcModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security oidc modify o k response has a 3xx status code
func (o *SecurityOidcModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security oidc modify o k response has a 4xx status code
func (o *SecurityOidcModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security oidc modify o k response has a 5xx status code
func (o *SecurityOidcModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security oidc modify o k response a status code equal to that given
func (o *SecurityOidcModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security oidc modify o k response
func (o *SecurityOidcModifyOK) Code() int {
	return 200
}

func (o *SecurityOidcModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/oidc][%d] securityOidcModifyOK %s", 200, payload)
}

func (o *SecurityOidcModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/oidc][%d] securityOidcModifyOK %s", 200, payload)
}

func (o *SecurityOidcModifyOK) GetPayload() *models.JobLinkResponse {
	return o.Payload
}

func (o *SecurityOidcModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.JobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityOidcModifyDefault creates a SecurityOidcModifyDefault with default headers values
func NewSecurityOidcModifyDefault(code int) *SecurityOidcModifyDefault {
	return &SecurityOidcModifyDefault{
		_statusCode: code,
	}
}

/*
	SecurityOidcModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 301465616 | Failed to enable OIDC feature, web server setup is in progress. Retry after some time. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityOidcModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security oidc modify default response has a 2xx status code
func (o *SecurityOidcModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security oidc modify default response has a 3xx status code
func (o *SecurityOidcModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security oidc modify default response has a 4xx status code
func (o *SecurityOidcModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security oidc modify default response has a 5xx status code
func (o *SecurityOidcModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security oidc modify default response a status code equal to that given
func (o *SecurityOidcModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security oidc modify default response
func (o *SecurityOidcModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecurityOidcModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/oidc][%d] security_oidc_modify default %s", o._statusCode, payload)
}

func (o *SecurityOidcModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/oidc][%d] security_oidc_modify default %s", o._statusCode, payload)
}

func (o *SecurityOidcModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityOidcModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
