// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecuritySamlDefMetadataCreateParams creates a new SecuritySamlDefMetadataCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecuritySamlDefMetadataCreateParams() *SecuritySamlDefMetadataCreateParams {
	return &SecuritySamlDefMetadataCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecuritySamlDefMetadataCreateParamsWithTimeout creates a new SecuritySamlDefMetadataCreateParams object
// with the ability to set a timeout on a request.
func NewSecuritySamlDefMetadataCreateParamsWithTimeout(timeout time.Duration) *SecuritySamlDefMetadataCreateParams {
	return &SecuritySamlDefMetadataCreateParams{
		timeout: timeout,
	}
}

// NewSecuritySamlDefMetadataCreateParamsWithContext creates a new SecuritySamlDefMetadataCreateParams object
// with the ability to set a context for a request.
func NewSecuritySamlDefMetadataCreateParamsWithContext(ctx context.Context) *SecuritySamlDefMetadataCreateParams {
	return &SecuritySamlDefMetadataCreateParams{
		Context: ctx,
	}
}

// NewSecuritySamlDefMetadataCreateParamsWithHTTPClient creates a new SecuritySamlDefMetadataCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecuritySamlDefMetadataCreateParamsWithHTTPClient(client *http.Client) *SecuritySamlDefMetadataCreateParams {
	return &SecuritySamlDefMetadataCreateParams{
		HTTPClient: client,
	}
}

/*
SecuritySamlDefMetadataCreateParams contains all the parameters to send to the API endpoint

	for the security saml def metadata create operation.

	Typically these are written to a http.Request.
*/
type SecuritySamlDefMetadataCreateParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.SecuritySamlDefMetadata

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security saml def metadata create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecuritySamlDefMetadataCreateParams) WithDefaults() *SecuritySamlDefMetadataCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security saml def metadata create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecuritySamlDefMetadataCreateParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := SecuritySamlDefMetadataCreateParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) WithTimeout(timeout time.Duration) *SecuritySamlDefMetadataCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) WithContext(ctx context.Context) *SecuritySamlDefMetadataCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) WithHTTPClient(client *http.Client) *SecuritySamlDefMetadataCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) WithInfo(info *models.SecuritySamlDefMetadata) *SecuritySamlDefMetadataCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) SetInfo(info *models.SecuritySamlDefMetadata) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) WithReturnTimeout(returnTimeout *int64) *SecuritySamlDefMetadataCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security saml def metadata create params
func (o *SecuritySamlDefMetadataCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SecuritySamlDefMetadataCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
