// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecuritySamlDefMetadataCreateReader is a Reader for the SecuritySamlDefMetadataCreate structure.
type SecuritySamlDefMetadataCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecuritySamlDefMetadataCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecuritySamlDefMetadataCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSecuritySamlDefMetadataCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecuritySamlDefMetadataCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecuritySamlDefMetadataCreateCreated creates a SecuritySamlDefMetadataCreateCreated with default headers values
func NewSecuritySamlDefMetadataCreateCreated() *SecuritySamlDefMetadataCreateCreated {
	return &SecuritySamlDefMetadataCreateCreated{}
}

/*
SecuritySamlDefMetadataCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SecuritySamlDefMetadataCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecuritySamlDefMetadataJobLinkResponse
}

// IsSuccess returns true when this security saml def metadata create created response has a 2xx status code
func (o *SecuritySamlDefMetadataCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security saml def metadata create created response has a 3xx status code
func (o *SecuritySamlDefMetadataCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security saml def metadata create created response has a 4xx status code
func (o *SecuritySamlDefMetadataCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this security saml def metadata create created response has a 5xx status code
func (o *SecuritySamlDefMetadataCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this security saml def metadata create created response a status code equal to that given
func (o *SecuritySamlDefMetadataCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the security saml def metadata create created response
func (o *SecuritySamlDefMetadataCreateCreated) Code() int {
	return 201
}

func (o *SecuritySamlDefMetadataCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/saml-sp/default-metadata][%d] securitySamlDefMetadataCreateCreated %s", 201, payload)
}

func (o *SecuritySamlDefMetadataCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/saml-sp/default-metadata][%d] securitySamlDefMetadataCreateCreated %s", 201, payload)
}

func (o *SecuritySamlDefMetadataCreateCreated) GetPayload() *models.SecuritySamlDefMetadataJobLinkResponse {
	return o.Payload
}

func (o *SecuritySamlDefMetadataCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecuritySamlDefMetadataJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecuritySamlDefMetadataCreateAccepted creates a SecuritySamlDefMetadataCreateAccepted with default headers values
func NewSecuritySamlDefMetadataCreateAccepted() *SecuritySamlDefMetadataCreateAccepted {
	return &SecuritySamlDefMetadataCreateAccepted{}
}

/*
SecuritySamlDefMetadataCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SecuritySamlDefMetadataCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecuritySamlDefMetadataJobLinkResponse
}

// IsSuccess returns true when this security saml def metadata create accepted response has a 2xx status code
func (o *SecuritySamlDefMetadataCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security saml def metadata create accepted response has a 3xx status code
func (o *SecuritySamlDefMetadataCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security saml def metadata create accepted response has a 4xx status code
func (o *SecuritySamlDefMetadataCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this security saml def metadata create accepted response has a 5xx status code
func (o *SecuritySamlDefMetadataCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this security saml def metadata create accepted response a status code equal to that given
func (o *SecuritySamlDefMetadataCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the security saml def metadata create accepted response
func (o *SecuritySamlDefMetadataCreateAccepted) Code() int {
	return 202
}

func (o *SecuritySamlDefMetadataCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/saml-sp/default-metadata][%d] securitySamlDefMetadataCreateAccepted %s", 202, payload)
}

func (o *SecuritySamlDefMetadataCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/saml-sp/default-metadata][%d] securitySamlDefMetadataCreateAccepted %s", 202, payload)
}

func (o *SecuritySamlDefMetadataCreateAccepted) GetPayload() *models.SecuritySamlDefMetadataJobLinkResponse {
	return o.Payload
}

func (o *SecuritySamlDefMetadataCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecuritySamlDefMetadataJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecuritySamlDefMetadataCreateDefault creates a SecuritySamlDefMetadataCreateDefault with default headers values
func NewSecuritySamlDefMetadataCreateDefault(code int) *SecuritySamlDefMetadataCreateDefault {
	return &SecuritySamlDefMetadataCreateDefault{
		_statusCode: code,
	}
}

/*
	SecuritySamlDefMetadataCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 12320794 | Invalid host parameter for default metadata generation. The host parameter must be the cluster management interface's IP address. If the cluster management interface is not available, the node management interface's IP address must be used. |
| 12320805 | The certificate information provided does not match any installed certificates. |
| 12320806 | The certificate information entered does not match any installed certificates. |
| 12320820 | No certificate is installed with the specified “certificate.ca“ and “certificate.serial“. |
| 12320821 | No certificate is installed with the specified “certificate.common_name“. |
| 12320825 | SAML configuration already exists. Cannot create the metadata when SAML configuration is already present. |
| 12320831 | Default metadata configuration already exists. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecuritySamlDefMetadataCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security saml def metadata create default response has a 2xx status code
func (o *SecuritySamlDefMetadataCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security saml def metadata create default response has a 3xx status code
func (o *SecuritySamlDefMetadataCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security saml def metadata create default response has a 4xx status code
func (o *SecuritySamlDefMetadataCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security saml def metadata create default response has a 5xx status code
func (o *SecuritySamlDefMetadataCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security saml def metadata create default response a status code equal to that given
func (o *SecuritySamlDefMetadataCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security saml def metadata create default response
func (o *SecuritySamlDefMetadataCreateDefault) Code() int {
	return o._statusCode
}

func (o *SecuritySamlDefMetadataCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/saml-sp/default-metadata][%d] security_saml_def_metadata_create default %s", o._statusCode, payload)
}

func (o *SecuritySamlDefMetadataCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/saml-sp/default-metadata][%d] security_saml_def_metadata_create default %s", o._statusCode, payload)
}

func (o *SecuritySamlDefMetadataCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecuritySamlDefMetadataCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
