// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecuritySamlDefMetadataDeleteReader is a Reader for the SecuritySamlDefMetadataDelete structure.
type SecuritySamlDefMetadataDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecuritySamlDefMetadataDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecuritySamlDefMetadataDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecuritySamlDefMetadataDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecuritySamlDefMetadataDeleteOK creates a SecuritySamlDefMetadataDeleteOK with default headers values
func NewSecuritySamlDefMetadataDeleteOK() *SecuritySamlDefMetadataDeleteOK {
	return &SecuritySamlDefMetadataDeleteOK{}
}

/*
SecuritySamlDefMetadataDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SecuritySamlDefMetadataDeleteOK struct {
}

// IsSuccess returns true when this security saml def metadata delete o k response has a 2xx status code
func (o *SecuritySamlDefMetadataDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security saml def metadata delete o k response has a 3xx status code
func (o *SecuritySamlDefMetadataDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security saml def metadata delete o k response has a 4xx status code
func (o *SecuritySamlDefMetadataDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security saml def metadata delete o k response has a 5xx status code
func (o *SecuritySamlDefMetadataDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security saml def metadata delete o k response a status code equal to that given
func (o *SecuritySamlDefMetadataDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security saml def metadata delete o k response
func (o *SecuritySamlDefMetadataDeleteOK) Code() int {
	return 200
}

func (o *SecuritySamlDefMetadataDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp/default-metadata][%d] securitySamlDefMetadataDeleteOK", 200)
}

func (o *SecuritySamlDefMetadataDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp/default-metadata][%d] securitySamlDefMetadataDeleteOK", 200)
}

func (o *SecuritySamlDefMetadataDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecuritySamlDefMetadataDeleteDefault creates a SecuritySamlDefMetadataDeleteDefault with default headers values
func NewSecuritySamlDefMetadataDeleteDefault(code int) *SecuritySamlDefMetadataDeleteDefault {
	return &SecuritySamlDefMetadataDeleteDefault{
		_statusCode: code,
	}
}

/*
	SecuritySamlDefMetadataDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 12320817 | Internal Error. The SAML service provider metadata configuration is being created, but is taking longer than expected to complete. |
| 12320826 | SAML configuration already exists. Cannot delete the metadata when SAML configuration is already present. |
| 12320832 | Internal Error. Failed to execute the command, web server setup is in progress. Retry after some time. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecuritySamlDefMetadataDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security saml def metadata delete default response has a 2xx status code
func (o *SecuritySamlDefMetadataDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security saml def metadata delete default response has a 3xx status code
func (o *SecuritySamlDefMetadataDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security saml def metadata delete default response has a 4xx status code
func (o *SecuritySamlDefMetadataDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security saml def metadata delete default response has a 5xx status code
func (o *SecuritySamlDefMetadataDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security saml def metadata delete default response a status code equal to that given
func (o *SecuritySamlDefMetadataDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security saml def metadata delete default response
func (o *SecuritySamlDefMetadataDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SecuritySamlDefMetadataDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp/default-metadata][%d] security_saml_def_metadata_delete default %s", o._statusCode, payload)
}

func (o *SecuritySamlDefMetadataDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp/default-metadata][%d] security_saml_def_metadata_delete default %s", o._statusCode, payload)
}

func (o *SecuritySamlDefMetadataDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecuritySamlDefMetadataDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
