// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecuritySamlDefMetadataGetParams creates a new SecuritySamlDefMetadataGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecuritySamlDefMetadataGetParams() *SecuritySamlDefMetadataGetParams {
	return &SecuritySamlDefMetadataGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecuritySamlDefMetadataGetParamsWithTimeout creates a new SecuritySamlDefMetadataGetParams object
// with the ability to set a timeout on a request.
func NewSecuritySamlDefMetadataGetParamsWithTimeout(timeout time.Duration) *SecuritySamlDefMetadataGetParams {
	return &SecuritySamlDefMetadataGetParams{
		timeout: timeout,
	}
}

// NewSecuritySamlDefMetadataGetParamsWithContext creates a new SecuritySamlDefMetadataGetParams object
// with the ability to set a context for a request.
func NewSecuritySamlDefMetadataGetParamsWithContext(ctx context.Context) *SecuritySamlDefMetadataGetParams {
	return &SecuritySamlDefMetadataGetParams{
		Context: ctx,
	}
}

// NewSecuritySamlDefMetadataGetParamsWithHTTPClient creates a new SecuritySamlDefMetadataGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecuritySamlDefMetadataGetParamsWithHTTPClient(client *http.Client) *SecuritySamlDefMetadataGetParams {
	return &SecuritySamlDefMetadataGetParams{
		HTTPClient: client,
	}
}

/*
SecuritySamlDefMetadataGetParams contains all the parameters to send to the API endpoint

	for the security saml def metadata get operation.

	Typically these are written to a http.Request.
*/
type SecuritySamlDefMetadataGetParams struct {

	/* CertificateCa.

	   Filter by certificate.ca
	*/
	CertificateCa *string

	/* CertificateCommonName.

	   Filter by certificate.common_name
	*/
	CertificateCommonName *string

	/* CertificateSerialNumber.

	   Filter by certificate.serial_number
	*/
	CertificateSerialNumber *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Host.

	   Filter by host
	*/
	Host *string

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security saml def metadata get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecuritySamlDefMetadataGetParams) WithDefaults() *SecuritySamlDefMetadataGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security saml def metadata get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecuritySamlDefMetadataGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithTimeout(timeout time.Duration) *SecuritySamlDefMetadataGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithContext(ctx context.Context) *SecuritySamlDefMetadataGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithHTTPClient(client *http.Client) *SecuritySamlDefMetadataGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateCa adds the certificateCa to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithCertificateCa(certificateCa *string) *SecuritySamlDefMetadataGetParams {
	o.SetCertificateCa(certificateCa)
	return o
}

// SetCertificateCa adds the certificateCa to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetCertificateCa(certificateCa *string) {
	o.CertificateCa = certificateCa
}

// WithCertificateCommonName adds the certificateCommonName to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithCertificateCommonName(certificateCommonName *string) *SecuritySamlDefMetadataGetParams {
	o.SetCertificateCommonName(certificateCommonName)
	return o
}

// SetCertificateCommonName adds the certificateCommonName to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetCertificateCommonName(certificateCommonName *string) {
	o.CertificateCommonName = certificateCommonName
}

// WithCertificateSerialNumber adds the certificateSerialNumber to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithCertificateSerialNumber(certificateSerialNumber *string) *SecuritySamlDefMetadataGetParams {
	o.SetCertificateSerialNumber(certificateSerialNumber)
	return o
}

// SetCertificateSerialNumber adds the certificateSerialNumber to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetCertificateSerialNumber(certificateSerialNumber *string) {
	o.CertificateSerialNumber = certificateSerialNumber
}

// WithFields adds the fields to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithFields(fields []string) *SecuritySamlDefMetadataGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHost adds the host to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithHost(host *string) *SecuritySamlDefMetadataGetParams {
	o.SetHost(host)
	return o
}

// SetHost adds the host to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetHost(host *string) {
	o.Host = host
}

// WithScope adds the scope to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) WithScope(scope *string) *SecuritySamlDefMetadataGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security saml def metadata get params
func (o *SecuritySamlDefMetadataGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WriteToRequest writes these params to a swagger request
func (o *SecuritySamlDefMetadataGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateCa != nil {

		// query param certificate.ca
		var qrCertificateCa string

		if o.CertificateCa != nil {
			qrCertificateCa = *o.CertificateCa
		}
		qCertificateCa := qrCertificateCa
		if qCertificateCa != "" {

			if err := r.SetQueryParam("certificate.ca", qCertificateCa); err != nil {
				return err
			}
		}
	}

	if o.CertificateCommonName != nil {

		// query param certificate.common_name
		var qrCertificateCommonName string

		if o.CertificateCommonName != nil {
			qrCertificateCommonName = *o.CertificateCommonName
		}
		qCertificateCommonName := qrCertificateCommonName
		if qCertificateCommonName != "" {

			if err := r.SetQueryParam("certificate.common_name", qCertificateCommonName); err != nil {
				return err
			}
		}
	}

	if o.CertificateSerialNumber != nil {

		// query param certificate.serial_number
		var qrCertificateSerialNumber string

		if o.CertificateSerialNumber != nil {
			qrCertificateSerialNumber = *o.CertificateSerialNumber
		}
		qCertificateSerialNumber := qrCertificateSerialNumber
		if qCertificateSerialNumber != "" {

			if err := r.SetQueryParam("certificate.serial_number", qCertificateSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Host != nil {

		// query param host
		var qrHost string

		if o.Host != nil {
			qrHost = *o.Host
		}
		qHost := qrHost
		if qHost != "" {

			if err := r.SetQueryParam("host", qHost); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecuritySamlDefMetadataGet binds the parameter fields
func (o *SecuritySamlDefMetadataGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
