// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecuritySamlSpDeleteReader is a Reader for the SecuritySamlSpDelete structure.
type SecuritySamlSpDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecuritySamlSpDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecuritySamlSpDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecuritySamlSpDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecuritySamlSpDeleteOK creates a SecuritySamlSpDeleteOK with default headers values
func NewSecuritySamlSpDeleteOK() *SecuritySamlSpDeleteOK {
	return &SecuritySamlSpDeleteOK{}
}

/*
SecuritySamlSpDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SecuritySamlSpDeleteOK struct {
}

// IsSuccess returns true when this security saml sp delete o k response has a 2xx status code
func (o *SecuritySamlSpDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security saml sp delete o k response has a 3xx status code
func (o *SecuritySamlSpDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security saml sp delete o k response has a 4xx status code
func (o *SecuritySamlSpDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security saml sp delete o k response has a 5xx status code
func (o *SecuritySamlSpDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security saml sp delete o k response a status code equal to that given
func (o *SecuritySamlSpDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security saml sp delete o k response
func (o *SecuritySamlSpDeleteOK) Code() int {
	return 200
}

func (o *SecuritySamlSpDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp][%d] securitySamlSpDeleteOK", 200)
}

func (o *SecuritySamlSpDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp][%d] securitySamlSpDeleteOK", 200)
}

func (o *SecuritySamlSpDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecuritySamlSpDeleteDefault creates a SecuritySamlSpDeleteDefault with default headers values
func NewSecuritySamlSpDeleteDefault(code int) *SecuritySamlSpDeleteDefault {
	return &SecuritySamlSpDeleteDefault{
		_statusCode: code,
	}
}

/*
	SecuritySamlSpDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 12320803 | SAML must be disabled before the configuration can be removed. |
| 12320832 | Internal Error. Failed to execute the command, web server setup is in progress. Retry after some time. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecuritySamlSpDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security saml sp delete default response has a 2xx status code
func (o *SecuritySamlSpDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security saml sp delete default response has a 3xx status code
func (o *SecuritySamlSpDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security saml sp delete default response has a 4xx status code
func (o *SecuritySamlSpDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security saml sp delete default response has a 5xx status code
func (o *SecuritySamlSpDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security saml sp delete default response a status code equal to that given
func (o *SecuritySamlSpDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security saml sp delete default response
func (o *SecuritySamlSpDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SecuritySamlSpDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp][%d] security_saml_sp_delete default %s", o._statusCode, payload)
}

func (o *SecuritySamlSpDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/cluster/saml-sp][%d] security_saml_sp_delete default %s", o._statusCode, payload)
}

func (o *SecuritySamlSpDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecuritySamlSpDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
