// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecuritySamlSpGetParams creates a new SecuritySamlSpGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecuritySamlSpGetParams() *SecuritySamlSpGetParams {
	return &SecuritySamlSpGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecuritySamlSpGetParamsWithTimeout creates a new SecuritySamlSpGetParams object
// with the ability to set a timeout on a request.
func NewSecuritySamlSpGetParamsWithTimeout(timeout time.Duration) *SecuritySamlSpGetParams {
	return &SecuritySamlSpGetParams{
		timeout: timeout,
	}
}

// NewSecuritySamlSpGetParamsWithContext creates a new SecuritySamlSpGetParams object
// with the ability to set a context for a request.
func NewSecuritySamlSpGetParamsWithContext(ctx context.Context) *SecuritySamlSpGetParams {
	return &SecuritySamlSpGetParams{
		Context: ctx,
	}
}

// NewSecuritySamlSpGetParamsWithHTTPClient creates a new SecuritySamlSpGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecuritySamlSpGetParamsWithHTTPClient(client *http.Client) *SecuritySamlSpGetParams {
	return &SecuritySamlSpGetParams{
		HTTPClient: client,
	}
}

/*
SecuritySamlSpGetParams contains all the parameters to send to the API endpoint

	for the security saml sp get operation.

	Typically these are written to a http.Request.
*/
type SecuritySamlSpGetParams struct {

	/* CertificateCa.

	   Filter by certificate.ca
	*/
	CertificateCa *string

	/* CertificateCommonName.

	   Filter by certificate.common_name
	*/
	CertificateCommonName *string

	/* CertificateSerialNumber.

	   Filter by certificate.serial_number
	*/
	CertificateSerialNumber *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Host.

	   Filter by host
	*/
	Host *string

	/* IdpURI.

	   Filter by idp_uri
	*/
	IdpURI *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security saml sp get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecuritySamlSpGetParams) WithDefaults() *SecuritySamlSpGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security saml sp get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecuritySamlSpGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithTimeout(timeout time.Duration) *SecuritySamlSpGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithContext(ctx context.Context) *SecuritySamlSpGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithHTTPClient(client *http.Client) *SecuritySamlSpGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateCa adds the certificateCa to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithCertificateCa(certificateCa *string) *SecuritySamlSpGetParams {
	o.SetCertificateCa(certificateCa)
	return o
}

// SetCertificateCa adds the certificateCa to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetCertificateCa(certificateCa *string) {
	o.CertificateCa = certificateCa
}

// WithCertificateCommonName adds the certificateCommonName to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithCertificateCommonName(certificateCommonName *string) *SecuritySamlSpGetParams {
	o.SetCertificateCommonName(certificateCommonName)
	return o
}

// SetCertificateCommonName adds the certificateCommonName to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetCertificateCommonName(certificateCommonName *string) {
	o.CertificateCommonName = certificateCommonName
}

// WithCertificateSerialNumber adds the certificateSerialNumber to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithCertificateSerialNumber(certificateSerialNumber *string) *SecuritySamlSpGetParams {
	o.SetCertificateSerialNumber(certificateSerialNumber)
	return o
}

// SetCertificateSerialNumber adds the certificateSerialNumber to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetCertificateSerialNumber(certificateSerialNumber *string) {
	o.CertificateSerialNumber = certificateSerialNumber
}

// WithEnabled adds the enabled to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithEnabled(enabled *bool) *SecuritySamlSpGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithFields(fields []string) *SecuritySamlSpGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHost adds the host to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithHost(host *string) *SecuritySamlSpGetParams {
	o.SetHost(host)
	return o
}

// SetHost adds the host to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetHost(host *string) {
	o.Host = host
}

// WithIdpURI adds the idpURI to the security saml sp get params
func (o *SecuritySamlSpGetParams) WithIdpURI(idpURI *string) *SecuritySamlSpGetParams {
	o.SetIdpURI(idpURI)
	return o
}

// SetIdpURI adds the idpUri to the security saml sp get params
func (o *SecuritySamlSpGetParams) SetIdpURI(idpURI *string) {
	o.IdpURI = idpURI
}

// WriteToRequest writes these params to a swagger request
func (o *SecuritySamlSpGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateCa != nil {

		// query param certificate.ca
		var qrCertificateCa string

		if o.CertificateCa != nil {
			qrCertificateCa = *o.CertificateCa
		}
		qCertificateCa := qrCertificateCa
		if qCertificateCa != "" {

			if err := r.SetQueryParam("certificate.ca", qCertificateCa); err != nil {
				return err
			}
		}
	}

	if o.CertificateCommonName != nil {

		// query param certificate.common_name
		var qrCertificateCommonName string

		if o.CertificateCommonName != nil {
			qrCertificateCommonName = *o.CertificateCommonName
		}
		qCertificateCommonName := qrCertificateCommonName
		if qCertificateCommonName != "" {

			if err := r.SetQueryParam("certificate.common_name", qCertificateCommonName); err != nil {
				return err
			}
		}
	}

	if o.CertificateSerialNumber != nil {

		// query param certificate.serial_number
		var qrCertificateSerialNumber string

		if o.CertificateSerialNumber != nil {
			qrCertificateSerialNumber = *o.CertificateSerialNumber
		}
		qCertificateSerialNumber := qrCertificateSerialNumber
		if qCertificateSerialNumber != "" {

			if err := r.SetQueryParam("certificate.serial_number", qCertificateSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Host != nil {

		// query param host
		var qrHost string

		if o.Host != nil {
			qrHost = *o.Host
		}
		qHost := qrHost
		if qHost != "" {

			if err := r.SetQueryParam("host", qHost); err != nil {
				return err
			}
		}
	}

	if o.IdpURI != nil {

		// query param idp_uri
		var qrIdpURI string

		if o.IdpURI != nil {
			qrIdpURI = *o.IdpURI
		}
		qIdpURI := qrIdpURI
		if qIdpURI != "" {

			if err := r.SetQueryParam("idp_uri", qIdpURI); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecuritySamlSpGet binds the parameter fields
func (o *SecuritySamlSpGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
