// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecuritySamlSpModifyReader is a Reader for the SecuritySamlSpModify structure.
type SecuritySamlSpModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecuritySamlSpModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecuritySamlSpModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecuritySamlSpModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecuritySamlSpModifyOK creates a SecuritySamlSpModifyOK with default headers values
func NewSecuritySamlSpModifyOK() *SecuritySamlSpModifyOK {
	return &SecuritySamlSpModifyOK{}
}

/*
SecuritySamlSpModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecuritySamlSpModifyOK struct {
}

// IsSuccess returns true when this security saml sp modify o k response has a 2xx status code
func (o *SecuritySamlSpModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security saml sp modify o k response has a 3xx status code
func (o *SecuritySamlSpModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security saml sp modify o k response has a 4xx status code
func (o *SecuritySamlSpModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security saml sp modify o k response has a 5xx status code
func (o *SecuritySamlSpModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security saml sp modify o k response a status code equal to that given
func (o *SecuritySamlSpModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security saml sp modify o k response
func (o *SecuritySamlSpModifyOK) Code() int {
	return 200
}

func (o *SecuritySamlSpModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/saml-sp][%d] securitySamlSpModifyOK", 200)
}

func (o *SecuritySamlSpModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/saml-sp][%d] securitySamlSpModifyOK", 200)
}

func (o *SecuritySamlSpModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecuritySamlSpModifyDefault creates a SecuritySamlSpModifyDefault with default headers values
func NewSecuritySamlSpModifyDefault(code int) *SecuritySamlSpModifyDefault {
	return &SecuritySamlSpModifyDefault{
		_statusCode: code,
	}
}

/*
	SecuritySamlSpModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 12320791 | SAML can only be disabled using the console or a SAML-authenticated application. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecuritySamlSpModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security saml sp modify default response has a 2xx status code
func (o *SecuritySamlSpModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security saml sp modify default response has a 3xx status code
func (o *SecuritySamlSpModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security saml sp modify default response has a 4xx status code
func (o *SecuritySamlSpModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security saml sp modify default response has a 5xx status code
func (o *SecuritySamlSpModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security saml sp modify default response a status code equal to that given
func (o *SecuritySamlSpModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security saml sp modify default response
func (o *SecuritySamlSpModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecuritySamlSpModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/saml-sp][%d] security_saml_sp_modify default %s", o._statusCode, payload)
}

func (o *SecuritySamlSpModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/saml-sp][%d] security_saml_sp_modify default %s", o._statusCode, payload)
}

func (o *SecuritySamlSpModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecuritySamlSpModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
