// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SSHGetReader is a Reader for the SSHGet structure.
type SSHGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SSHGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSSHGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSSHGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSSHGetOK creates a SSHGetOK with default headers values
func NewSSHGetOK() *SSHGetOK {
	return &SSHGetOK{}
}

/*
SSHGetOK describes a response with status code 200, with default header values.

OK
*/
type SSHGetOK struct {
	Payload *models.ClusterSSHServer
}

// IsSuccess returns true when this ssh get o k response has a 2xx status code
func (o *SSHGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ssh get o k response has a 3xx status code
func (o *SSHGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ssh get o k response has a 4xx status code
func (o *SSHGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ssh get o k response has a 5xx status code
func (o *SSHGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ssh get o k response a status code equal to that given
func (o *SSHGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ssh get o k response
func (o *SSHGetOK) Code() int {
	return 200
}

func (o *SSHGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ssh][%d] sshGetOK %s", 200, payload)
}

func (o *SSHGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ssh][%d] sshGetOK %s", 200, payload)
}

func (o *SSHGetOK) GetPayload() *models.ClusterSSHServer {
	return o.Payload
}

func (o *SSHGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ClusterSSHServer)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSSHGetDefault creates a SSHGetDefault with default headers values
func NewSSHGetDefault(code int) *SSHGetDefault {
	return &SSHGetDefault{
		_statusCode: code,
	}
}

/*
SSHGetDefault describes a response with status code -1, with default header values.

Error
*/
type SSHGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ssh get default response has a 2xx status code
func (o *SSHGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ssh get default response has a 3xx status code
func (o *SSHGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ssh get default response has a 4xx status code
func (o *SSHGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ssh get default response has a 5xx status code
func (o *SSHGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ssh get default response a status code equal to that given
func (o *SSHGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ssh get default response
func (o *SSHGetDefault) Code() int {
	return o._statusCode
}

func (o *SSHGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ssh][%d] ssh_get default %s", o._statusCode, payload)
}

func (o *SSHGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ssh][%d] ssh_get default %s", o._statusCode, payload)
}

func (o *SSHGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SSHGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
