// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SSHModifyReader is a Reader for the SSHModify structure.
type SSHModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SSHModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSSHModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSSHModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSSHModifyOK creates a SSHModifyOK with default headers values
func NewSSHModifyOK() *SSHModifyOK {
	return &SSHModifyOK{}
}

/*
SSHModifyOK describes a response with status code 200, with default header values.

OK
*/
type SSHModifyOK struct {
}

// IsSuccess returns true when this ssh modify o k response has a 2xx status code
func (o *SSHModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ssh modify o k response has a 3xx status code
func (o *SSHModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ssh modify o k response has a 4xx status code
func (o *SSHModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ssh modify o k response has a 5xx status code
func (o *SSHModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ssh modify o k response a status code equal to that given
func (o *SSHModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ssh modify o k response
func (o *SSHModifyOK) Code() int {
	return 200
}

func (o *SSHModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/ssh][%d] sshModifyOK", 200)
}

func (o *SSHModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/ssh][%d] sshModifyOK", 200)
}

func (o *SSHModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSSHModifyDefault creates a SSHModifyDefault with default headers values
func NewSSHModifyDefault(code int) *SSHModifyDefault {
	return &SSHModifyDefault{
		_statusCode: code,
	}
}

/*
	SSHModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10682372 | There must be at least one key exchange algorithm associated with the SSH configuration. |
| 10682373 | There must be at least one cipher associated with the SSH configuration. |
| 10682375 | Failed to modify SSH key exchange algorithms. |
| 10682378 | Failed to modify SSH ciphers. |
| 10682399 | Key exchange algorithm not supported in FIPS enabled mode. |
| 10682400 | Failed to modify SSH MAC algorithms. |
| 10682401 | MAC algorithm not supported in FIPS enabled mode. |
| 10682403 | There must be at least one MAC algorithm with the SSH configuration. |
| 10682413 | Failed to modify maximum authentication retry attempts. |
| 10682413 | Failed to modify maximum authentication retry attempts. |
| 10682418 | Cipher not supported in FIPS enabled mode. |
| 10682423 | There must be at least one host key algorithm associated with the SSH configuration. |
| 10682424 | Host key algorithm not supported in FIPS enabled mode. |
| 10682425 | Failed to modify Host key algorithms. |
| 10682426 | Failed to modify _ssh-rsa_ enabled status for publickey algorithms configuration. |
| 10682426 | Failed to modify the SSH connection login grace time. |
| 10682428 | Cipher not supported in FIPS enabled mode. |
| 10682429 | Adding 'diffie_hellman_group16_sha512' or 'diffie_hellman_group18_sha512' to the SSH key exchange algorithms list requires an effective cluster version of ONTAP 9.16.1 or later. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SSHModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ssh modify default response has a 2xx status code
func (o *SSHModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ssh modify default response has a 3xx status code
func (o *SSHModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ssh modify default response has a 4xx status code
func (o *SSHModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ssh modify default response has a 5xx status code
func (o *SSHModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ssh modify default response a status code equal to that given
func (o *SSHModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ssh modify default response
func (o *SSHModifyDefault) Code() int {
	return o._statusCode
}

func (o *SSHModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ssh][%d] ssh_modify default %s", o._statusCode, payload)
}

func (o *SSHModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ssh][%d] ssh_modify default %s", o._statusCode, payload)
}

func (o *SSHModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SSHModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
