// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewStorageUnitAntiRansomwareEntropyStatsGetParams creates a new StorageUnitAntiRansomwareEntropyStatsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStorageUnitAntiRansomwareEntropyStatsGetParams() *StorageUnitAntiRansomwareEntropyStatsGetParams {
	return &StorageUnitAntiRansomwareEntropyStatsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStorageUnitAntiRansomwareEntropyStatsGetParamsWithTimeout creates a new StorageUnitAntiRansomwareEntropyStatsGetParams object
// with the ability to set a timeout on a request.
func NewStorageUnitAntiRansomwareEntropyStatsGetParamsWithTimeout(timeout time.Duration) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	return &StorageUnitAntiRansomwareEntropyStatsGetParams{
		timeout: timeout,
	}
}

// NewStorageUnitAntiRansomwareEntropyStatsGetParamsWithContext creates a new StorageUnitAntiRansomwareEntropyStatsGetParams object
// with the ability to set a context for a request.
func NewStorageUnitAntiRansomwareEntropyStatsGetParamsWithContext(ctx context.Context) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	return &StorageUnitAntiRansomwareEntropyStatsGetParams{
		Context: ctx,
	}
}

// NewStorageUnitAntiRansomwareEntropyStatsGetParamsWithHTTPClient creates a new StorageUnitAntiRansomwareEntropyStatsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewStorageUnitAntiRansomwareEntropyStatsGetParamsWithHTTPClient(client *http.Client) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	return &StorageUnitAntiRansomwareEntropyStatsGetParams{
		HTTPClient: client,
	}
}

/*
StorageUnitAntiRansomwareEntropyStatsGetParams contains all the parameters to send to the API endpoint

	for the storage unit anti ransomware entropy stats get operation.

	Typically these are written to a http.Request.
*/
type StorageUnitAntiRansomwareEntropyStatsGetParams struct {

	/* EntropyStatsType.

	   The type of entropy statistics.
	*/
	EntropyStatsType string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* StorageUnitUUID.

	   The UUID of the storage unit.
	*/
	StorageUnitUUID string

	/* Timestamp.

	   The timestamp of the statistics.

	   Format: date-time
	*/
	Timestamp strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage unit anti ransomware entropy stats get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithDefaults() *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage unit anti ransomware entropy stats get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithTimeout(timeout time.Duration) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithContext(ctx context.Context) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithHTTPClient(client *http.Client) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEntropyStatsType adds the entropyStatsType to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithEntropyStatsType(entropyStatsType string) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetEntropyStatsType(entropyStatsType)
	return o
}

// SetEntropyStatsType adds the entropyStatsType to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetEntropyStatsType(entropyStatsType string) {
	o.EntropyStatsType = entropyStatsType
}

// WithFields adds the fields to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithFields(fields []string) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithStorageUnitUUID adds the storageUnitUUID to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithStorageUnitUUID(storageUnitUUID string) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetStorageUnitUUID(storageUnitUUID)
	return o
}

// SetStorageUnitUUID adds the storageUnitUuid to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetStorageUnitUUID(storageUnitUUID string) {
	o.StorageUnitUUID = storageUnitUUID
}

// WithTimestamp adds the timestamp to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WithTimestamp(timestamp strfmt.DateTime) *StorageUnitAntiRansomwareEntropyStatsGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the storage unit anti ransomware entropy stats get params
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) SetTimestamp(timestamp strfmt.DateTime) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param entropy_stats_type
	if err := r.SetPathParam("entropy_stats_type", o.EntropyStatsType); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param storage_unit.uuid
	if err := r.SetPathParam("storage_unit.uuid", o.StorageUnitUUID); err != nil {
		return err
	}

	// path param timestamp
	if err := r.SetPathParam("timestamp", o.Timestamp.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamStorageUnitAntiRansomwareEntropyStatsGet binds the parameter fields
func (o *StorageUnitAntiRansomwareEntropyStatsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
