// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionParams creates a new StorageUnitAntiRansomwareSuspectDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionParams() *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionParamsWithTimeout creates a new StorageUnitAntiRansomwareSuspectDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionParamsWithTimeout(timeout time.Duration) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionParamsWithContext creates a new StorageUnitAntiRansomwareSuspectDeleteCollectionParams object
// with the ability to set a context for a request.
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionParamsWithContext(ctx context.Context) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionParams{
		Context: ctx,
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionParamsWithHTTPClient creates a new StorageUnitAntiRansomwareSuspectDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionParamsWithHTTPClient(client *http.Client) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
StorageUnitAntiRansomwareSuspectDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the storage unit anti ransomware suspect delete collection operation.

	Typically these are written to a http.Request.
*/
type StorageUnitAntiRansomwareSuspectDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info StorageUnitAntiRansomwareSuspectDeleteCollectionBody

	/* IsFalsePositive.

	   Specifies whether the suspected ransomware activity is a false positive. This is used to clear the reported ransomware attack on a storage unit, which clears the various ARP entropy statistic tables, deletes the snapshots, and so on.
	*/
	IsFalsePositive *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StorageUnitName.

	   Filter by storage_unit.name
	*/
	StorageUnitName *string

	/* StorageUnitUUID.

	   Filter by storage_unit.uuid
	*/
	StorageUnitUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage unit anti ransomware suspect delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithDefaults() *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage unit anti ransomware suspect delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		isFalsePositiveDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := StorageUnitAntiRansomwareSuspectDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		IsFalsePositive:   &isFalsePositiveDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithTimeout(timeout time.Duration) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithContext(ctx context.Context) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithHTTPClient(client *http.Client) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithInfo(info StorageUnitAntiRansomwareSuspectDeleteCollectionBody) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetInfo(info StorageUnitAntiRansomwareSuspectDeleteCollectionBody) {
	o.Info = info
}

// WithIsFalsePositive adds the isFalsePositive to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithIsFalsePositive(isFalsePositive *bool) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetIsFalsePositive(isFalsePositive)
	return o
}

// SetIsFalsePositive adds the isFalsePositive to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetIsFalsePositive(isFalsePositive *bool) {
	o.IsFalsePositive = isFalsePositive
}

// WithReturnRecords adds the returnRecords to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStorageUnitName adds the storageUnitName to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithStorageUnitName(storageUnitName *string) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetStorageUnitName(storageUnitName)
	return o
}

// SetStorageUnitName adds the storageUnitName to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetStorageUnitName(storageUnitName *string) {
	o.StorageUnitName = storageUnitName
}

// WithStorageUnitUUID adds the storageUnitUUID to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WithStorageUnitUUID(storageUnitUUID *string) *StorageUnitAntiRansomwareSuspectDeleteCollectionParams {
	o.SetStorageUnitUUID(storageUnitUUID)
	return o
}

// SetStorageUnitUUID adds the storageUnitUuid to the storage unit anti ransomware suspect delete collection params
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) SetStorageUnitUUID(storageUnitUUID *string) {
	o.StorageUnitUUID = storageUnitUUID
}

// WriteToRequest writes these params to a swagger request
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsFalsePositive != nil {

		// query param is_false_positive
		var qrIsFalsePositive bool

		if o.IsFalsePositive != nil {
			qrIsFalsePositive = *o.IsFalsePositive
		}
		qIsFalsePositive := swag.FormatBool(qrIsFalsePositive)
		if qIsFalsePositive != "" {

			if err := r.SetQueryParam("is_false_positive", qIsFalsePositive); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StorageUnitName != nil {

		// query param storage_unit.name
		var qrStorageUnitName string

		if o.StorageUnitName != nil {
			qrStorageUnitName = *o.StorageUnitName
		}
		qStorageUnitName := qrStorageUnitName
		if qStorageUnitName != "" {

			if err := r.SetQueryParam("storage_unit.name", qStorageUnitName); err != nil {
				return err
			}
		}
	}

	if o.StorageUnitUUID != nil {

		// query param storage_unit.uuid
		var qrStorageUnitUUID string

		if o.StorageUnitUUID != nil {
			qrStorageUnitUUID = *o.StorageUnitUUID
		}
		qStorageUnitUUID := qrStorageUnitUUID
		if qStorageUnitUUID != "" {

			if err := r.SetQueryParam("storage_unit.uuid", qStorageUnitUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
