// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitAntiRansomwareSuspectDeleteCollectionReader is a Reader for the StorageUnitAntiRansomwareSuspectDeleteCollection structure.
type StorageUnitAntiRansomwareSuspectDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitAntiRansomwareSuspectDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitAntiRansomwareSuspectDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitAntiRansomwareSuspectDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionOK creates a StorageUnitAntiRansomwareSuspectDeleteCollectionOK with default headers values
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionOK() *StorageUnitAntiRansomwareSuspectDeleteCollectionOK {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionOK{}
}

/*
StorageUnitAntiRansomwareSuspectDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitAntiRansomwareSuspectDeleteCollectionOK struct {
	Payload *models.StorageUnitAntiRansomwareSuspectJobLinkResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect delete collection o k response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit anti ransomware suspect delete collection o k response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit anti ransomware suspect delete collection o k response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit anti ransomware suspect delete collection o k response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit anti ransomware suspect delete collection o k response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit anti ransomware suspect delete collection o k response
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) Code() int {
	return 200
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects][%d] storageUnitAntiRansomwareSuspectDeleteCollectionOK %s", 200, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects][%d] storageUnitAntiRansomwareSuspectDeleteCollectionOK %s", 200, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) GetPayload() *models.StorageUnitAntiRansomwareSuspectJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitAntiRansomwareSuspectJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionAccepted creates a StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted with default headers values
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionAccepted() *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted{}
}

/*
StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted struct {
	Payload *models.StorageUnitAntiRansomwareSuspectJobLinkResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect delete collection accepted response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit anti ransomware suspect delete collection accepted response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit anti ransomware suspect delete collection accepted response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit anti ransomware suspect delete collection accepted response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit anti ransomware suspect delete collection accepted response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit anti ransomware suspect delete collection accepted response
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects][%d] storageUnitAntiRansomwareSuspectDeleteCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects][%d] storageUnitAntiRansomwareSuspectDeleteCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) GetPayload() *models.StorageUnitAntiRansomwareSuspectJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitAntiRansomwareSuspectJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitAntiRansomwareSuspectDeleteCollectionDefault creates a StorageUnitAntiRansomwareSuspectDeleteCollectionDefault with default headers values
func NewStorageUnitAntiRansomwareSuspectDeleteCollectionDefault(code int) *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault {
	return &StorageUnitAntiRansomwareSuspectDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitAntiRansomwareSuspectDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203162606 | The specified storage unit UUID doesn't exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitAntiRansomwareSuspectDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect delete collection default response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit anti ransomware suspect delete collection default response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit anti ransomware suspect delete collection default response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit anti ransomware suspect delete collection default response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit anti ransomware suspect delete collection default response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit anti ransomware suspect delete collection default response
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects][%d] storage_unit_anti_ransomware_suspect_delete_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects][%d] storage_unit_anti_ransomware_suspect_delete_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StorageUnitAntiRansomwareSuspectDeleteCollectionBody List of storage units.
swagger:model StorageUnitAntiRansomwareSuspectDeleteCollectionBody
*/
type StorageUnitAntiRansomwareSuspectDeleteCollectionBody struct {

	// storage unit anti ransomware suspect response inline records
	StorageUnitAntiRansomwareSuspectResponseInlineRecords []*models.StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect delete collection body
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStorageUnitAntiRansomwareSuspectResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionBody) validateStorageUnitAntiRansomwareSuspectResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnitAntiRansomwareSuspectResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageUnitAntiRansomwareSuspectResponseInlineRecords); i++ {
		if swag.IsZero(o.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i] != nil {
			if err := o.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect delete collection body based on the context it is used
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageUnitAntiRansomwareSuspectResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionBody) contextValidateStorageUnitAntiRansomwareSuspectResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StorageUnitAntiRansomwareSuspectResponseInlineRecords); i++ {

		if o.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i] != nil {
			if err := o.StorageUnitAntiRansomwareSuspectResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem Storage unit details.
swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item
*/
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// storage unit
	StorageUnit *models.StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit `json:"storage_unit,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnit) { // not required
		return nil
	}

	if o.StorageUnit != nil {
		if err := o.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item based on the context it is used
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageUnit != nil {
		if err := o.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks storage unit anti ransomware suspect response inline records inline array item inline links
swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item_inline__links
*/
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item inline links
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item inline links based on the context it is used
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit storage unit anti ransomware suspect response inline records inline array item inline storage unit
swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item_inline_storage_unit
*/
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit struct {

	// links
	Links *models.StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item inline storage unit
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item inline storage unit based on the context it is used
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks storage unit anti ransomware suspect response inline records inline array item inline storage unit inline links
swagger:model storage_unit_anti_ransomware_suspect_response_inline_records_inline_array_item_inline_storage_unit_inline__links
*/
type StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit anti ransomware suspect response inline records inline array item inline storage unit inline links
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit anti ransomware suspect response inline records inline array item inline storage unit inline links based on the context it is used
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitAntiRansomwareSuspectResponseInlineRecordsInlineArrayItemInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
