// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewStorageUnitAntiRansomwareSuspectDeleteParams creates a new StorageUnitAntiRansomwareSuspectDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStorageUnitAntiRansomwareSuspectDeleteParams() *StorageUnitAntiRansomwareSuspectDeleteParams {
	return &StorageUnitAntiRansomwareSuspectDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteParamsWithTimeout creates a new StorageUnitAntiRansomwareSuspectDeleteParams object
// with the ability to set a timeout on a request.
func NewStorageUnitAntiRansomwareSuspectDeleteParamsWithTimeout(timeout time.Duration) *StorageUnitAntiRansomwareSuspectDeleteParams {
	return &StorageUnitAntiRansomwareSuspectDeleteParams{
		timeout: timeout,
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteParamsWithContext creates a new StorageUnitAntiRansomwareSuspectDeleteParams object
// with the ability to set a context for a request.
func NewStorageUnitAntiRansomwareSuspectDeleteParamsWithContext(ctx context.Context) *StorageUnitAntiRansomwareSuspectDeleteParams {
	return &StorageUnitAntiRansomwareSuspectDeleteParams{
		Context: ctx,
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteParamsWithHTTPClient creates a new StorageUnitAntiRansomwareSuspectDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewStorageUnitAntiRansomwareSuspectDeleteParamsWithHTTPClient(client *http.Client) *StorageUnitAntiRansomwareSuspectDeleteParams {
	return &StorageUnitAntiRansomwareSuspectDeleteParams{
		HTTPClient: client,
	}
}

/*
StorageUnitAntiRansomwareSuspectDeleteParams contains all the parameters to send to the API endpoint

	for the storage unit anti ransomware suspect delete operation.

	Typically these are written to a http.Request.
*/
type StorageUnitAntiRansomwareSuspectDeleteParams struct {

	/* IsFalsePositive.

	   Specifies whether the suspected ransomware activity is a false positive. This is used to clear the reported ransomware attack on a storage unit, which clears the various ARP entropy statistic tables, deletes the snapshots, and so on.
	*/
	IsFalsePositive *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* StorageUnitUUID.

	   The UUID of the storage unit.

	   Format: uuid
	*/
	StorageUnitUUID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage unit anti ransomware suspect delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithDefaults() *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage unit anti ransomware suspect delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetDefaults() {
	var (
		isFalsePositiveDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := StorageUnitAntiRansomwareSuspectDeleteParams{
		IsFalsePositive: &isFalsePositiveDefault,
		ReturnTimeout:   &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithTimeout(timeout time.Duration) *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithContext(ctx context.Context) *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithHTTPClient(client *http.Client) *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIsFalsePositive adds the isFalsePositive to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithIsFalsePositive(isFalsePositive *bool) *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetIsFalsePositive(isFalsePositive)
	return o
}

// SetIsFalsePositive adds the isFalsePositive to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetIsFalsePositive(isFalsePositive *bool) {
	o.IsFalsePositive = isFalsePositive
}

// WithReturnTimeout adds the returnTimeout to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithReturnTimeout(returnTimeout *int64) *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStorageUnitUUID adds the storageUnitUUID to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WithStorageUnitUUID(storageUnitUUID strfmt.UUID) *StorageUnitAntiRansomwareSuspectDeleteParams {
	o.SetStorageUnitUUID(storageUnitUUID)
	return o
}

// SetStorageUnitUUID adds the storageUnitUuid to the storage unit anti ransomware suspect delete params
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) SetStorageUnitUUID(storageUnitUUID strfmt.UUID) {
	o.StorageUnitUUID = storageUnitUUID
}

// WriteToRequest writes these params to a swagger request
func (o *StorageUnitAntiRansomwareSuspectDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.IsFalsePositive != nil {

		// query param is_false_positive
		var qrIsFalsePositive bool

		if o.IsFalsePositive != nil {
			qrIsFalsePositive = *o.IsFalsePositive
		}
		qIsFalsePositive := swag.FormatBool(qrIsFalsePositive)
		if qIsFalsePositive != "" {

			if err := r.SetQueryParam("is_false_positive", qIsFalsePositive); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param storage_unit.uuid
	if err := r.SetPathParam("storage_unit.uuid", o.StorageUnitUUID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
