// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitAntiRansomwareSuspectDeleteReader is a Reader for the StorageUnitAntiRansomwareSuspectDelete structure.
type StorageUnitAntiRansomwareSuspectDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitAntiRansomwareSuspectDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitAntiRansomwareSuspectDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitAntiRansomwareSuspectDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitAntiRansomwareSuspectDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitAntiRansomwareSuspectDeleteOK creates a StorageUnitAntiRansomwareSuspectDeleteOK with default headers values
func NewStorageUnitAntiRansomwareSuspectDeleteOK() *StorageUnitAntiRansomwareSuspectDeleteOK {
	return &StorageUnitAntiRansomwareSuspectDeleteOK{}
}

/*
StorageUnitAntiRansomwareSuspectDeleteOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitAntiRansomwareSuspectDeleteOK struct {
	Payload *models.StorageUnitAntiRansomwareSuspectJobLinkResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect delete o k response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit anti ransomware suspect delete o k response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit anti ransomware suspect delete o k response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit anti ransomware suspect delete o k response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit anti ransomware suspect delete o k response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit anti ransomware suspect delete o k response
func (o *StorageUnitAntiRansomwareSuspectDeleteOK) Code() int {
	return 200
}

func (o *StorageUnitAntiRansomwareSuspectDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storageUnitAntiRansomwareSuspectDeleteOK %s", 200, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storageUnitAntiRansomwareSuspectDeleteOK %s", 200, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteOK) GetPayload() *models.StorageUnitAntiRansomwareSuspectJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitAntiRansomwareSuspectJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitAntiRansomwareSuspectDeleteAccepted creates a StorageUnitAntiRansomwareSuspectDeleteAccepted with default headers values
func NewStorageUnitAntiRansomwareSuspectDeleteAccepted() *StorageUnitAntiRansomwareSuspectDeleteAccepted {
	return &StorageUnitAntiRansomwareSuspectDeleteAccepted{}
}

/*
StorageUnitAntiRansomwareSuspectDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitAntiRansomwareSuspectDeleteAccepted struct {
	Payload *models.StorageUnitAntiRansomwareSuspectJobLinkResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect delete accepted response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit anti ransomware suspect delete accepted response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit anti ransomware suspect delete accepted response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit anti ransomware suspect delete accepted response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit anti ransomware suspect delete accepted response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit anti ransomware suspect delete accepted response
func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) Code() int {
	return 202
}

func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storageUnitAntiRansomwareSuspectDeleteAccepted %s", 202, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storageUnitAntiRansomwareSuspectDeleteAccepted %s", 202, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) GetPayload() *models.StorageUnitAntiRansomwareSuspectJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitAntiRansomwareSuspectJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitAntiRansomwareSuspectDeleteDefault creates a StorageUnitAntiRansomwareSuspectDeleteDefault with default headers values
func NewStorageUnitAntiRansomwareSuspectDeleteDefault(code int) *StorageUnitAntiRansomwareSuspectDeleteDefault {
	return &StorageUnitAntiRansomwareSuspectDeleteDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitAntiRansomwareSuspectDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 203162606 | The specified storage unit UUID doesn't exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitAntiRansomwareSuspectDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit anti ransomware suspect delete default response has a 2xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit anti ransomware suspect delete default response has a 3xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit anti ransomware suspect delete default response has a 4xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit anti ransomware suspect delete default response has a 5xx status code
func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit anti ransomware suspect delete default response a status code equal to that given
func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit anti ransomware suspect delete default response
func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storage_unit_anti_ransomware_suspect_delete default %s", o._statusCode, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}][%d] storage_unit_anti_ransomware_suspect_delete default %s", o._statusCode, payload)
}

func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitAntiRansomwareSuspectDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
